/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.codehaus.enunciate.Facet;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.ui.IThemeManager;
import org.pentaho.platform.api.usersettings.IUserSettingService;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.web.http.api.resources.AbstractJaxRSResource;
import org.pentaho.platform.web.http.api.resources.Theme;

@Facet(name="Unsupported")
@Path(value="/theme")
public class ThemeResource
extends AbstractJaxRSResource {
    private IPentahoSession getPentahoSession() {
        return PentahoSessionHolder.getSession();
    }

    @GET
    @Path(value="/list")
    @Produces(value={"application/json", "application/xml"})
    @Facet(name="Unsupported")
    public List<Theme> getSystemThemes() {
        ArrayList<Theme> themes = new ArrayList<Theme>();
        IThemeManager themeManager = (IThemeManager)PentahoSystem.get(IThemeManager.class);
        List ids = themeManager.getSystemThemeIds();
        for (String id : ids) {
            org.pentaho.platform.api.ui.Theme theme = themeManager.getSystemTheme(id);
            if (theme.isHidden()) continue;
            themes.add(new Theme(id, theme.getName()));
        }
        return themes;
    }

    @POST
    @Path(value="/set")
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    @Facet(name="Unsupported")
    public Response setTheme(String theme) {
        this.getPentahoSession().setAttribute("pentaho-user-theme", (Object)theme);
        IUserSettingService settingsService = (IUserSettingService)PentahoSystem.get(IUserSettingService.class, (IPentahoSession)this.getPentahoSession());
        settingsService.setUserSetting("pentaho-user-theme", theme);
        return this.getActiveTheme();
    }

    @GET
    @Path(value="/active")
    @Produces(value={"text/plain"})
    @Facet(name="Unsupported")
    public Response getActiveTheme() {
        IUserSettingService settingsService = (IUserSettingService)PentahoSystem.get(IUserSettingService.class, (IPentahoSession)this.getPentahoSession());
        return Response.ok((Object)StringUtils.defaultIfEmpty((String)((String)this.getPentahoSession().getAttribute("pentaho-user-theme")), (String)settingsService.getUserSetting("pentaho-user-theme", PentahoSystem.getSystemSetting((String)"default-theme", (String)"ruby")).getSettingValue())).type("text/plain").build();
    }
}

