/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.spark.driver;

import java.util.concurrent.CompletableFuture;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.pentaho.di.engine.api.remote.ExecutionRequest;
import org.pentaho.di.engine.api.remote.Message;
import org.pentaho.di.engine.api.remote.MessageDecoder;
import org.pentaho.di.engine.api.remote.MessageEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientEndpoint(decoders={MessageDecoder.class}, encoders={MessageEncoder.class})
public class SparkClientEndpoint
extends Endpoint {
    private Logger LOG = LoggerFactory.getLogger(SparkClientEndpoint.class);
    private CompletableFuture<ExecutionRequest> result;

    public SparkClientEndpoint(CompletableFuture<ExecutionRequest> result) {
        this.result = result;
    }

    public void onOpen(Session session, EndpointConfig config) {
        this.LOG.info("Spark Connection Opened: {}", (Object)session.getId());
        session.addMessageHandler((MessageHandler)new MessageHandler.Whole<Message>(){

            public void onMessage(Message message) {
                SparkClientEndpoint.this.result.complete((ExecutionRequest)message);
            }
        });
    }

    public void onClose(Session session, CloseReason closeReason) {
        this.LOG.info("Spark Connection Closed: {} {}", (Object)session.getId(), (Object)closeReason);
    }
}

