/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.spark.driver;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.EncodeException;
import javax.websocket.Endpoint;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.apache.hadoop.security.UserGroupInformation;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.engine.api.Engine;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.ExecutionResult;
import org.pentaho.di.engine.api.events.ErrorEvent;
import org.pentaho.di.engine.api.events.LogEvent;
import org.pentaho.di.engine.api.events.MetricsEvent;
import org.pentaho.di.engine.api.events.PDIEvent;
import org.pentaho.di.engine.api.events.StatusEvent;
import org.pentaho.di.engine.api.model.LogicalModelElement;
import org.pentaho.di.engine.api.model.ModelType;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.api.remote.ExecutionFetchRequest;
import org.pentaho.di.engine.api.remote.ExecutionRequest;
import org.pentaho.di.engine.api.remote.MessageDecoder;
import org.pentaho.di.engine.api.remote.MessageEncoder;
import org.pentaho.di.engine.api.remote.RemoteSource;
import org.pentaho.di.engine.api.remote.StopMessage;
import org.pentaho.di.engine.api.reporting.LogEntry;
import org.pentaho.di.engine.api.reporting.LogLevel;
import org.pentaho.di.engine.api.reporting.Metrics;
import org.pentaho.di.engine.api.reporting.Status;
import org.pentaho.di.engine.api.reporting.SubTransCreation;
import org.pentaho.di.engine.model.ActingPrincipal;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.di.trans.ael.websocket.SessionConfigurator;
import org.pentaho.pdi.spark.driver.EngineLoader;
import org.pentaho.pdi.spark.driver.SparkClientEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkWebSocketMain {
    private static final Logger LOG = LoggerFactory.getLogger(SparkWebSocketMain.class);
    private final Supplier<Engine> engineSupplier;
    private final Supplier<WebSocketContainer> websocketSupplier;
    private static final long WEBSOCKET_TIMEOUT = 60L;

    private SparkWebSocketMain(Supplier<Engine> engineSupplier, Supplier<WebSocketContainer> websocketSupplier) {
        this.engineSupplier = engineSupplier;
        this.websocketSupplier = websocketSupplier;
    }

    public static void main(String[] params) throws Exception {
        ArgHandler args = new ArgHandler(params);
        LOG.debug(args.toString());
        new SparkWebSocketMain(EngineLoader::load, ContainerProvider::getWebSocketContainer).handleRequest(args);
    }

    private UserGroupInformation getUserGroupInformation(String kerbPrincipal, String kerbKeyTab, Principal actingPrinc, boolean disableProxyUser) throws IOException {
        UserGroupInformation ugi;
        if (!Strings.isNullOrEmpty((String)kerbPrincipal) && !Strings.isNullOrEmpty((String)kerbKeyTab)) {
            ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)kerbPrincipal, (String)kerbKeyTab);
            if (!disableProxyUser && !ActingPrincipal.ANONYMOUS.equals((Object)actingPrinc)) {
                ugi = UserGroupInformation.createProxyUser((String)actingPrinc.getName(), (UserGroupInformation)ugi);
            }
        } else {
            ugi = UserGroupInformation.getCurrentUser();
        }
        LOG.debug("Executing with UGI:  " + ugi.toString());
        return ugi;
    }

    private void handleRequest(ArgHandler args) {
        LOG.debug(String.format("Executing requestId %s with daemon %s", args.requestId, args.daemonURL));
        CompletableFuture<ExecutionRequest> requestMessageFuture = new CompletableFuture<ExecutionRequest>();
        Session session = this.getSession(args, requestMessageFuture);
        if (session != null) {
            try {
                session.getBasicRemote().sendObject((Object)new ExecutionFetchRequest(args.requestId));
                ExecutionRequest executionRequest = requestMessageFuture.get(60L, TimeUnit.SECONDS);
                this.getUserGroupInformation(args.proxyingUser, args.proxyKeytab, executionRequest.getActingPrincipal(), args.disableProxyUser).doAs(() -> {
                    this.executeTrans(this.engineSupplier.get(), session, executionRequest);
                    return null;
                });
                SparkWebSocketMain.shutdown(session, false);
            }
            catch (Exception e) {
                String message = "Failed to handle request " + args.requestId;
                LOG.error(message, (Throwable)e);
                SparkWebSocketMain.shutdown(session, true);
                throw new RuntimeException(message, e);
            }
        }
    }

    @VisibleForTesting
    void executeTrans(Engine engine, Session session, ExecutionRequest executionRequest) throws ExecutionException, InterruptedException {
        ExecutionResult result;
        Transformation transformation = executionRequest.getTransformation();
        ExecutionContext execContext = engine.prepare(transformation);
        execContext.setLoggingLogLevel(executionRequest.getLoggingLogLevel());
        execContext.setActingPrincipal(executionRequest.getActingPrincipal());
        execContext.setParameters(executionRequest.getParameters());
        execContext.setEnvironment(executionRequest.getEnvironment());
        this.subscribeToEvents(execContext, transformation, session);
        try {
            result = (ExecutionResult)execContext.execute().get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.fail(e, session);
            throw e;
        }
        LOG.info(result.getDataEventReport().toString());
    }

    private void subscribeToEvents(ExecutionContext execContext, Transformation transformation, Session session) {
        List<Transformation> trans = Collections.singletonList(transformation);
        this.subscribe(execContext, session, Status.class, ModelType.TRANSFORMATION, trans, StatusEvent::new);
        this.subscribe(execContext, session, LogEntry.class, ModelType.TRANSFORMATION, trans, LogEvent::new);
        ArrayList<LogicalModelElement> ops = new ArrayList<LogicalModelElement>(transformation.getOperations());
        this.subscribe(execContext, session, Status.class, ModelType.OPERATION, ops, StatusEvent::new);
        this.subscribe(execContext, session, LogEntry.class, ModelType.OPERATION, ops, LogEvent::new);
        this.subscribe(execContext, session, Metrics.class, ModelType.OPERATION, ops, MetricsEvent::new);
        ops.forEach(element -> execContext.subscribe(element, SubTransCreation.class, s -> {
            ExecutionContext subTransContext = s.getContext();
            Transformation subTrans = s.getTransformation();
            subTransContext.setLoggingLogLevel(execContext.getLoggingLogLevel());
            ArrayList<LogicalModelElement> subTransOps = new ArrayList<LogicalModelElement>(subTrans.getOperations());
            this.subscribe(subTransContext, session, LogEntry.class, ModelType.TRANSFORMATION, subTransOps, LogEvent::new);
        }));
    }

    private <T extends Serializable> void subscribe(ExecutionContext execContext, Session session, Class<T> eventType, ModelType modelType, List<LogicalModelElement> elements, EventFactory<T> eventFactory) {
        elements.forEach(element -> execContext.subscribe(element, eventType, s -> {
            try {
                if (session != null && session.isOpen()) {
                    session.getBasicRemote().sendObject((Object)eventFactory.apply(new RemoteSource(modelType, element.getId()), eventType == LogEntry.class ? this.convertLogEntryToGenericException((LogEntry)s) : s));
                } else {
                    LOG.info("Daemon server session was lost, {} event wasn't sent to the daemon.", (Object)eventType.getName());
                }
            }
            catch (IOException | EncodeException e) {
                throw new RuntimeException(e);
            }
        }, throwable -> this.handleError((Throwable)throwable, session, modelType)));
    }

    private void handleError(Throwable throwable, Session session, ModelType modelType) {
        if (modelType == ModelType.TRANSFORMATION) {
            this.fail(throwable, session);
        } else {
            LOG.error("Operation Error: ", throwable);
        }
    }

    private void fail(Throwable throwable, Session session) {
        try {
            LOG.error("Transformation Execution Error: ", throwable);
            if (session != null && session.isOpen()) {
                LogEntry logEntry = LogEntry.LogEntryBuilder.aLogEntry().withMessage(throwable.getMessage()).withLogLevel(LogLevel.ERROR).withTimestamp(new Date()).withThrowable((Throwable)this.genericException(throwable)).build();
                session.getBasicRemote().sendObject((Object)new ErrorEvent((LogicalModelElement)new RemoteSource(ModelType.TRANSFORMATION), logEntry));
            } else {
                LOG.error("Daemon server session was lost, Error event wasn't sent to the daemon.");
            }
        }
        catch (IOException | EncodeException e) {
            throw new RuntimeException(e);
        }
    }

    private org.pentaho.di.engine.api.remote.ExecutionException genericException(Throwable throwable) {
        return throwable instanceof org.pentaho.di.engine.api.remote.ExecutionException ? (org.pentaho.di.engine.api.remote.ExecutionException)throwable : new org.pentaho.di.engine.api.remote.ExecutionException(throwable);
    }

    private <T extends Serializable> T convertLogEntryToGenericException(LogEntry logEntry) {
        if (logEntry != null && logEntry.getThrowable() != null) {
            return (T)LogEntry.LogEntryBuilder.aLogEntry().withMessage(logEntry.getMessage()).withLogLevel(logEntry.getLogLogLevel()).withTimestamp(logEntry.getTimestamp()).withExtras(logEntry.getExtras()).withThrowable((Throwable)this.genericException(logEntry.getThrowable())).build();
        }
        return (T)logEntry;
    }

    private Session getSession(ArgHandler args, CompletableFuture<ExecutionRequest> requestMessageFuture) {
        try {
            ClientEndpointConfig endpointConfig = ClientEndpointConfig.Builder.create().encoders(Collections.singletonList(MessageEncoder.class)).decoders(Collections.singletonList(MessageDecoder.class)).configurator((ClientEndpointConfig.Configurator)new SessionConfigurator(new URI(args.daemonURL), args.driverSecurityKeytab, args.driverSecurityPrincipal)).build();
            return this.websocketSupplier.get().connectToServer((Endpoint)new SparkClientEndpoint(requestMessageFuture), endpointConfig, new URI(args.daemonURL + "?requestId=" + args.requestId));
        }
        catch (DeploymentException de) {
            LOG.error("Failed to connect to the AEL daemon from the Spark driver.\nVerify app properties.  \n -- Args passed to Spark:  " + args);
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to handle request " + args.requestId, e);
        }
    }

    private static void shutdown(Session session, boolean error) {
        LOG.debug("Closing Kettle & spark session");
        try {
            KettleEnvironment.shutdown();
        }
        catch (Exception e) {
            LOG.warn("Failed closing kettle environment: ", (Throwable)e);
        }
        try {
            Util.getSparkSession().close();
        }
        catch (Exception e) {
            LOG.warn("Failed closing Spark session: ", (Throwable)e);
        }
        LOG.debug("Closing Websocket Session");
        try {
            if (session != null && session.isOpen()) {
                String closeReason = error ? "Error executing transformation" : "Transformation Complete Successfully";
                session.getBasicRemote().sendObject((Object)new StopMessage(closeReason));
                session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, closeReason));
            } else {
                LOG.error("Daemon server session was lost, stop message and close reason wasn't sent to the daemon.");
            }
        }
        catch (Exception e) {
            LOG.warn("Failed closing Spark session: ", (Throwable)e);
        }
        LOG.debug("Shutting down.");
        System.exit(0);
    }

    protected static class ArgHandler {
        final String driverSecurityPrincipal;
        final String driverSecurityKeytab;
        final String requestId;
        final String daemonURL;
        final String proxyingUser;
        final String proxyKeytab;
        final boolean disableProxyUser;
        private static final int NUM_ARGS = 7;

        ArgHandler(String[] args) throws FileNotFoundException {
            this.checkArgs(args);
            this.requestId = args[0];
            this.daemonURL = args[1];
            Map<String, String> mappedParams = Arrays.stream(Arrays.copyOfRange(args, 2, 7)).collect(Collectors.toMap(this.getKey(), this.getVal()));
            this.proxyingUser = mappedParams.get("kerberosPrincipal");
            this.proxyKeytab = mappedParams.get("keytabLocation");
            this.driverSecurityPrincipal = mappedParams.get("driver.security.principal");
            this.driverSecurityKeytab = mappedParams.get("driver.security.keytabLocation");
            this.disableProxyUser = Boolean.valueOf(mappedParams.get("disableProxyUser"));
            this.checkFilesExistIfSpecified(this.proxyKeytab, this.driverSecurityKeytab);
        }

        private void checkFilesExistIfSpecified(String ... filenames) throws FileNotFoundException {
            List missingFiles = Arrays.stream(filenames).filter(((Predicate<String>)Strings::isNullOrEmpty).negate()).map(File::new).filter(((Predicate<File>)File::exists).negate()).collect(Collectors.toList());
            if (!missingFiles.isEmpty()) {
                throw new FileNotFoundException(String.format("Missing files:  %s", Arrays.toString(missingFiles.toArray())));
            }
        }

        private void checkArgs(String[] args) {
            Preconditions.checkArgument((args != null && args.length == 7 ? 1 : 0) != 0, (Object)"Expecting 7 arguments");
            Arrays.stream(Arrays.copyOfRange(args, 2, 7)).forEach(arg -> {
                String[] parts = arg.split("=");
                Preconditions.checkArgument((parts.length == 1 || parts.length == 2 ? 1 : 0) != 0, (Object)"Expecting argument of the form key=value");
            });
        }

        private Function<String, String> getKey() {
            return el -> el.split("=")[0];
        }

        private Function<String, String> getVal() {
            return val -> {
                String[] parts = val.split("=");
                return parts.length == 2 && !parts[1].equals("null") ? parts[1] : "";
            };
        }

        public String toString() {
            return String.format("ArgHandler{driverSecurityPrincipal=%s, driverSecurityKeytab=%s, requestId='%s', daemonURL='%s', proxyingUser=%s, proxyKeytab=%s}", this.driverSecurityPrincipal, this.driverSecurityKeytab, this.requestId, this.daemonURL, this.proxyingUser, this.proxyKeytab);
        }
    }

    @FunctionalInterface
    static interface EventFactory<T extends Serializable> {
        public PDIEvent apply(RemoteSource var1, T var2);
    }
}

