/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.spark.driver.app.builder;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import org.pentaho.pdi.spark.driver.app.builder.AppBuilderContext;
import org.pentaho.pdi.spark.driver.app.builder.ZipBuilder;

public class SparkDriverAssembly {
    private AppBuilderContext context;
    String[] EXTRA_EXECUTOR_EXCLUSIONS = new String[]{"**/data-integration/libswt", "**/data-integration/lib", "**/data-integration/adaptive-execution"};
    ZipBuilder driverBuilder;
    ZipBuilder executorBuilder;

    public SparkDriverAssembly(AppBuilderContext context) {
        this.context = context;
    }

    public void build() throws IOException {
        File tempDir = Files.createTempDir();
        AppBuilderContext executorContext = this.context.copy("pdi-spark-executor.zip");
        executorContext.exclude(this.EXTRA_EXECUTOR_EXCLUSIONS);
        executorContext.setOutputLocation(tempDir);
        this.executorBuilder = new ZipBuilder(executorContext);
        this.executorBuilder.compress();
        this.driverBuilder = new ZipBuilder(this.context);
        File exeZip = new File(executorContext.getOutputFilePath());
        this.driverBuilder.addExtraFile(exeZip, exeZip.getName());
        File daemonScript = new File(this.context.getPdiLocation(), "adaptive-execution/daemon.sh");
        daemonScript.setExecutable(true, true);
        this.driverBuilder.addExtraFile(daemonScript, "data-integration/adaptive-execution/" + daemonScript.getName());
        this.driverBuilder.compress();
    }
}

