/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.compendium.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.osgi.compendium.config.UpdateStrategyAttributeCallback;
import org.springframework.osgi.compendium.internal.cm.ManagedServiceFactoryFactoryBean;
import org.springframework.osgi.config.internal.util.AttributeCallback;
import org.springframework.osgi.config.internal.util.ParserUtils;
import org.springframework.osgi.config.internal.util.ServiceAttributeCallback;
import org.springframework.osgi.config.internal.util.ServiceParsingUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ManagedServiceFactoryDefinitionParser
extends AbstractSimpleBeanDefinitionParser {
    private static final String TEMPLATE_PROP = "templateDefinition";
    private static final String LISTENER = "registration-listener";
    private static final String LISTENERS_PROP = "listeners";

    ManagedServiceFactoryDefinitionParser() {
    }

    protected Class getBeanClass(Element element) {
        return ManagedServiceFactoryFactoryBean.class;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        ParserUtils.parseCustomAttributes(element, builder, new AttributeCallback[]{new ServiceAttributeCallback(), new UpdateStrategyAttributeCallback()});
        NodeList children = element.getChildNodes();
        ManagedList listeners = new ManagedList(children.getLength());
        BeanDefinition nestedDefinition = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Node nd = children.item(i);
            if (nd instanceof Element) {
                Element nestedElement = (Element)nd;
                String name = nestedElement.getLocalName();
                if (!ServiceParsingUtils.parseInterfaces(element, nestedElement, parserContext, builder)) {
                    if (LISTENER.equals(name)) {
                        listeners.add((Object)ServiceParsingUtils.parseListener(parserContext, nestedElement, builder));
                    } else {
                        String ns = nestedElement.getNamespaceURI();
                        nestedDefinition = ns == null && name.equals("bean") || ns.equals("http://www.springframework.org/schema/beans") ? parserContext.getDelegate().parseBeanDefinitionElement(nestedElement).getBeanDefinition() : parserContext.getDelegate().parseCustomElement(nestedElement);
                    }
                }
            }
            builder.addPropertyValue(TEMPLATE_PROP, (Object)new BeanDefinition[]{nestedDefinition});
            builder.addPropertyValue(LISTENERS_PROP, (Object)listeners);
        }
    }
}

