/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.Query;
import mondrian.olap.Util;
import mondrian.rolap.RestrictedMemberReader;
import mondrian.rolap.RolapCalculatedMember;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.SqlConstraintUtils;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.TupleConstraint;

public class SqlContextConstraint
implements MemberChildrenConstraint,
TupleConstraint {
    private final List<Object> cacheKey;
    private Evaluator evaluator;
    private boolean strict;

    public static boolean isValidContext(Evaluator context, boolean strict) {
        return SqlContextConstraint.isValidContext(context, true, null, strict);
    }

    public static boolean isValidContext(Evaluator context, boolean disallowVirtualCube, Level[] levels, boolean strict) {
        if (context == null) {
            return false;
        }
        RolapCube cube = (RolapCube)context.getCube();
        if (disallowVirtualCube && cube.isVirtual()) {
            return false;
        }
        if (cube.isVirtual()) {
            ArrayList<RolapCube> baseCubeList;
            HashSet<RolapCube> baseCubes;
            Query query = context.getQuery();
            if (!SqlContextConstraint.findVirtualCubeBaseCubes(query, baseCubes = new HashSet<RolapCube>(), baseCubeList = new ArrayList<RolapCube>())) {
                return false;
            }
            assert (levels != null);
            query.setBaseCubes(baseCubeList);
        }
        if (SqlConstraintUtils.measuresConflictWithMembers(context.getQuery().getMeasuresMembers(), context.getMembers())) {
            return false;
        }
        if (!strict) {
            return true;
        }
        Member[] members = context.getMembers();
        for (int i = 1; i < members.length; ++i) {
            if (!members[i].isCalculated() || SqlConstraintUtils.isSupportedCalculatedMember(members[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean findVirtualCubeBaseCubes(Query query, Set<RolapCube> baseCubes, List<RolapCube> baseCubeList) {
        Set<Member> measureMembers = query.getMeasuresMembers();
        if (measureMembers.isEmpty()) {
            Cube cube = query.getCube();
            Dimension dimension = cube.getDimensions()[0];
            query.addMeasuresMembers(dimension.getHierarchy().getDefaultMember());
        }
        for (Member member : query.getMeasuresMembers()) {
            if (member instanceof RolapStoredMeasure) {
                SqlContextConstraint.addMeasure((RolapStoredMeasure)member, baseCubes, baseCubeList);
                continue;
            }
            if (!(member instanceof RolapCalculatedMember)) continue;
            SqlContextConstraint.findMeasures(member.getExpression(), baseCubes, baseCubeList);
        }
        return !baseCubes.isEmpty();
    }

    private static void addMeasure(RolapStoredMeasure measure, Set<RolapCube> baseCubes, List<RolapCube> baseCubeList) {
        RolapCube baseCube = measure.getCube();
        if (baseCubes.add(baseCube)) {
            baseCubeList.add(baseCube);
        }
    }

    private static void findMeasures(Exp exp, Set<RolapCube> baseCubes, List<RolapCube> baseCubeList) {
        block4: {
            block2: {
                Member member;
                block3: {
                    if (!(exp instanceof MemberExpr)) break block2;
                    MemberExpr memberExpr = (MemberExpr)exp;
                    member = memberExpr.getMember();
                    if (!(member instanceof RolapStoredMeasure)) break block3;
                    SqlContextConstraint.addMeasure((RolapStoredMeasure)member, baseCubes, baseCubeList);
                    break block4;
                }
                if (!(member instanceof RolapCalculatedMember)) break block4;
                SqlContextConstraint.findMeasures(member.getExpression(), baseCubes, baseCubeList);
                break block4;
            }
            if (exp instanceof ResolvedFunCall) {
                Exp[] args;
                ResolvedFunCall funCall = (ResolvedFunCall)exp;
                for (Exp arg : args = funCall.getArgs()) {
                    SqlContextConstraint.findMeasures(arg, baseCubes, baseCubeList);
                }
            }
        }
    }

    SqlContextConstraint(RolapEvaluator evaluator, boolean strict) {
        this.evaluator = evaluator.push();
        this.strict = strict;
        this.cacheKey = new ArrayList<Object>();
        this.cacheKey.add(this.getClass());
        this.cacheKey.add(strict);
        ArrayList<Member> members = new ArrayList<Member>();
        ArrayList<Member> expandedMembers = new ArrayList<Member>();
        members.addAll(Arrays.asList(SqlConstraintUtils.expandMultiPositionSlicerMembers(evaluator.getMembers(), evaluator)));
        expandedMembers.addAll(SqlConstraintUtils.expandSupportedCalculatedMembers(members, evaluator).getMembers());
        this.cacheKey.add(expandedMembers);
        this.cacheKey.add(evaluator.getSlicerTuples());
        Map<Level, List<RolapMember>> roleMembers = SqlConstraintUtils.getRoleConstraintMembers(this.getEvaluator().getSchemaReader(), this.getEvaluator().getMembers());
        for (List<RolapMember> list : roleMembers.values()) {
            this.cacheKey.addAll(list);
        }
        if (evaluator.getCube().isVirtual()) {
            this.cacheKey.addAll(evaluator.getQuery().getBaseCubes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMemberConstraint(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar, RolapMember parent) {
        if (parent.isCalculated()) {
            throw Util.newInternal("cannot restrict SQL to calculated member");
        }
        int savepoint = this.evaluator.savepoint();
        try {
            this.evaluator.setContext(parent);
            SqlConstraintUtils.addContextConstraint(sqlQuery, aggStar, this.evaluator, baseCube, this.strict);
        }
        finally {
            this.evaluator.restore(savepoint);
        }
        SqlConstraintUtils.addMemberConstraint(sqlQuery, baseCube, aggStar, parent, true);
    }

    @Override
    public void addMemberConstraint(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar, List<RolapMember> parents) {
        SqlConstraintUtils.addContextConstraint(sqlQuery, aggStar, this.evaluator, baseCube, this.strict);
        boolean exclude = false;
        SqlConstraintUtils.addMemberConstraint(sqlQuery, baseCube, aggStar, parents, true, false, exclude);
    }

    @Override
    public void addConstraint(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar) {
        SqlConstraintUtils.addContextConstraint(sqlQuery, aggStar, this.evaluator, baseCube, this.strict);
    }

    protected boolean isJoinRequired() {
        Member[] members = this.evaluator.getMembers();
        for (int i = 1; i < members.length; ++i) {
            if (members[i].isAll() && !(members[i] instanceof RolapHierarchy.LimitedRollupMember) && !(members[i] instanceof RestrictedMemberReader.MultiCardinalityDefaultMember)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addLevelConstraint(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar, RolapLevel level) {
        if (!this.isJoinRequired()) {
            return;
        }
        SqlConstraintUtils.joinLevelTableToFactTable(sqlQuery, baseCube, aggStar, this.evaluator, (RolapCubeLevel)level);
    }

    @Override
    public MemberChildrenConstraint getMemberChildrenConstraint(RolapMember parent) {
        return this;
    }

    @Override
    public Object getCacheKey() {
        return this.cacheKey;
    }

    @Override
    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    @Override
    public boolean supportsAggTables() {
        return true;
    }
}

