/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.configuration.impl.spark;

import java.io.IOException;
import java.net.URI;
import java.util.Dictionary;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.pentaho.capabilities.api.ICapability;
import org.pentaho.capabilities.api.ICapabilityManager;
import org.pentaho.capabilities.impl.DefaultCapabilityManager;
import org.pentaho.di.ExecutionConfiguration;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.engine.configuration.api.RunConfiguration;
import org.pentaho.di.engine.configuration.api.RunConfigurationExecutor;
import org.pentaho.di.engine.configuration.impl.spark.SparkRunConfiguration;
import org.pentaho.di.repository.Repository;

public class SparkRunConfigurationExecutor
implements RunConfigurationExecutor {
    public static String PENTAHO_SERVER_CAPABILITY_ID = "pentaho-server";
    public static String CONFIG_KEY = "org.apache.aries.rsa.discovery.zookeeper";
    public static String JAAS_CAPABILITY_ID = "pentaho-kerberos-jaas";
    public static String AEL_SECURITY_CAPABILITY_ID = "ael-security";
    public static String DEFAULT_PROTOCOL = "http";
    public static String DEFAULT_HOST = "127.0.0.1";
    public static String DEFAULT_ZOOKEEPER_PORT = "2181";
    public static String DEFAULT_WEBSOCKET_PORT = "53000";
    private ConfigurationAdmin configurationAdmin;
    private ICapabilityManager capabilityManager = DefaultCapabilityManager.getInstance();

    public SparkRunConfigurationExecutor(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public void execute(RunConfiguration runConfiguration, ExecutionConfiguration configuration, AbstractMeta meta, VariableSpace variableSpace, Repository repository) {
        boolean serverMode;
        ICapability securityCapability = this.capabilityManager.getCapabilityById(AEL_SECURITY_CAPABILITY_ID);
        ICapability jaasCapability = this.capabilityManager.getCapabilityById(JAAS_CAPABILITY_ID);
        if (securityCapability != null && securityCapability.isInstalled() && jaasCapability != null && !jaasCapability.isInstalled()) {
            jaasCapability.install();
        }
        SparkRunConfiguration sparkRunConfiguration = (SparkRunConfiguration)runConfiguration;
        String runConfigSchema = Const.NVL((String)sparkRunConfiguration.getSchema(), (String)"");
        String runConfigURL = Const.NVL((String)sparkRunConfiguration.getUrl(), (String)"");
        URI uri = URI.create(runConfigSchema.trim() + runConfigURL.trim());
        String protocol = uri.getScheme();
        String host = uri.getHost();
        String port = uri.getPort() == -1 ? null : String.valueOf(uri.getPort());
        String version = variableSpace.getVariable("KETTLE_AEL_PDI_DAEMON_VERSION", "2.0");
        boolean version2 = Const.toDouble((String)version, (double)1.0) >= 2.0;
        boolean bl = serverMode = this.capabilityManager.getCapabilityById(PENTAHO_SERVER_CAPABILITY_ID) != null;
        if (version2) {
            variableSpace.setVariable("engine.protocol", Const.NVL((String)protocol, (String)DEFAULT_PROTOCOL));
            variableSpace.setVariable("engine.host", Const.NVL((String)host, (String)DEFAULT_HOST));
            variableSpace.setVariable("engine.port", Const.NVL((String)port, (String)DEFAULT_WEBSOCKET_PORT));
        }
        if (!serverMode) {
            try {
                Configuration zookeeperConfiguration = this.configurationAdmin.getConfiguration(CONFIG_KEY);
                Dictionary properties = zookeeperConfiguration.getProperties();
                if (properties != null) {
                    if (!version2) {
                        properties.put("zookeeper.host", Const.NVL((String)host, (String)DEFAULT_HOST));
                        properties.put("zookeeper.port", Const.NVL((String)port, (String)DEFAULT_ZOOKEEPER_PORT));
                        variableSpace.setVariable("engine.protocol", null);
                        variableSpace.setVariable("engine.host", null);
                        variableSpace.setVariable("engine.port", null);
                    } else {
                        properties.remove("zookeeper.host");
                        properties.remove("zookeeper.port");
                    }
                    zookeeperConfiguration.update(properties);
                }
            }
            catch (IOException ioe) {
                System.out.println("Error occurred accessing configuration");
            }
        }
        variableSpace.setVariable("engine", "remote");
        variableSpace.setVariable("engine.remote", "spark");
    }
}

