/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.S3AInstrumentation;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.s3guard.DirListingMetadata;
import org.apache.hadoop.fs.s3a.s3guard.DynamoDBClientFactory;
import org.apache.hadoop.fs.s3a.s3guard.MetadataStore;
import org.apache.hadoop.fs.s3a.s3guard.NullMetadataStore;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadata;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class S3Guard {
    private static final Logger LOG = LoggerFactory.getLogger(S3Guard.class);
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    public static final String S3GUARD_DDB_CLIENT_FACTORY_IMPL = "fs.s3a.s3guard.ddb.client.factory.impl";
    static final Class<? extends DynamoDBClientFactory> S3GUARD_DDB_CLIENT_FACTORY_IMPL_DEFAULT = DynamoDBClientFactory.DefaultDynamoDBClientFactory.class;
    private static final FileStatus[] EMPTY_LISTING = new FileStatus[0];

    private S3Guard() {
    }

    public static MetadataStore getMetadataStore(FileSystem fs) throws IOException {
        Preconditions.checkNotNull((Object)fs);
        Configuration conf = fs.getConf();
        Preconditions.checkNotNull((Object)conf);
        try {
            Class<? extends MetadataStore> msClass = S3Guard.getMetadataStoreClass(conf);
            MetadataStore msInstance = (MetadataStore)ReflectionUtils.newInstance(msClass, (Configuration)conf);
            LOG.debug("Using {} metadata store for {} filesystem", (Object)msClass.getSimpleName(), (Object)fs.getScheme());
            msInstance.initialize(fs);
            return msInstance;
        }
        catch (IOException | RuntimeException e) {
            String message = "Failed to instantiate metadata store " + conf.get("fs.s3a.metadatastore.impl") + " defined in " + "fs.s3a.metadatastore.impl" + ": " + e;
            LOG.error(message, (Throwable)e);
            if (e instanceof IOException) {
                throw e;
            }
            throw new IOException(message, e);
        }
    }

    private static Class<? extends MetadataStore> getMetadataStoreClass(Configuration conf) {
        if (conf == null) {
            return NullMetadataStore.class;
        }
        return conf.getClass("fs.s3a.metadatastore.impl", NullMetadataStore.class, MetadataStore.class);
    }

    public static S3AFileStatus putAndReturn(MetadataStore ms, S3AFileStatus status, S3AInstrumentation instrumentation) throws IOException {
        long startTimeNano = System.nanoTime();
        ms.put(new PathMetadata(status));
        instrumentation.addValueToQuantiles(Statistic.S3GUARD_METADATASTORE_PUT_PATH_LATENCY, System.nanoTime() - startTimeNano);
        instrumentation.incrementCounter(Statistic.S3GUARD_METADATASTORE_PUT_PATH_REQUEST, 1L);
        return status;
    }

    public static FileStatus[] dirMetaToStatuses(DirListingMetadata dirMeta) {
        if (dirMeta == null) {
            return EMPTY_LISTING;
        }
        Collection<PathMetadata> listing = dirMeta.getListing();
        ArrayList<FileStatus> statuses = new ArrayList<FileStatus>();
        for (PathMetadata pm : listing) {
            if (pm.isDeleted()) continue;
            statuses.add(pm.getFileStatus());
        }
        return statuses.toArray(new FileStatus[0]);
    }

    public static FileStatus[] dirListingUnion(MetadataStore ms, Path path, List<FileStatus> backingStatuses, DirListingMetadata dirMeta, boolean isAuthoritative) throws IOException {
        if (ms instanceof NullMetadataStore) {
            return backingStatuses.toArray(new FileStatus[backingStatuses.size()]);
        }
        S3Guard.assertQualified(path);
        if (dirMeta == null) {
            dirMeta = new DirListingMetadata(path, DirListingMetadata.EMPTY_DIR, false);
        }
        Set<Path> deleted = dirMeta.listTombstones();
        boolean changed = false;
        for (FileStatus s : backingStatuses) {
            if (deleted.contains(s.getPath())) continue;
            boolean updated = dirMeta.put(s);
            changed = changed || updated;
        }
        if (changed && isAuthoritative) {
            dirMeta.setAuthoritative(true);
            ms.put(dirMeta);
        }
        return S3Guard.dirMetaToStatuses(dirMeta);
    }

    public static boolean isNullMetadataStore(MetadataStore ms) {
        return ms instanceof NullMetadataStore;
    }

    public static void makeDirsOrdered(MetadataStore ms, List<Path> dirs, String owner) {
        if (dirs == null) {
            return;
        }
        S3AFileStatus prevStatus = null;
        for (int i = 0; i < dirs.size(); ++i) {
            Collection<PathMetadata> children;
            boolean isLeaf = prevStatus == null;
            Path f = dirs.get(i);
            S3Guard.assertQualified(f);
            S3AFileStatus status = S3AUtils.createUploadFileStatus(f, true, 0L, 0L, owner);
            if (isLeaf) {
                children = DirListingMetadata.EMPTY_DIR;
            } else {
                children = new ArrayList<PathMetadata>(1);
                children.add(new PathMetadata(prevStatus));
            }
            DirListingMetadata dirMeta = new DirListingMetadata(f, children, true);
            try {
                ms.put(dirMeta);
                ms.put(new PathMetadata(status));
            }
            catch (IOException ioe) {
                LOG.error("MetadataStore#put() failure:", (Throwable)ioe);
                return;
            }
            prevStatus = status;
        }
    }

    public static void addMoveDir(MetadataStore ms, Collection<Path> srcPaths, Collection<PathMetadata> dstMetas, Path srcPath, Path dstPath, String owner) {
        if (S3Guard.isNullMetadataStore(ms)) {
            return;
        }
        S3Guard.assertQualified(srcPath);
        S3Guard.assertQualified(dstPath);
        S3AFileStatus dstStatus = S3AUtils.createUploadFileStatus(dstPath, true, 0L, 0L, owner);
        S3Guard.addMoveStatus(srcPaths, dstMetas, srcPath, dstStatus);
    }

    public static void addMoveFile(MetadataStore ms, Collection<Path> srcPaths, Collection<PathMetadata> dstMetas, Path srcPath, Path dstPath, long size, long blockSize, String owner) {
        if (S3Guard.isNullMetadataStore(ms)) {
            return;
        }
        S3Guard.assertQualified(srcPath);
        S3Guard.assertQualified(dstPath);
        S3AFileStatus dstStatus = S3AUtils.createUploadFileStatus(dstPath, false, size, blockSize, owner);
        S3Guard.addMoveStatus(srcPaths, dstMetas, srcPath, dstStatus);
    }

    public static void addMoveAncestors(MetadataStore ms, Collection<Path> srcPaths, Collection<PathMetadata> dstMetas, Path srcRoot, Path srcPath, Path dstPath, String owner) {
        if (S3Guard.isNullMetadataStore(ms)) {
            return;
        }
        S3Guard.assertQualified(srcRoot);
        S3Guard.assertQualified(srcPath);
        S3Guard.assertQualified(dstPath);
        if (srcPath.equals((Object)srcRoot)) {
            LOG.debug("Skip moving ancestors of source root directory {}", (Object)srcRoot);
            return;
        }
        Path parentSrc = srcPath.getParent();
        Path parentDst = dstPath.getParent();
        while (!(parentSrc == null || parentSrc.isRoot() || parentSrc.equals((Object)srcRoot) || srcPaths.contains(parentSrc))) {
            LOG.debug("Renaming non-listed parent {} to {}", (Object)parentSrc, (Object)parentDst);
            S3Guard.addMoveDir(ms, srcPaths, dstMetas, parentSrc, parentDst, owner);
            parentSrc = parentSrc.getParent();
            parentDst = parentDst.getParent();
        }
    }

    private static void addMoveStatus(Collection<Path> srcPaths, Collection<PathMetadata> dstMetas, Path srcPath, FileStatus dstStatus) {
        srcPaths.add(srcPath);
        dstMetas.add(new PathMetadata(dstStatus));
    }

    public static void assertQualified(Path p) {
        URI uri = p.toUri();
        Preconditions.checkNotNull((Object)uri.getHost(), (Object)("Null host in " + uri));
        Preconditions.checkNotNull((Object)uri.getScheme(), (Object)("Null scheme in " + uri));
    }
}

