/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.compress.CompressionPluginType;
import org.pentaho.di.core.encryption.TwoWayPasswordEncoderPluginType;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.extension.ExtensionPointPluginType;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.KettleLoggingEventListener;
import org.pentaho.di.core.plugins.DatabasePluginType;
import org.pentaho.di.core.plugins.EnginePluginType;
import org.pentaho.di.core.plugins.ImportRulePluginType;
import org.pentaho.di.core.plugins.KettleLifecyclePluginType;
import org.pentaho.di.core.plugins.LifecyclePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeListener;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.value.ValueMetaPluginType;
import org.pentaho.di.engine.api.Engine;
import org.pentaho.di.engine.spark.impl.listeners.LoggingToAccumAdapter;
import org.pentaho.di.engine.spark.util.Util;
import org.pentaho.platform.servicecoordination.api.IServiceBarrier;
import org.pentaho.platform.servicecoordination.impl.ServiceBarrierManager;

public class SystemManager {
    public static final String SPARK_DRIVER_SERVICE_BARRIER_ID = "SPARK_DRIVER";
    private static final String HADOOP_FILE_OUTPUT_PLUGIN = "HadoopFileOutputPlugin";
    private static final String TEXT_FILE_OUTPUT_PLUGIN = "TextFileOutput";
    private static final String HADOOP_FILE_INPUT_PLUGIN = "HadoopFileInputPlugin";
    private static final String TEXT_FILE_INPUT_PLUGIN = "TextFileInput";
    protected static final AtomicReference<SystemManager> instance = new AtomicReference();
    private final AtomicReference<CompletableFuture<Void>> environmentInitialized = new AtomicReference();
    private final ConcurrentMap<String, CompletableFuture<Engine>> engineMap = Maps.newConcurrentMap();

    public static SystemManager getInstance() {
        return instance.updateAndGet(systemManager -> Optional.ofNullable(systemManager).orElseGet(SystemManager::new));
    }

    protected SystemManager() {
        if (KettleEnvironment.isInitialized()) {
            this.environmentInitialized.set(CompletableFuture.completedFuture(null));
        }
    }

    public PluginRegistry getPluginRegistry() {
        this.initializeOnce();
        return PluginRegistry.getInstance();
    }

    public IServiceBarrier getServiceBarrier() {
        this.initializeOnce();
        return ServiceBarrierManager.LOCATOR.getManager().getServiceBarrier(SPARK_DRIVER_SERVICE_BARRIER_ID);
    }

    public void initializeOnce() {
        CompletableFuture future = new CompletableFuture();
        if (this.environmentInitialized.compareAndSet(null, future)) {
            try {
                PluginRegistry.getInstance().addPluginListener(EnginePluginType.class, (PluginTypeListener)new EngineTracker());
                SystemManager.initKettleEnvironment();
                future.complete(null);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        }
        try {
            this.environmentInitialized.get().join();
        }
        catch (CompletionException e) {
            throw new IllegalStateException(e.getCause());
        }
    }

    public CompletableFuture<Engine> loadEngine(String id) {
        this.initializeOnce();
        return this.getEngineFuture(id);
    }

    private static void initKettleEnvironment() throws KettleException {
        String clientId = "spark";
        if (System.getProperty("isExecutor", "false").equalsIgnoreCase("true")) {
            clientId = "spark-executor";
            File assembly = SystemManager.findExecutorAssembly();
            File dataIntegration = new File(assembly, "data-integration");
            System.setProperty("pentaho.user.dir", dataIntegration.getAbsolutePath());
            System.setProperty("KETTLE_PLUGIN_BASE_FOLDERS", dataIntegration.getAbsolutePath());
        }
        KettleClientEnvironment.getInstance().setClient(KettleClientEnvironment.ClientType.OTHER);
        KettleClientEnvironment.getInstance().setClientID(clientId);
        KettleClientEnvironment.init(Arrays.asList(ValueMetaPluginType.getInstance(), DatabasePluginType.getInstance(), ExtensionPointPluginType.getInstance(), TwoWayPasswordEncoderPluginType.getInstance()));
        KettleEnvironment.init(Arrays.asList(StepPluginType.getInstance(), EnginePluginType.getInstance(), LifecyclePluginType.getInstance(), KettleLifecyclePluginType.getInstance(), ImportRulePluginType.getInstance(), CompressionPluginType.getInstance()), (boolean)false);
        KettleLogStore.getAppender().addLoggingEventListener((KettleLoggingEventListener)LoggingToAccumAdapter.getInstance());
        Util.overridePlugin(HADOOP_FILE_INPUT_PLUGIN, TEXT_FILE_INPUT_PLUGIN);
        Util.overridePlugin(HADOOP_FILE_OUTPUT_PLUGIN, TEXT_FILE_OUTPUT_PLUGIN);
    }

    private CompletableFuture<Engine> getEngineFuture(String id) {
        return this.engineMap.computeIfAbsent(id, any -> new CompletableFuture());
    }

    private static File findExecutorAssembly() {
        File folder = new File(".");
        return folder.listFiles(path -> path.isDirectory() && path.getName().startsWith("pdi-") && path.getName().endsWith(".zip"))[0];
    }

    private class EngineTracker
    implements PluginTypeListener {
        private EngineTracker() {
        }

        public void pluginAdded(Object serviceObject) {
            PluginRegistry pluginRegistry = PluginRegistry.getInstance();
            PluginInterface pluginInterface = (PluginInterface)serviceObject;
            try {
                Engine engine = (Engine)Objects.requireNonNull(pluginRegistry.loadClass(pluginInterface, Engine.class));
                for (String id : pluginInterface.getIds()) {
                    SystemManager.this.getEngineFuture(id).complete(engine);
                }
            }
            catch (KettlePluginException e) {
                for (String id : pluginInterface.getIds()) {
                    SystemManager.this.getEngineFuture(id).completeExceptionally(e);
                }
            }
        }

        public void pluginRemoved(Object serviceObject) {
            PluginInterface pluginInterface = (PluginInterface)serviceObject;
            for (String id : pluginInterface.getIds()) {
                SystemManager.this.engineMap.remove(id);
            }
        }

        public void pluginChanged(Object serviceObject) {
        }
    }
}

