/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.accumulators;

import io.reactivex.subjects.Subject;
import java.io.Serializable;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.util.CollectionAccumulator;
import org.pentaho.di.engine.api.reporting.LogEntry;
import org.pentaho.di.engine.spark.impl.listeners.LoggingToAccumAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogEntryAccumulator
implements Serializable {
    private static final long serialVersionUID = 5176168312302301287L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final CollectionAccumulator<LogEntry> accumulator = new CollectionAccumulator();
    private final Subject<LogEntry> loggingSubject;
    private final String operationId;

    private LogEntryAccumulator(JavaSparkContext javaSparkContext, Subject<LogEntry> loggingSubject, String operationId) {
        this.loggingSubject = loggingSubject;
        this.operationId = operationId;
        javaSparkContext.sc().register(this.accumulator);
        this.logger.debug("Registering LogEntryAccumulator: " + operationId + " with id: " + this.accumulator.id());
        LoggingToAccumAdapter.getInstance().addAccumulator(operationId, this.accumulator);
    }

    public static LogEntryAccumulator getTransformationLogging(JavaSparkContext javaSparkContext, Subject<LogEntry> loggingSubject) {
        return new LogEntryAccumulator(javaSparkContext, loggingSubject, "trans_logging");
    }

    public static LogEntryAccumulator getOperationLogging(JavaSparkContext javaSparkContext, Subject<LogEntry> loggingSubject, String operationId) {
        return new LogEntryAccumulator(javaSparkContext, loggingSubject, operationId);
    }

    public CollectionAccumulator<LogEntry> getAccumulator() {
        return this.accumulator;
    }

    public String getOperationId() {
        return this.operationId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLogs() {
        if (this.accumulator.value().size() > 0) {
            this.logger.debug("Logging Accumulator has values: " + this.accumulator.value().size() + " for operation: " + this.operationId);
            CollectionAccumulator<LogEntry> collectionAccumulator = this.accumulator;
            synchronized (collectionAccumulator) {
                this.accumulator.value().forEach(arg_0 -> this.loggingSubject.onNext(arg_0));
                this.accumulator.reset();
                this.logger.debug("Logging Accumulator reset: " + this.accumulator.value().size() + " operation: " + this.operationId);
            }
        }
    }
}

