/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.accumulators;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.util.LongAccumulator;

public class MetricsAccumulator
implements Serializable {
    private static final long serialVersionUID = -7490938085270064651L;
    private static final MetricsAccumulator EMPTY = new MetricsAccumulator();
    private LongAccumulator rowIn;
    private LongAccumulator rowOut;
    private LongAccumulator rowError;
    private LongAccumulator rowInflight;
    private String operationID;
    private boolean countRowIn = true;

    private MetricsAccumulator() {
        this.operationID = null;
        this.rowIn = null;
        this.rowOut = null;
        this.rowError = null;
        this.rowInflight = null;
    }

    public MetricsAccumulator(JavaSparkContext javaSparkContext, String operationID) {
        this.operationID = operationID;
        this.rowIn = javaSparkContext.sc().longAccumulator();
        this.rowOut = javaSparkContext.sc().longAccumulator();
        this.rowError = javaSparkContext.sc().longAccumulator();
        this.rowInflight = javaSparkContext.sc().longAccumulator();
    }

    public static MetricsAccumulator empty() {
        return EMPTY;
    }

    public boolean isEmpty() {
        return this.rowIn == null;
    }

    public String getOperationID() {
        return this.operationID;
    }

    public void addRowIn() {
        if (this.countRowIn && !this.isEmpty()) {
            this.rowIn.add(1L);
        }
    }

    public void addRowOut() {
        if (!this.isEmpty()) {
            this.rowOut.add(1L);
        }
    }

    public void addRowError() {
        if (!this.isEmpty()) {
            this.rowError.add(1L);
        }
    }

    public void addRowInFlight() {
        if (!this.isEmpty()) {
            this.rowInflight.add(1L);
        }
    }

    public long getRowIn() {
        return this.rowIn == null ? -1L : this.rowIn.value();
    }

    public long getRowOut() {
        return this.rowOut == null ? -1L : this.rowOut.value();
    }

    public long getRowError() {
        return this.rowError == null ? -1L : this.rowError.value();
    }

    public long getRowInFlight() {
        return this.rowInflight == null ? -1L : this.rowInflight.value();
    }

    public void setCountRowIn(boolean value) {
        if (!this.isEmpty()) {
            this.countRowIn = value;
        }
    }

    public boolean countRowIn() {
        return this.countRowIn;
    }

    @VisibleForTesting
    public void setRowOut(long nRows) {
        if (!this.isEmpty()) {
            this.rowOut.setValue(nRows);
        }
    }
}

