/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.events;

import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.pentaho.di.engine.spark.impl.listeners.LoggingToAccumAdapter;
import org.pentaho.di.engine.spark.impl.logger.FunctionLogger;

public class OperationErrorEvent
implements SparkListenerEvent {
    private String operation;
    private Throwable throwable;

    public OperationErrorEvent(String operation, Throwable throwable) {
        this.operation = operation;
        this.throwable = throwable;
    }

    public String getOperation() {
        return this.operation;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public boolean logEvent() {
        return true;
    }

    public static void sendEvent(JavaSparkContext sparkContext, String sparkOperation, Throwable throwable) {
        new FunctionLogger(LoggingToAccumAdapter.getInstance().getAccumulator(sparkOperation)).error(throwable != null ? throwable.getMessage() : "Error", throwable);
        sparkContext.sc().listenerBus().postToAll((Object)new OperationErrorEvent(sparkOperation, throwable));
    }
}

