/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.execution;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import io.reactivex.Observable;
import io.reactivex.observables.ConnectableObservable;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.util.AccumulatorV2;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.engine.api.model.Hop;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.reporting.Status;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.execution.DriverTask;
import org.pentaho.di.engine.spark.impl.execution.OperationDependency;
import org.pentaho.di.engine.spark.impl.execution.TaskObservable;

public class ExecutionPlan {
    private final ImmutableMap<String, TaskObservable> sparkOperations;
    private final ImmutableTable<SparkOperation, SparkOperation, OperationDependency> dependencyTable;
    private final ConnectableObservable<DriverTask> driverTasks;

    ExecutionPlan(Map<String, TaskObservable> sparkOperations, ImmutableTable<SparkOperation, SparkOperation, OperationDependency> dependencyTable) {
        this.sparkOperations = ImmutableMap.copyOf(sparkOperations);
        this.dependencyTable = ImmutableTable.copyOf(dependencyTable);
        this.driverTasks = Observable.merge(sparkOperations.values()).publish();
    }

    public ImmutableMap<String, TaskObservable> getMaterializedOperations() {
        return this.sparkOperations;
    }

    public ImmutableTable<SparkOperation, SparkOperation, OperationDependency> getDependencyTable() {
        return this.dependencyTable;
    }

    public ConnectableObservable<DriverTask> getDriverTasks() {
        return this.driverTasks;
    }

    public Observable<Status> getStatus() {
        return this.driverTasks.materialize().map(notification -> {
            if (notification.isOnComplete()) {
                return Status.FINISHED;
            }
            if (notification.isOnError()) {
                return Status.FAILED;
            }
            return Status.RUNNING;
        }).distinctUntilChanged().takeUntil(Status::isFinal);
    }

    public static class Builder {
        private static LogChannelInterface logChannel = KettleLogStore.getLogChannelInterfaceFactory().create(ExecutionPlan.class);
        private JavaSparkContext sparkContext;
        private final Map<String, SparkOperation> sparkOperations = Maps.newHashMap();
        private final Table<String, String, String> depGraph = HashBasedTable.create();
        private final Map<String, AccumulatorV2<?, ?>> accumulators = Maps.newHashMap();

        public Builder(JavaSparkContext javaSparkContext) {
            this.sparkContext = javaSparkContext;
        }

        public Builder add(Collection<? extends Operation> operations, Function<? super Operation, ? extends SparkOperation> compiler) {
            operations.forEach(operation -> this.add((Operation)operation, compiler));
            return this;
        }

        public Builder add(Operation operation, Function<? super Operation, ? extends SparkOperation> compiler) {
            this.add(compiler.apply((Operation)operation));
            Stream.of(operation.getHopsIn(), operation.getHopsOut()).flatMap(Collection::stream).forEach(this::addDependency);
            return this;
        }

        public Builder add(SparkOperation sparkOperation) {
            String id = Objects.requireNonNull(sparkOperation.getId());
            Preconditions.checkState((!this.sparkOperations.containsKey(id) ? 1 : 0) != 0, (String)"Duplicate spark operation id: ", (Object[])new Object[]{id});
            this.sparkOperations.put(id, sparkOperation);
            return this;
        }

        public Builder addDependency(String from, String to, String type) {
            this.depGraph.put((Object)from, (Object)to, (Object)type);
            return this;
        }

        public Builder addDependency(Hop hop) {
            return this.addDependency(hop.getFrom().getId(), hop.getTo().getId(), hop.getType());
        }

        public Builder addAccumulator(String key, AccumulatorV2<?, ?> accumulator) {
            this.accumulators.put(key, accumulator);
            return this;
        }

        public ExecutionPlan build(JavaSparkContext sparkContext) {
            logChannel.logDebug("Creating the run plan");
            Set undefined = Stream.of(this.depGraph.columnKeySet(), this.depGraph.rowKeySet()).flatMap(Collection::stream).filter(id -> !this.sparkOperations.containsKey(id)).collect(Collectors.toSet());
            Preconditions.checkState((boolean)undefined.isEmpty(), (String)"Operations referenced, but not defined: ", (Object[])new Object[]{undefined});
            ImmutableTable dependencyTable = this.depGraph.cellSet().stream().map(cell -> {
                SparkOperation from = this.sparkOperations.get(cell.getRowKey());
                SparkOperation to = this.sparkOperations.get(cell.getColumnKey());
                OperationDependency operationDependency = new OperationDependency(from, to, (String)cell.getValue());
                return ImmutableTable.of((Object)from, (Object)to, (Object)operationDependency);
            }).collect(ImmutableTable::builder, ImmutableTable.Builder::putAll, (left, right) -> left.putAll((Table)right.build())).build();
            Map<String, TaskObservable> taskObservables = this.sparkOperations.keySet().stream().collect(Collectors.toMap(id -> id, id -> TaskObservable.create(sparkContext, this.sparkOperations.get(id), (Table<SparkOperation, SparkOperation, OperationDependency>)dependencyTable, this.accumulators)));
            return new ExecutionPlan(taskObservables, (ImmutableTable<SparkOperation, SparkOperation, OperationDependency>)dependencyTable);
        }
    }
}

