/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.execution;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.observers.DisposableCompletableObserver;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.BehaviorSubject;
import io.reactivex.subjects.ReplaySubject;
import io.reactivex.subjects.Subject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.util.AccumulatorV2;
import org.pentaho.di.engine.api.ExecutionContext;
import org.pentaho.di.engine.api.model.Row;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.api.reporting.LogEntry;
import org.pentaho.di.engine.api.reporting.Metrics;
import org.pentaho.di.engine.api.reporting.Status;
import org.pentaho.di.engine.api.reporting.SubTransCreation;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.accumulators.LogEntryAccumulator;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.impl.events.FinalOperationEvent;
import org.pentaho.di.engine.spark.impl.events.OperationErrorEvent;
import org.pentaho.di.engine.spark.impl.execution.DriverTask;
import org.pentaho.di.engine.spark.impl.execution.OperationDependency;
import org.pentaho.di.engine.spark.impl.listeners.LoggingAccumSparkListener;
import org.pentaho.di.engine.spark.impl.listeners.OperationEventListener;
import org.pentaho.di.engine.spark.impl.logger.OperationLogger;
import org.pentaho.di.engine.spark.util.Util;

public class TaskObservable
implements ObservableSource<DriverTask> {
    private final JavaSparkContext sparkContext;
    private final SparkOperation sparkOperation;
    private final ImmutableMap<SparkOperation, OperationDependency> sources;
    private final ImmutableMap<SparkOperation, OperationDependency> targets;
    private final Subject<DriverTask> driverTasks = ReplaySubject.create();
    private final BehaviorSubject<Status> statusSubject = BehaviorSubject.create();
    private final BehaviorSubject<Metrics> metricsSubject = BehaviorSubject.createDefault((Object)Metrics.empty());
    private ReplaySubject<LogEntry> loggingSubject = ReplaySubject.createWithTimeAndSize((long)30L, (TimeUnit)TimeUnit.SECONDS, (Scheduler)Schedulers.trampoline(), (int)1000);
    private ReplaySubject<SubTransCreation> subTransSubject = ReplaySubject.createWithTimeAndSize((long)30L, (TimeUnit)TimeUnit.SECONDS, (Scheduler)Schedulers.trampoline(), (int)1000);
    private final AtomicBoolean started = new AtomicBoolean();
    private final Set<DriverTask> activeTasks = Sets.newSetFromMap((Map)Maps.newConcurrentMap());
    private Map<String, AccumulatorV2> accumulators = new HashMap<String, AccumulatorV2>();
    private MetricsAccumulator metricsAccumulator;
    private final Supplier<OperationLogger> opLogger = Suppliers.memoize(() -> new OperationLogger(this.loggingSubject));

    public static TaskObservable create(JavaSparkContext sparkContext, SparkOperation sparkOperation, Table<SparkOperation, SparkOperation, OperationDependency> dependencyTable, Map<String, AccumulatorV2<?, ?>> accumulators) {
        Map sources = dependencyTable.column((Object)sparkOperation);
        Map targets = dependencyTable.row((Object)sparkOperation);
        return new TaskObservable(sparkContext, sparkOperation, sources, targets, accumulators);
    }

    private TaskObservable(JavaSparkContext sparkContext, SparkOperation sparkOperation, Map<SparkOperation, OperationDependency> sources, Map<SparkOperation, OperationDependency> targets, Map<String, AccumulatorV2<?, ?>> accumulators) {
        this.sparkContext = sparkContext;
        this.sparkOperation = sparkOperation;
        this.sources = ImmutableMap.copyOf(sources);
        this.targets = ImmutableMap.copyOf(targets);
        this.accumulators.putAll(accumulators);
        this.metricsAccumulator = new MetricsAccumulator(sparkContext, sparkOperation.getId());
    }

    public SparkOperation getSparkOperation() {
        return this.sparkOperation;
    }

    ImmutableSet<SparkOperation> getSources() {
        return this.sources.keySet();
    }

    ImmutableSet<SparkOperation> getTargets() {
        return this.targets.keySet();
    }

    public Observable<Status> getStatus() {
        return this.statusSubject.takeUntil(Status::isFinal);
    }

    public Observable<Metrics> getMetrics() {
        return this.metricsSubject.takeUntil((ObservableSource)this.driverTasks.ignoreElements().toObservable()).switchIfEmpty((ObservableSource)Observable.fromCallable(() -> this.metricsSubject.getValue()));
    }

    public Observable<LogEntry> getLogging() {
        this.accumulators.computeIfAbsent("op_logging", s -> {
            LogEntryAccumulator logEntryAccumulator = LogEntryAccumulator.getOperationLogging(this.sparkContext, this.loggingSubject, this.sparkOperation.getId());
            this.sparkContext.sc().addSparkListener((SparkListenerInterface)new LoggingAccumSparkListener(logEntryAccumulator));
            return logEntryAccumulator.getAccumulator();
        });
        return this.loggingSubject;
    }

    public Observable<SubTransCreation> getSubTransCreation() {
        return this.subTransSubject;
    }

    public String toString() {
        return "Task Observable - " + this.sparkOperation.getId();
    }

    public void subscribe(Observer<? super DriverTask> observer) {
        if (this.started.compareAndSet(false, true)) {
            this.statusSubject.onNext((Object)Status.RUNNING);
            ((CompletableFuture)Util.invertMap(this.sources).thenApply(x$0 -> new OperationSubscriber((Map)x$0))).thenAccept(this::applyOperation);
        }
        this.driverTasks.subscribe(observer);
    }

    private synchronized void runOnDriver(Runnable action) {
        final DriverTask task = DriverTask.create(action, this.sparkOperation);
        this.activeTasks.add(task);
        task.subscribe((CompletableObserver)new DisposableCompletableObserver(){

            public void onComplete() {
                TaskObservable.this.activeTasks.remove(task);
            }

            public void onError(Throwable e) {
                this.onComplete();
            }
        });
        this.driverTasks.onNext((Object)task);
    }

    private CompletableFuture<Void> applyOperation(OperationSubscriber subscriber) {
        OperationEventListener rddEventListener = new OperationEventListener(this.sparkContext, subscriber, this.sparkOperation.getId(), this.metricsAccumulator);
        this.sparkContext.sc().addSparkListener((SparkListenerInterface)rddEventListener);
        if (subscriber.getInputs() != null && !subscriber.getInputs().isEmpty()) {
            subscriber.getInputs().forEach((k, v) -> v.setName(this.sparkOperation.getId()));
        }
        try {
            this.sparkOperation.apply(subscriber);
        }
        catch (Exception e) {
            OperationErrorEvent.sendEvent(this.sparkContext, this.sparkOperation.getId(), e);
        }
        return (CompletableFuture)Completable.fromRunnable(() -> subscriber.verifyTargetsSet()).andThen((CompletableSource)this.tasksDone()).andThen((CompletableSource)Completable.fromRunnable(this::verifyTargetsResolved)).to(Util::completableFuture);
    }

    private Completable tasksDone() {
        if (this.activeTasks.isEmpty()) {
            return Completable.complete();
        }
        return Completable.merge(this.activeTasks).andThen((CompletableSource)Completable.defer(this::tasksDone));
    }

    private void verifyTargetsResolved() {
        List unresolved = this.targets.entrySet().stream().filter(entry -> !((OperationDependency)entry.getValue()).isDone()).map(entry -> ((SparkOperation)entry.getKey()).getId()).collect(Collectors.toList());
        Preconditions.checkState((boolean)unresolved.isEmpty(), (String)"Future RDDs never completed by driver from %s to %s", (Object[])new Object[]{this.sparkOperation.getId(), unresolved});
    }

    private class OperationSubscriber
    implements SparkOperation.Subscriber {
        final ImmutableMap<SparkOperation, JavaRDD<Row>> inputs;
        final ImmutableSet<SparkOperation> expectedOutputs;
        final Set<SparkOperation> remainingOutput = Sets.newSetFromMap((Map)Maps.newConcurrentMap());

        private OperationSubscriber(Map<SparkOperation, JavaRDD<Row>> inputs) {
            this.inputs = ImmutableMap.copyOf(inputs);
            Map<Boolean, List<OperationDependency>> normalOutput = TaskObservable.this.targets.values().stream().collect(Collectors.partitioningBy(dependency -> "NORMAL".equals(dependency.getType())));
            this.expectedOutputs = normalOutput.get(true).stream().map(OperationDependency::getTo).collect(Collectors.collectingAndThen(Collectors.toSet(), ImmutableSet::copyOf));
            normalOutput.get(false).forEach(dependency -> dependency.complete(TaskObservable.this.sparkContext.emptyRDD()));
            this.remainingOutput.addAll((Collection<SparkOperation>)this.expectedOutputs);
        }

        @Override
        public Set<SparkOperation> getExpectedOutputs() {
            return this.expectedOutputs;
        }

        @Override
        public Map<SparkOperation, JavaRDD<Row>> getInputs() {
            return this.inputs;
        }

        @Override
        public void addOutput(SparkOperation output, CompletableFuture<JavaRDD<Row>> futureValue) {
            Preconditions.checkArgument((boolean)TaskObservable.this.targets.containsKey((Object)output), (String)"Unexpected RDD for %s", (Object[])new Object[]{output});
            if (this.remainingOutput.remove(output)) {
                CompletableFuture futureRdd = (CompletableFuture)TaskObservable.this.targets.get((Object)output);
                futureValue.whenComplete((rowJavaRDD, throwable) -> {
                    Optional.ofNullable(rowJavaRDD).ifPresent(futureRdd::complete);
                    Optional.ofNullable(throwable).ifPresent(futureRdd::completeExceptionally);
                });
            }
        }

        @Override
        public void registerDriverAction(Runnable action) {
            TaskObservable.this.runOnDriver(action);
        }

        private void verifyTargetsSet() {
            Set missing = this.remainingOutput.stream().map(SparkOperation::getId).collect(Collectors.toSet());
            Preconditions.checkState((boolean)missing.isEmpty(), (String)"RDDs expected but not set from %s to %s", (Object[])new Object[]{TaskObservable.this.sparkOperation.getId(), missing});
        }

        @Override
        public void setOutput(CompletableFuture<JavaRDD<Row>> output) {
            if (this.getExpectedOutputs().isEmpty()) {
                output.thenAcceptAsync(this::collectMetrics, this::registerDriverAction);
            } else {
                CompletableFuture<JavaRDD<Row>> result = this.getExpectedOutputs().size() > 1 ? output.thenApply(JavaRDD::cache) : output;
                this.getExpectedOutputs().forEach(expected -> this.addOutput((SparkOperation)expected, result));
            }
        }

        private void collectMetrics(JavaRDD<Row> output) {
            try {
                long count = output.count();
                FinalOperationEvent.sendEvent(TaskObservable.this.sparkContext, TaskObservable.this.sparkOperation.getId());
            }
            catch (Exception e) {
                OperationErrorEvent.sendEvent(TaskObservable.this.sparkContext, TaskObservable.this.sparkOperation.getId(), e);
            }
        }

        @Override
        public void updateMetrics(UnaryOperator<Metrics> update) {
            TaskObservable.this.metricsSubject.firstElement().map(update::apply).subscribe(arg_0 -> ((BehaviorSubject)TaskObservable.this.metricsSubject).onNext(arg_0));
        }

        @Override
        public Map<String, AccumulatorV2> getAccumulators() {
            return TaskObservable.this.accumulators;
        }

        @Override
        public OperationLogger getLogger() {
            return (OperationLogger)TaskObservable.this.opLogger.get();
        }

        @Override
        public void initializeContext(ExecutionContext context, Transformation transformation) {
            SubTransCreation subTransCreation = new SubTransCreation();
            subTransCreation.setContext(context);
            subTransCreation.setTransformation(transformation);
            TaskObservable.this.subTransSubject.onNext((Object)subTransCreation);
        }

        @Override
        public void updateStatus(Status status, String msgError) {
            switch (status) {
                case FAILED: {
                    TaskObservable.this.activeTasks.forEach(task -> task.cancel(false));
                    TaskObservable.this.driverTasks.onError(new Throwable(msgError));
                }
            }
            TaskObservable.this.statusSubject.onNext((Object)status);
        }

        @Override
        public synchronized void finalize(Throwable throwable) {
            if (throwable == null) {
                TaskObservable.this.driverTasks.onComplete();
            } else {
                TaskObservable.this.activeTasks.forEach(task -> task.cancel(false));
                TaskObservable.this.driverTasks.onError(throwable);
                TaskObservable.this.statusSubject.onNext((Object)Status.FAILED);
            }
        }

        @Override
        public MetricsAccumulator getMetricsAccumulator() {
            return TaskObservable.this.metricsAccumulator;
        }
    }
}

