/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.functions;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.sql.Date;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.IntStream;
import org.apache.spark.sql.Row;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.spi.ConfigurableFunction;
import org.pentaho.di.engine.spark.spi.KettleRow;
import org.pentaho.di.engine.spark.util.SerializableStepMeta;
import org.pentaho.di.trans.step.StepMeta;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class SparkToKettleRowFunction
extends ConfigurableFunction<Row, org.pentaho.di.engine.api.model.Row> {
    private static final long serialVersionUID = -8387294136003736814L;
    private transient StepMeta stepMeta;
    private Map<Integer, BiFunction<ValueMetaInterface, Object, Object>> functionMap;
    private transient MetricsAccumulator metricsAccumulator;

    public SparkToKettleRowFunction() {
    }

    public SparkToKettleRowFunction(StepMeta stepMeta, Map<Integer, BiFunction<ValueMetaInterface, Object, Object>> functionMap, MetricsAccumulator metricsAccumulator) {
        this.stepMeta = stepMeta;
        this.functionMap = functionMap;
        this.metricsAccumulator = metricsAccumulator;
    }

    public SparkToKettleRowFunction(StepMeta stepMeta, MetricsAccumulator metricsAccumulator) {
        this.stepMeta = stepMeta;
        this.functionMap = ImmutableMap.of((Object)3, (Object)new SqlToDateFunction());
        this.metricsAccumulator = metricsAccumulator;
    }

    public org.pentaho.di.engine.api.model.Row call(Row row) throws Exception {
        this.metricsAccumulator.addRowIn();
        ArrayList fieldFunctions = new ArrayList();
        RowMetaInterface rowMeta = this.stepMeta.getParentTransMeta().getStepFields(this.stepMeta);
        List valueMetaList = rowMeta.getValueMetaList();
        int[] functionFields = IntStream.range(0, valueMetaList.size()).filter(i -> this.functionMap.containsKey(((ValueMetaInterface)valueMetaList.get(i)).getType())).peek(i -> fieldFunctions.add(this.functionMap.get(((ValueMetaInterface)valueMetaList.get(i)).getType()))).toArray();
        Object[] values = ((List)JavaConverters.seqAsJavaListConverter((Seq)row.toSeq()).asJava()).toArray();
        for (int i2 = 0; i2 < functionFields.length; ++i2) {
            int fieldIndex = functionFields[i2];
            ValueMetaInterface valueMeta = (ValueMetaInterface)rowMeta.getValueMetaList().get(fieldIndex);
            values[fieldIndex] = ((BiFunction)fieldFunctions.get(i2)).apply(valueMeta, values[fieldIndex]);
        }
        this.metricsAccumulator.addRowOut();
        return new KettleRow(rowMeta, values);
    }

    public Map<String, Serializable> getConfig() {
        return ImmutableMap.of((Object)SerializableStepMeta.class.getName(), (Object)new SerializableStepMeta(this.stepMeta), (Object)(this.getClass().getName() + "-functionMap"), (Object)((Serializable)((Object)this.functionMap)), (Object)(this.getClass().getName() + "-metricsAccumulator"), (Object)this.metricsAccumulator);
    }

    public void setConfig(String key, Serializable value) {
        if (Objects.equals(key, SerializableStepMeta.class.getName())) {
            SerializableStepMeta delegate = (SerializableStepMeta)value;
            this.stepMeta = delegate.getStepMeta();
        } else if (Objects.equals(key, this.getClass().getName() + "-functionMap")) {
            this.functionMap = (Map)((Object)value);
        } else if (Objects.equals(key, this.getClass().getName() + "-metricsAccumulator")) {
            this.metricsAccumulator = (MetricsAccumulator)value;
        }
    }

    public static class StrToDateFunction
    implements BiFunction<ValueMetaInterface, Object, Object>,
    Serializable {
        private static final long serialVersionUID = -5523799678526931926L;

        @Override
        public Object apply(ValueMetaInterface valueMeta, Object value) {
            try {
                return valueMeta.getDateFormat().parse((String)value);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class SqlToDateFunction
    implements BiFunction<ValueMetaInterface, Object, Object>,
    Serializable {
        private static final long serialVersionUID = -2514096380660655975L;

        @Override
        public Object apply(ValueMetaInterface valueMeta, Object value) {
            return new java.util.Date(((Date)value).getTime());
        }
    }
}

