/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.listeners;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.StageInfo;
import org.pentaho.di.engine.api.reporting.Metrics;
import org.pentaho.di.engine.api.reporting.Status;
import org.pentaho.di.engine.spark.api.SparkOperation;
import org.pentaho.di.engine.spark.impl.accumulators.MetricsAccumulator;
import org.pentaho.di.engine.spark.impl.events.FinalOperationEvent;
import org.pentaho.di.engine.spark.impl.events.OperationEndedEvent;
import org.pentaho.di.engine.spark.impl.events.OperationErrorEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public class OperationEventListener
extends SparkListener {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String SUCCEEDED_STATUS = "succeeded";
    private final JavaSparkContext javaSparkContext;
    private final SparkOperation.Subscriber subscriber;
    private final String operationName;
    private List<String> outputOps = new ArrayList<String>();
    private final boolean endOperation;
    private final boolean onlyOneOperation;
    private String msgError = null;
    private Status stageStatus = Status.FINISHED;
    private Throwable throwable = null;
    private AtomicInteger nextStepsEnded = new AtomicInteger(0);
    private AtomicBoolean readyToFinalize = new AtomicBoolean(false);
    private AtomicBoolean finalized = new AtomicBoolean(false);
    private ConcurrentHashMap<Integer, Boolean> operationStageStatus = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, ArrayList<Integer>> jobStageRelation = new ConcurrentHashMap();
    private MetricsAccumulator metricsAccumulator;

    public OperationEventListener(JavaSparkContext javaSparkContext, SparkOperation.Subscriber subscriber, String operationName, MetricsAccumulator metricsAccumulator) {
        this.javaSparkContext = javaSparkContext;
        this.subscriber = subscriber;
        this.operationName = operationName;
        this.metricsAccumulator = metricsAccumulator;
        subscriber.getExpectedOutputs().stream().forEach(op -> this.outputOps.add(op.getId()));
        this.endOperation = this.outputOps == null || this.outputOps.isEmpty();
        this.onlyOneOperation = (subscriber.getInputs() == null || subscriber.getInputs().isEmpty()) && this.endOperation;
    }

    public void onJobStart(SparkListenerJobStart jobStart) {
        if (jobStart != null && jobStart.stageInfos() != null) {
            JavaConversions.seqAsJavaList((Seq)jobStart.stageInfos()).stream().forEach(stageInfo -> {
                ArrayList<Integer> stages;
                boolean hasRDDwithOperationName;
                boolean bl = hasRDDwithOperationName = JavaConversions.seqAsJavaList((Seq)stageInfo.rddInfos()).stream().filter(rddinfo -> this.onlyOneOperation || this.operationName.equals(rddinfo.name()) || this.outputOps.contains(rddinfo.name())).count() > 0L;
                if (hasRDDwithOperationName) {
                    this.operationStageStatus.put(stageInfo.stageId(), Boolean.FALSE);
                }
                if ((stages = this.jobStageRelation.get(jobStart.jobId())) == null) {
                    stages = new ArrayList();
                }
                if (!stages.contains(stageInfo.stageId())) {
                    this.jobStageRelation.put(jobStart.jobId(), stages);
                    stages.add(stageInfo.stageId());
                }
            });
        }
    }

    public void onJobEnd(SparkListenerJobEnd jobEnd) {
        if (jobEnd != null && this.jobStageRelation.get(jobEnd.jobId()) != null) {
            this.jobStageRelation.get(jobEnd.jobId()).forEach(stageId -> {
                if (this.operationStageStatus.get(stageId) != null && !this.operationStageStatus.get(stageId).booleanValue()) {
                    this.operationStageStatus.put((Integer)stageId, Boolean.TRUE);
                    this.subscriber.getLogger().debug("Stage " + stageId + " was skipped. Marking as completed");
                }
            });
            this.ifReadyFinalize();
        }
    }

    public void onStageSubmitted(SparkListenerStageSubmitted stageSubmitted) {
        boolean isThisOperationStage;
        if (stageSubmitted != null && stageSubmitted.stageInfo() != null && stageSubmitted.stageInfo().rddInfos() != null && (isThisOperationStage = this.operationStageStatus.containsKey(stageSubmitted.stageInfo().stageId())) && this.stageStatus != Status.RUNNING && this.stageStatus != Status.FAILED) {
            StageInfo stageInfo = stageSubmitted.stageInfo();
            this.stageStatus = Status.RUNNING;
            this.updateSatus();
            this.subscriber.getLogger().debug("Started execution on Stage: " + stageInfo.stageId() + " ( Attempt " + stageInfo.attemptId() + " ) total tasks: " + stageInfo.numTasks());
            this.logger.debug("Started execution on Stage: " + stageInfo.stageId() + " ( Attempt " + stageInfo.attemptId() + " ) total tasks: " + stageInfo.numTasks());
        }
    }

    public void onStageCompleted(SparkListenerStageCompleted stageCompleted) {
        if (stageCompleted != null && stageCompleted.stageInfo() != null && this.operationStageStatus.containsKey(stageCompleted.stageInfo().stageId())) {
            StageInfo stageInfo = stageCompleted.stageInfo();
            this.logger.debug("Operation: " + this.operationName + " marked stage completed: " + stageInfo.name());
            this.operationStageStatus.put(stageInfo.stageId(), Boolean.TRUE);
            if (this.stageStatus != Status.FAILED) {
                this.stageStatus = SUCCEEDED_STATUS.equals(stageInfo.getStatusString()) ? Status.FINISHED : Status.FAILED;
                this.msgError = stageInfo.failureReason().isEmpty() ? null : (String)stageInfo.failureReason().get();
            }
            this.ifReadyFinalize();
        }
    }

    public void onTaskEnd(SparkListenerTaskEnd taskEnd) {
        if (taskEnd != null && this.operationStageStatus.containsKey(taskEnd.stageId())) {
            this.updateMetrics();
        }
    }

    public void onOtherEvent(SparkListenerEvent event) {
        if (event instanceof FinalOperationEvent) {
            this.finalOperationEvent((FinalOperationEvent)event);
        } else if (event instanceof OperationErrorEvent) {
            this.operationErrorEvent((OperationErrorEvent)event);
        } else if (event instanceof OperationEndedEvent) {
            this.operationEndedEvent((OperationEndedEvent)event);
        }
    }

    public void onApplicationEnd(SparkListenerApplicationEnd applicationEnd) {
        this.finalizeOperation();
    }

    private void finalOperationEvent(FinalOperationEvent event) {
        if (this.operationName.equals(event.getOperation())) {
            this.readyToFinalize.set(true);
            if (this.allStagesCompleted()) {
                this.updateMetrics();
                if (this.operationStageStatus.size() == 0) {
                    this.stageStatus = Status.FINISHED;
                    this.updateSatus();
                }
                this.finalizeOperation();
            }
            OperationEndedEvent.sendEvent(this.javaSparkContext, this.operationName);
        }
    }

    private void operationEndedEvent(OperationEndedEvent event) {
        if (!this.endOperation && this.outputOps.contains(event.getOperation()) && this.nextStepEndedInc() >= this.outputOps.size()) {
            this.readyToFinalize.set(true);
            if (this.allStagesCompleted()) {
                if (this.operationStageStatus.size() == 0) {
                    this.stageStatus = Status.FINISHED;
                    this.updateMetrics();
                    this.updateSatus();
                }
                this.finalizeOperation();
            }
            OperationEndedEvent.sendEvent(this.javaSparkContext, this.operationName);
        }
    }

    private void operationErrorEvent(OperationErrorEvent event) {
        if (this.operationName.equals(event.getOperation())) {
            this.throwable = event.getThrowable();
        }
        this.finalizeOperation();
    }

    private void updateMetrics() {
        this.subscriber.updateMetrics(metrics -> new Metrics(this.metricsAccumulator.getRowIn(), this.metricsAccumulator.getRowOut(), this.metricsAccumulator.getRowError(), this.metricsAccumulator.getRowInFlight()));
    }

    private void updateSatus() {
        this.subscriber.updateStatus(this.stageStatus, this.msgError);
    }

    private void finalizeOperation() {
        this.finalized.set(true);
        if (this.throwable != null) {
            this.subscriber.finalize(this.throwable);
        } else {
            this.subscriber.finalize(this.msgError != null && !this.msgError.isEmpty() ? new Throwable(this.msgError) : null);
        }
    }

    private void ifReadyFinalize() {
        if (this.allStagesCompleted()) {
            this.logger.debug("Operation: " + this.operationName + " has all stages completed");
            this.updateMetrics();
            this.updateSatus();
            if (this.readyToFinalize.get() && !this.finalized.get()) {
                this.finalizeOperation();
            }
        }
    }

    private int nextStepEndedInc() {
        return this.nextStepsEnded.incrementAndGet();
    }

    private boolean allStagesCompleted() {
        return this.operationStageStatus.values().stream().allMatch(Boolean::booleanValue);
    }

    @VisibleForTesting
    public Throwable getThrowable() {
        return this.throwable;
    }
}

