/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.impl.listeners;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.TaskInfo;
import org.apache.spark.util.CollectionAccumulator;
import org.pentaho.di.engine.api.reporting.LogEntry;
import org.pentaho.di.engine.api.reporting.LogLevel;
import org.pentaho.di.engine.spark.impl.events.FinalOperationEvent;
import org.pentaho.di.engine.spark.util.LogTableBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public class SparkTaskMetricsListener
extends SparkListener {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Map<Integer, String> stageJobRel = new HashMap<Integer, String>();
    private Map<Long, Row> taskRows = new HashMap<Long, Row>();
    private static final DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final CollectionAccumulator<LogEntry> transformationLog;
    private static final String NO_TASK_ROWS = " No task metric to show";
    private static final String[] HEARDER_COLS = new String[]{"Task ID", "Stage ID", "Job IDs", "Stage Attempts", "Task Attempts", "Status", "Locality Level", "Executor ID / Host", "Launch Time", "Duration", "Scheculer Delay", "Deserialization Time", "GC Time", "Result Serialization Time", "Getting Result Time", "Peak Exec Memory", "Shuffle Read Size / Records", "Errors"};

    public SparkTaskMetricsListener(CollectionAccumulator<LogEntry> transformationLog) {
        this.transformationLog = transformationLog;
    }

    public void onJobStart(SparkListenerJobStart jobStart) {
        if (jobStart != null && jobStart.stageInfos() != null) {
            JavaConversions.seqAsJavaList((Seq)jobStart.stageInfos()).stream().forEach(stageInfo -> {
                String jobs = this.stageJobRel.get(stageInfo.stageId());
                jobs = (jobs == null ? "" : ", ") + jobStart.jobId();
                this.stageJobRel.put(stageInfo.stageId(), jobs);
            });
        }
    }

    public void onTaskEnd(SparkListenerTaskEnd taskEnd) {
        if (taskEnd != null && taskEnd.taskInfo() != null && taskEnd.taskMetrics() != null) {
            TaskInfo taskInfo = taskEnd.taskInfo();
            TaskMetrics taskMetrics = taskEnd.taskMetrics();
            Row row = this.taskRows.get(taskInfo.taskId());
            if (row == null) {
                row = new Row();
                this.taskRows.put(taskInfo.taskId(), row);
            }
            row.setTaskId(taskInfo.taskId());
            row.setStageId(taskEnd.stageId());
            row.setJobIds(this.stageJobRel.get(taskEnd.stageId()));
            row.setStageAttempts(taskEnd.stageAttemptId());
            row.setTaskAttempts(taskInfo.attemptNumber());
            row.setStatus(taskInfo.status());
            row.setLocality(taskInfo.taskLocality() == null ? "" : taskInfo.taskLocality().toString());
            row.setExecutorIdHost(taskInfo.executorId());
            Instant instant = new Date(taskInfo.launchTime()).toInstant();
            LocalDateTime launchTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
            row.setLaunchTime(launchTime.format(dtf));
            row.setDuration(taskInfo.duration() + " ms");
            row.setSchedularDelay(this.calculateSchedularDelay(taskInfo, taskMetrics) + " ms");
            row.setDeserializationTime(taskMetrics.executorDeserializeTime() + " ms");
            row.setGcTime(taskMetrics.jvmGCTime() + " ms");
            row.setResultSerializationTime(taskMetrics.resultSerializationTime() + " ms");
            row.setGettingResultTime(this.calculateGettingResultTime(taskInfo) + " ms");
            row.setPeakExecutionMemory(taskMetrics.peakExecutionMemory() + " bytes");
            row.setShuffleReadSizeRecords(taskMetrics.shuffleReadMetrics() == null ? "" : taskMetrics.shuffleReadMetrics().totalBytesRead() + " bytes / " + taskMetrics.shuffleReadMetrics().recordsRead());
            row.setErrors(taskInfo.failed() && taskEnd.reason() != null ? taskEnd.reason().toString() : "");
        }
    }

    public void onOtherEvent(SparkListenerEvent event) {
        if (event instanceof FinalOperationEvent) {
            this.sendMetrics();
        }
    }

    private void sendMetrics() {
        String metricsTable = this.createTable();
        LogEntry.LogEntryBuilder logEntryBuilder = new LogEntry.LogEntryBuilder().withMessage(metricsTable).withLogLevel(LogLevel.DEBUG).withTimestamp(new Date());
        this.transformationLog.add((Object)logEntryBuilder.build());
    }

    private long calculateGettingResultTime(TaskInfo taskInfo) {
        return taskInfo.gettingResultTime() == 0L ? 0L : taskInfo.finishTime() - taskInfo.gettingResultTime();
    }

    private long calculateSchedularDelay(TaskInfo taskInfo, TaskMetrics taskMetrics) {
        long totalExecutionTime = taskInfo.finishTime() - taskInfo.launchTime();
        long executorOverhead = taskMetrics.executorDeserializeTime() + taskMetrics.resultSerializationTime();
        return Math.max(0L, totalExecutionTime - taskMetrics.executorRunTime() - executorOverhead - this.calculateGettingResultTime(taskInfo));
    }

    private String createTable() {
        if (!this.taskRows.isEmpty()) {
            LogTableBuilder tableBuilder = new LogTableBuilder();
            SparkTaskMetricsListener.buildHeader(tableBuilder);
            this.taskRows.forEach((k, v) -> SparkTaskMetricsListener.buildRow(tableBuilder, v));
            return tableBuilder.toString();
        }
        return NO_TASK_ROWS;
    }

    private static void buildHeader(LogTableBuilder tableBuilder) {
        tableBuilder.addRow(HEARDER_COLS[0], HEARDER_COLS[1], HEARDER_COLS[2], HEARDER_COLS[3], HEARDER_COLS[4], HEARDER_COLS[5], HEARDER_COLS[6], HEARDER_COLS[7], HEARDER_COLS[8], HEARDER_COLS[9], HEARDER_COLS[10], HEARDER_COLS[11], HEARDER_COLS[12], HEARDER_COLS[13], HEARDER_COLS[14], HEARDER_COLS[15], HEARDER_COLS[16], HEARDER_COLS[17]);
    }

    private static void buildRow(LogTableBuilder tableBuilder, Row row) {
        tableBuilder.addRow(row.getTaskId(), row.getStageId(), row.getJobIds(), row.getStageAttempts(), row.getTaskAttempts(), row.getStatus(), row.getLocality(), row.getExecutorIdHost(), row.getLaunchTime(), row.getDuration(), row.getSchedularDelay(), row.getDeserializationTime(), row.getGcTime(), row.getResultSerializationTime(), row.getGettingResultTime(), row.getPeakExecutionMemory(), row.getShuffleReadSizeRecords(), row.getErrors());
    }

    private class Row {
        private String taskId = null;
        private String stageId = null;
        private String jobIds = null;
        private String stageAttempts = null;
        private String taskAttempts = null;
        private String status = null;
        private String locality = null;
        private String executorIdHost = null;
        private String launchTime = null;
        private String duration = null;
        private String schedularDelay = null;
        private String deserializationTime = null;
        private String gcTime = null;
        private String resultSerializationTime = null;
        private String gettingResultTime = null;
        private String peakExecutionMemory = null;
        private String shuffleReadSizeRecords = null;
        private String errors = null;

        String getTaskId() {
            return this.taskId;
        }

        void setTaskId(long taskId) {
            this.taskId = String.valueOf(taskId);
        }

        String getStageId() {
            return this.stageId;
        }

        void setStageId(int stageId) {
            this.stageId = String.valueOf(stageId);
        }

        String getJobIds() {
            return this.jobIds;
        }

        void setJobIds(String jobIds) {
            this.jobIds = jobIds;
        }

        String getStageAttempts() {
            return this.stageAttempts;
        }

        void setStageAttempts(int stageAttempts) {
            this.stageAttempts = String.valueOf(stageAttempts);
        }

        String getTaskAttempts() {
            return this.taskAttempts;
        }

        void setTaskAttempts(int taskAttempts) {
            this.taskAttempts = String.valueOf(taskAttempts);
        }

        String getStatus() {
            return this.status;
        }

        void setStatus(String status) {
            this.status = status;
        }

        String getLocality() {
            return this.locality;
        }

        void setLocality(String locality) {
            this.locality = locality;
        }

        String getExecutorIdHost() {
            return this.executorIdHost;
        }

        void setExecutorIdHost(String executorIdHost) {
            this.executorIdHost = executorIdHost;
        }

        String getLaunchTime() {
            return this.launchTime;
        }

        void setLaunchTime(String launchTime) {
            this.launchTime = launchTime;
        }

        String getDuration() {
            return this.duration;
        }

        void setDuration(String duration) {
            this.duration = duration;
        }

        String getSchedularDelay() {
            return this.schedularDelay;
        }

        void setSchedularDelay(String schedularDelay) {
            this.schedularDelay = schedularDelay;
        }

        String getDeserializationTime() {
            return this.deserializationTime;
        }

        void setDeserializationTime(String deserializationTime) {
            this.deserializationTime = deserializationTime;
        }

        String getGcTime() {
            return this.gcTime;
        }

        void setGcTime(String gcTime) {
            this.gcTime = gcTime;
        }

        String getResultSerializationTime() {
            return this.resultSerializationTime;
        }

        void setResultSerializationTime(String resultSerializtionTime) {
            this.resultSerializationTime = resultSerializtionTime;
        }

        String getGettingResultTime() {
            return this.gettingResultTime;
        }

        void setGettingResultTime(String gettingResultTime) {
            this.gettingResultTime = gettingResultTime;
        }

        String getPeakExecutionMemory() {
            return this.peakExecutionMemory;
        }

        void setPeakExecutionMemory(String peakExecutionMemory) {
            this.peakExecutionMemory = peakExecutionMemory;
        }

        String getShuffleReadSizeRecords() {
            return this.shuffleReadSizeRecords;
        }

        void setShuffleReadSizeRecords(String shuffleReadSizeRecords) {
            this.shuffleReadSizeRecords = shuffleReadSizeRecords;
        }

        String getErrors() {
            return this.errors;
        }

        void setErrors(String errors) {
            this.errors = errors;
        }
    }
}

