/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.spark.util;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class LogTableBuilder {
    List<String[]> rows = new LinkedList<String[]>();

    public void addRow(String ... cols) {
        this.rows.add(cols);
    }

    private int[] colWidths() {
        int cols = -1;
        for (String[] row : this.rows) {
            cols = Math.max(cols, row.length);
        }
        int[] widths = new int[cols];
        for (String[] row : this.rows) {
            for (int colNum = 0; colNum < row.length; ++colNum) {
                widths[colNum] = Math.max(widths[colNum], StringUtils.length((CharSequence)row[colNum]));
            }
        }
        return widths;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        int[] colWidths = this.colWidths();
        buf.append('\n');
        for (String[] row : this.rows) {
            for (int colNum = 0; colNum < row.length; ++colNum) {
                buf.append(StringUtils.rightPad((String)StringUtils.defaultString((String)row[colNum]), (int)colWidths[colNum]));
                buf.append(' ');
            }
            buf.append('\n');
        }
        return buf.toString();
    }
}

