/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.Text;

@Description(name="trunc", value="_FUNC_(date, fmt) - Returns returns date with the time portion of the day truncated to the unit specified by the format model fmt. If you omit fmt, then date is truncated to the nearest day. It now only supports 'MONTH'/'MON'/'MM' and 'YEAR'/'YYYY'/'YY' as format.", extended="date is a string in the format 'yyyy-MM-dd HH:mm:ss' or 'yyyy-MM-dd'. The time part of date is ignored.\nExample:\n  > SELECT _FUNC_('2009-02-12', 'MM');\nOK\n '2009-02-01'\n > SELECT _FUNC_('2015-10-27', 'YEAR');\nOK\n '2015-01-01'")
public class GenericUDFTrunc
extends GenericUDF {
    private transient SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private transient PrimitiveObjectInspectorConverter.TimestampConverter timestampConverter;
    private transient ObjectInspectorConverters.Converter textConverter1;
    private transient ObjectInspectorConverters.Converter textConverter2;
    private transient ObjectInspectorConverters.Converter dateWritableConverter;
    private transient PrimitiveObjectInspector.PrimitiveCategory inputType1;
    private transient PrimitiveObjectInspector.PrimitiveCategory inputType2;
    private final Calendar calendar = Calendar.getInstance();
    private final Text output = new Text();
    private transient String fmtInput;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("trunc() requires 2 argument, got " + arguments.length);
        }
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + arguments[0].getTypeName() + " is passed. as first arguments");
        }
        if (arguments[1].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(1, "Only primitive type arguments are accepted but " + arguments[1].getTypeName() + " is passed. as second arguments");
        }
        WritableStringObjectInspector outputOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        this.inputType1 = ((PrimitiveObjectInspector)arguments[0]).getPrimitiveCategory();
        switch (this.inputType1) {
            case STRING: 
            case VARCHAR: 
            case CHAR: 
            case VOID: {
                this.inputType1 = PrimitiveObjectInspector.PrimitiveCategory.STRING;
                this.textConverter1 = ObjectInspectorConverters.getConverter(arguments[0], (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
                break;
            }
            case TIMESTAMP: {
                this.timestampConverter = new PrimitiveObjectInspectorConverter.TimestampConverter((PrimitiveObjectInspector)arguments[0], PrimitiveObjectInspectorFactory.writableTimestampObjectInspector);
                break;
            }
            case DATE: {
                this.dateWritableConverter = ObjectInspectorConverters.getConverter(arguments[0], (ObjectInspector)PrimitiveObjectInspectorFactory.writableDateObjectInspector);
                break;
            }
            default: {
                throw new UDFArgumentTypeException(0, "TRUNC() only takes STRING/TIMESTAMP/DATEWRITABLE types as first argument, got " + (Object)((Object)this.inputType1));
            }
        }
        this.inputType2 = ((PrimitiveObjectInspector)arguments[1]).getPrimitiveCategory();
        if (PrimitiveObjectInspectorUtils.getPrimitiveGrouping(this.inputType2) != PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP && PrimitiveObjectInspectorUtils.getPrimitiveGrouping(this.inputType2) != PrimitiveObjectInspectorUtils.PrimitiveGrouping.VOID_GROUP) {
            throw new UDFArgumentTypeException(1, "trunk() only takes STRING/CHAR/VARCHAR types as second argument, got " + (Object)((Object)this.inputType2));
        }
        this.inputType2 = PrimitiveObjectInspector.PrimitiveCategory.STRING;
        if (arguments[1] instanceof ConstantObjectInspector) {
            Object obj = ((ConstantObjectInspector)arguments[1]).getWritableConstantValue();
            this.fmtInput = obj != null ? obj.toString() : null;
        } else {
            this.textConverter2 = ObjectInspectorConverters.getConverter(arguments[1], (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        }
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Date date;
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("trunc() requires 2 argument, got " + arguments.length);
        }
        if (arguments[0].get() == null || arguments[1].get() == null) {
            return null;
        }
        if (this.textConverter2 != null) {
            this.fmtInput = this.textConverter2.convert(arguments[1].get()).toString();
        }
        switch (this.inputType1) {
            case STRING: {
                String dateString = this.textConverter1.convert(arguments[0].get()).toString();
                try {
                    date = this.formatter.parse(dateString.toString());
                    break;
                }
                catch (ParseException e) {
                    return null;
                }
            }
            case TIMESTAMP: {
                Timestamp ts;
                date = ts = ((TimestampWritable)this.timestampConverter.convert(arguments[0].get())).getTimestamp();
                break;
            }
            case DATE: {
                DateWritable dw = (DateWritable)this.dateWritableConverter.convert(arguments[0].get());
                date = dw.get();
                break;
            }
            default: {
                throw new UDFArgumentTypeException(0, "TRUNC() only takes STRING/TIMESTAMP/DATEWRITABLE types, got " + (Object)((Object)this.inputType1));
            }
        }
        if (this.evalDate(date) == null) {
            return null;
        }
        Date newDate = this.calendar.getTime();
        this.output.set(this.formatter.format(newDate));
        return this.output;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("trunc", children);
    }

    private Calendar evalDate(Date d) throws UDFArgumentException {
        this.calendar.setTime(d);
        if ("MONTH".equals(this.fmtInput) || "MON".equals(this.fmtInput) || "MM".equals(this.fmtInput)) {
            this.calendar.set(5, 1);
            return this.calendar;
        }
        if ("YEAR".equals(this.fmtInput) || "YYYY".equals(this.fmtInput) || "YY".equals(this.fmtInput)) {
            this.calendar.set(2, 0);
            this.calendar.set(5, 1);
            return this.calendar;
        }
        return null;
    }
}

