/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.webservices;

import java.util.ArrayList;
import java.util.Set;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.pentaho.platform.api.repository2.unified.RepositoryFileTree;
import org.pentaho.platform.api.repository2.unified.RepositoryRequest;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileAdapter;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileDto;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileTreeDto;

public class RepositoryFileTreeAdapter
extends XmlAdapter<RepositoryFileTreeDto, RepositoryFileTree> {
    private Set<String> membersSet;
    private boolean exclude;
    private boolean includeAcls;

    public RepositoryFileTreeAdapter() {
    }

    public RepositoryFileTreeAdapter(RepositoryRequest repositoryRequest) {
        if (repositoryRequest.getExcludeMemberSet() != null && !repositoryRequest.getExcludeMemberSet().isEmpty()) {
            this.exclude = true;
            this.membersSet = repositoryRequest.getExcludeMemberSet();
        } else {
            this.exclude = false;
            this.membersSet = repositoryRequest.getIncludeMemberSet();
        }
        this.includeAcls = repositoryRequest.isIncludeAcls();
    }

    public RepositoryFileTreeDto marshal(RepositoryFileTree v) {
        RepositoryFileTreeDto treeDto = new RepositoryFileTreeDto();
        RepositoryFileDto file = RepositoryFileAdapter.toFileDto(v, this.membersSet, this.exclude, this.includeAcls);
        if (file != null) {
            treeDto.setFile(RepositoryFileAdapter.toFileDto(v, this.membersSet, this.exclude, this.includeAcls));
            ArrayList<RepositoryFileTreeDto> children = null;
            if (v.getChildren() != null) {
                children = new ArrayList<RepositoryFileTreeDto>();
                for (RepositoryFileTree child : v.getChildren()) {
                    RepositoryFileTreeDto childTreeDto = this.marshal(child);
                    if (childTreeDto == null) continue;
                    children.add(childTreeDto);
                }
            }
            treeDto.setChildren(children);
            return treeDto;
        }
        return null;
    }

    public RepositoryFileTree unmarshal(RepositoryFileTreeDto v) {
        ArrayList<RepositoryFileTree> children = null;
        if (v.children != null) {
            children = new ArrayList<RepositoryFileTree>();
            for (RepositoryFileTreeDto child : v.children) {
                children.add(this.unmarshal(child));
            }
        }
        RepositoryFileTree repositoryFileTree = new RepositoryFileTree(RepositoryFileAdapter.toFile(v.file), children);
        if (v.file.getVersioningEnabled() != null) {
            repositoryFileTree.setVersioningEnabled(v.file.getVersioningEnabled());
        }
        if (v.file.getVersionCommentEnabled() != null) {
            repositoryFileTree.setVersionCommentEnabled(v.file.getVersionCommentEnabled());
        }
        return repositoryFileTree;
    }
}

