/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.Configuration;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.network.Authenticator;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.LoginType;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.network.PlaintextTransportLayer;
import org.apache.kafka.common.network.SslTransportLayer;
import org.apache.kafka.common.network.TransportLayer;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.authenticator.LoginManager;
import org.apache.kafka.common.security.authenticator.SaslClientAuthenticator;
import org.apache.kafka.common.security.authenticator.SaslServerAuthenticator;
import org.apache.kafka.common.security.kerberos.KerberosShortNamer;
import org.apache.kafka.common.security.ssl.SslFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslChannelBuilder
implements ChannelBuilder {
    private static final Logger log = LoggerFactory.getLogger(SaslChannelBuilder.class);
    private final SecurityProtocol securityProtocol;
    private final String clientSaslMechanism;
    private final Mode mode;
    private final LoginType loginType;
    private final boolean handshakeRequestEnable;
    private final CredentialCache credentialCache;
    private Configuration jaasConfig;
    private LoginManager loginManager;
    private SslFactory sslFactory;
    private Map<String, ?> configs;
    private KerberosShortNamer kerberosShortNamer;

    public SaslChannelBuilder(Mode mode, LoginType loginType, SecurityProtocol securityProtocol, String clientSaslMechanism, boolean handshakeRequestEnable, CredentialCache credentialCache) {
        this.mode = mode;
        this.loginType = loginType;
        this.securityProtocol = securityProtocol;
        this.handshakeRequestEnable = handshakeRequestEnable;
        this.clientSaslMechanism = clientSaslMechanism;
        this.credentialCache = credentialCache;
    }

    @Override
    public void configure(Map<String, ?> configs) throws KafkaException {
        try {
            List enabledMechanisms;
            this.configs = configs;
            boolean hasKerberos = this.mode == Mode.SERVER ? (enabledMechanisms = (List)this.configs.get("sasl.enabled.mechanisms")) == null || enabledMechanisms.contains("GSSAPI") : this.clientSaslMechanism.equals("GSSAPI");
            if (hasKerberos) {
                String defaultRealm;
                try {
                    defaultRealm = JaasUtils.defaultKerberosRealm();
                }
                catch (Exception ke) {
                    defaultRealm = "";
                }
                List principalToLocalRules = (List)configs.get("sasl.kerberos.principal.to.local.rules");
                if (principalToLocalRules != null) {
                    this.kerberosShortNamer = KerberosShortNamer.fromUnparsedRules(defaultRealm, principalToLocalRules);
                }
            }
            this.jaasConfig = JaasUtils.jaasConfig(this.loginType, configs);
            this.loginManager = LoginManager.acquireLoginManager(this.loginType, hasKerberos, configs, this.jaasConfig);
            if (this.securityProtocol == SecurityProtocol.SASL_SSL) {
                this.sslFactory = new SslFactory(this.mode, "none");
                this.sslFactory.configure(configs);
            }
        }
        catch (Exception e) {
            throw new KafkaException(e);
        }
    }

    @Override
    public KafkaChannel buildChannel(String id, SelectionKey key, int maxReceiveSize) throws KafkaException {
        try {
            SocketChannel socketChannel = (SocketChannel)key.channel();
            TransportLayer transportLayer = this.buildTransportLayer(id, key, socketChannel);
            Authenticator authenticator = this.mode == Mode.SERVER ? new SaslServerAuthenticator(id, this.jaasConfig, this.loginManager.subject(), this.kerberosShortNamer, socketChannel.socket().getLocalAddress().getHostName(), maxReceiveSize, this.credentialCache) : new SaslClientAuthenticator(id, this.loginManager.subject(), this.loginManager.serviceName(), socketChannel.socket().getInetAddress().getHostName(), this.clientSaslMechanism, this.handshakeRequestEnable);
            authenticator.configure(transportLayer, null, this.configs);
            return new KafkaChannel(id, transportLayer, authenticator, maxReceiveSize);
        }
        catch (Exception e) {
            log.info("Failed to create channel due to ", (Throwable)e);
            throw new KafkaException(e);
        }
    }

    @Override
    public void close() {
        if (this.loginManager != null) {
            this.loginManager.release();
        }
    }

    protected TransportLayer buildTransportLayer(String id, SelectionKey key, SocketChannel socketChannel) throws IOException {
        if (this.securityProtocol == SecurityProtocol.SASL_SSL) {
            return SslTransportLayer.create(id, key, this.sslFactory.createSslEngine(socketChannel.socket().getInetAddress().getHostName(), socketChannel.socket().getPort()));
        }
        return new PlaintextTransportLayer(key);
    }
}

