/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.avro;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.List;
import org.apache.avro.Schema;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.hadoop.shim.api.format.SchemaDescription;

public class AvroSchemaConverter {
    private final String AVRO_TYPE_STRING = "string";
    private final String AVRO_TYPE_DOUBLE = "double";
    private final String AVRO_TYPE_LONG = "long";
    private final String AVRO_TYPE_BOOLEAN = "boolean";
    private final String AVRO_TYPE_BINARY = "bytes";
    private final String AVRO_TYPE_DATE = "int";
    private final String AVRO_TYPE_TIMESTAMP = "long";
    private final String AVRO_TYPE_NULL = "null";
    private final String AVRO_TYPE_RECORD = "record";
    private final String AVRO_DOC = "doc";
    private final String AVRO_FIELDS_NODE = "fields";
    private static final String AVRO_LOGICAL_TYPE = "logicalType";
    private final String AVRO_NAMESPACE_NODE = "namespace";
    private final String AVRO_NAME_NODE = "name";
    private final String AVRO_TYPE_NODE = "type";
    private final String AVRO_DEFAULT_NODE = "default";
    private static final String DATE = "date";
    private static final String TIMESTAMP_MILLIS = "timestamp-millis";
    private ObjectMapper mapper = new ObjectMapper();
    private final ObjectNode avroSchema;

    public AvroSchemaConverter(SchemaDescription schemaDescription, String nameSpace, String recordName, String docValue) {
        if (schemaDescription != null) {
            this.avroSchema = this.mapper.createObjectNode();
            ArrayNode fieldNodes = this.mapper.createArrayNode();
            schemaDescription.forEach(f -> fieldNodes.add((JsonNode)this.convertField((SchemaDescription.Field)f)));
            this.avroSchema.put("namespace", nameSpace);
            this.avroSchema.put("type", "record");
            this.avroSchema.put("name", recordName);
            this.avroSchema.put("doc", docValue);
            this.avroSchema.putPOJO("fields", (Object)fieldNodes);
        } else {
            this.avroSchema = null;
        }
    }

    public void writeAvroSchemaToFile(String schemaFilename) throws JsonGenerationException, JsonMappingException, KettleFileException, IOException {
        if (this.avroSchema != null && schemaFilename != null) {
            ObjectWriter writer = this.mapper.writer((PrettyPrinter)new DefaultPrettyPrinter());
            writer.writeValue(KettleVFS.getOutputStream((String)schemaFilename, (boolean)false), (Object)this.avroSchema);
        }
    }

    public Schema getAvroSchema() {
        return this.avroSchema == null ? null : new Schema.Parser().parse(this.avroSchema.toString());
    }

    public static SchemaDescription createSchemaDescription(Schema schema) {
        SchemaDescription sd = new SchemaDescription();
        schema.getFields().forEach(f -> sd.addField(AvroSchemaConverter.convertField(sd, f)));
        return sd;
    }

    @VisibleForTesting
    ObjectNode convertField(SchemaDescription.Field f) {
        switch (f.pentahoValueMetaType) {
            case 1: {
                return this.convertPrimitive("double", f);
            }
            case 2: {
                return this.convertPrimitive("string", f);
            }
            case 4: {
                return this.convertPrimitive("boolean", f);
            }
            case 5: {
                return this.convertPrimitive("long", f);
            }
            case 6: {
                return this.convertPrimitive("double", f);
            }
            case 7: {
                return this.convertPrimitive("bytes", f);
            }
            case 8: {
                return this.convertPrimitive("bytes", f);
            }
            case 3: {
                return this.convertPrimitive("int", f);
            }
            case 9: {
                return this.convertPrimitive("long", f);
            }
            case 10: {
                return this.convertPrimitive("string", f);
            }
        }
        throw new RuntimeException("Field: " + f.formatFieldName + "  Undefined type: " + f.pentahoValueMetaType);
    }

    @VisibleForTesting
    private static SchemaDescription.Field convertField(SchemaDescription schema, Schema.Field f) {
        String fieldVal = f.name();
        boolean allowNull = true;
        FieldName fieldName = AvroSchemaConverter.parseFieldName(fieldVal);
        if (fieldName != null) {
            allowNull = fieldName.allowNull;
            fieldVal = fieldName.name;
        } else {
            allowNull = f.defaultVal() == null;
        }
        String defaultValue = null;
        if (!allowNull && f.defaultVal() != null) {
            defaultValue = f.defaultVal().toString();
        }
        Schema.Type schemaType = null;
        if (f.schema().getType().equals((Object)Schema.Type.UNION)) {
            List schemas = f.schema().getTypes();
            for (Schema s : schemas) {
                if (s.getName().equalsIgnoreCase("null")) continue;
                schemaType = s.getType();
                break;
            }
        } else {
            schemaType = f.schema().getType();
        }
        switch (schemaType) {
            case DOUBLE: 
            case FLOAT: {
                if (fieldName != null) {
                    if (fieldName.type == 1) {
                        SchemaDescription schemaDescription = schema;
                        schemaDescription.getClass();
                        return new SchemaDescription.Field(schemaDescription, fieldVal, fieldVal, 1, defaultValue, allowNull);
                    }
                    if (fieldName.type == 6) {
                        SchemaDescription schemaDescription = schema;
                        schemaDescription.getClass();
                        return new SchemaDescription.Field(schemaDescription, fieldVal, fieldVal, 6, defaultValue, allowNull);
                    }
                } else {
                    SchemaDescription schemaDescription = schema;
                    schemaDescription.getClass();
                    return new SchemaDescription.Field(schemaDescription, fieldVal, fieldVal, 1, defaultValue, allowNull);
                }
            }
            case LONG: {
                String logicalTimeStampType = f.getProp(AVRO_LOGICAL_TYPE);
                if (logicalTimeStampType != null && logicalTimeStampType.equalsIgnoreCase(TIMESTAMP_MILLIS)) {
                    SchemaDescription schemaDescription = schema;
                    schemaDescription.getClass();
                    return new SchemaDescription.Field(schemaDescription, fieldVal, fieldVal, 9, defaultValue, allowNull);
                }
                if (fieldName != null) {
                    if (fieldName.type == 9) {
                        SchemaDescription schemaDescription = schema;
                        schemaDescription.getClass();
                        return new SchemaDescription.Field(schemaDescription, fieldVal, fieldVal, 9, defaultValue, allowNull);
                    }
                    SchemaDescription schemaDescription = schema;
                    schemaDescription.getClass();
                    return new SchemaDescription.Field(schemaDescription, fieldVal, fieldVal, 5, defaultValue, allowNull);
                }
                SchemaDescription schemaDescription = schema;
                schemaDescription.getClass();
                return new SchemaDescription.Field(schemaDescription, fieldVal, fieldVal, 5, defaultValue, allowNull);
            }
            case BOOLEAN: {
                if (fieldName != null) {
                    SchemaDescription schemaDescription = schema;
                    schemaDescription.getClass();
                    return new SchemaDescription.Field(schemaDescription, fieldVal, fieldVal, 4, defaultValue, allowNull);
                }
                SchemaDescription schemaDescription = schema;
                schemaDescription.getClass();
                return new SchemaDescription.Field(schemaDescription, fieldVal, fieldVal, 4, defaultValue, allowNull);
            }
            case BYTES: {
                if (fieldName != null) {
                    SchemaDescription schemaDescription = schema;
                    schemaDescription.getClass();
                    return new SchemaDescription.Field(schemaDescription, fieldVal, fieldVal, 8, defaultValue, allowNull);
                }
                SchemaDescription schemaDescription = schema;
                schemaDescription.getClass();
                return new SchemaDescription.Field(schemaDescription, fieldVal, fieldVal, 8, defaultValue, allowNull);
            }
            case INT: {
                String logicalDateType = f.getProp(AVRO_LOGICAL_TYPE);
                if (logicalDateType != null && logicalDateType.equalsIgnoreCase(DATE)) {
                    SchemaDescription schemaDescription = schema;
                    schemaDescription.getClass();
                    return new SchemaDescription.Field(schemaDescription, fieldVal, fieldVal, 3, defaultValue, allowNull);
                }
                if (fieldName != null) {
                    if (fieldName.type == 3) {
                        SchemaDescription schemaDescription = schema;
                        schemaDescription.getClass();
                        return new SchemaDescription.Field(schemaDescription, fieldVal, fieldVal, 3, defaultValue, allowNull);
                    }
                    SchemaDescription schemaDescription = schema;
                    schemaDescription.getClass();
                    return new SchemaDescription.Field(schemaDescription, fieldVal, fieldVal, 5, defaultValue, allowNull);
                }
                SchemaDescription schemaDescription = schema;
                schemaDescription.getClass();
                return new SchemaDescription.Field(schemaDescription, fieldVal, fieldVal, 5, defaultValue, allowNull);
            }
            case STRING: {
                if (fieldName != null) {
                    if (fieldName.type == 10) {
                        SchemaDescription schemaDescription = schema;
                        schemaDescription.getClass();
                        return new SchemaDescription.Field(schemaDescription, fieldVal, fieldVal, 10, defaultValue, allowNull);
                    }
                    SchemaDescription schemaDescription = schema;
                    schemaDescription.getClass();
                    return new SchemaDescription.Field(schemaDescription, fieldVal, fieldVal, 2, defaultValue, allowNull);
                }
                SchemaDescription schemaDescription = schema;
                schemaDescription.getClass();
                return new SchemaDescription.Field(schemaDescription, fieldVal, fieldVal, 2, defaultValue, allowNull);
            }
        }
        throw new RuntimeException("Field: " + fieldVal + "  Undefined type: " + f.schema().getType());
    }

    private ObjectNode convertPrimitive(String type, SchemaDescription.Field f) {
        ObjectNode fieldNode = this.mapper.createObjectNode();
        FieldName fieldName = new FieldName(f.formatFieldName, f.pentahoValueMetaType, f.allowNull);
        fieldNode.put("name", fieldName.toString());
        if (f.allowNull) {
            fieldNode.putPOJO("type", (Object)this.mapper.createArrayNode().add("null").add(type));
        } else {
            fieldNode.put("type", type);
        }
        if (f.pentahoValueMetaType == 3) {
            fieldNode.put(AVRO_LOGICAL_TYPE, DATE);
        } else if (f.pentahoValueMetaType == 9) {
            fieldNode.put(AVRO_LOGICAL_TYPE, TIMESTAMP_MILLIS);
        }
        if (f.defaultValue != null) {
            fieldNode.put("default", f.defaultValue);
        }
        return fieldNode;
    }

    private static FieldName parseFieldName(String fieldName) {
        if (fieldName == null && fieldName.length() <= 0 || !fieldName.contains("_delimiter_")) {
            return null;
        }
        String[] splits = fieldName.split("_delimiter_");
        if (splits.length == 0 || splits.length > 3) {
            return null;
        }
        return new FieldName(splits[0], Integer.valueOf(splits[1]), Boolean.parseBoolean(splits[2]));
    }

    public static class FieldName {
        public final String name;
        public final int type;
        public final boolean allowNull;
        public static final String FIELDNAME_DELIMITER = "_delimiter_";

        public FieldName(String name, int type, boolean allowNull) {
            this.name = name;
            this.type = type;
            this.allowNull = allowNull;
        }

        public String toString() {
            StringBuilder o = new StringBuilder(256);
            o.append(this.c(this.name));
            o.append(FIELDNAME_DELIMITER);
            o.append(Integer.toString(this.type));
            o.append(FIELDNAME_DELIMITER);
            o.append(Boolean.toString(this.allowNull));
            return o.toString();
        }

        String c(String s) {
            if (s == null) {
                return "";
            }
            if (s.contains(FIELDNAME_DELIMITER)) {
                throw new RuntimeException("Wrong value: " + s);
            }
            return s;
        }
    }
}

