/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.avro;

import java.io.IOException;
import java.util.Iterator;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericRecord;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.hadoop.shim.api.format.IPentahoInputFormat;
import org.pentaho.hadoop.shim.api.format.SchemaDescription;
import org.pentaho.hadoop.shim.common.format.avro.AvroConverter;

public class PentahoAvroRecordReader
implements IPentahoInputFormat.IPentahoRecordReader {
    private final DataFileStream<GenericRecord> nativeAvroRecordReader;
    private final SchemaDescription avroSchemaDescription;
    private final SchemaDescription metaSchemaDescription;

    public PentahoAvroRecordReader(DataFileStream<GenericRecord> nativeAvroRecordReader, SchemaDescription avroSchemaDescription, SchemaDescription metaSchemaDescription) {
        this.nativeAvroRecordReader = nativeAvroRecordReader;
        this.avroSchemaDescription = avroSchemaDescription;
        this.metaSchemaDescription = metaSchemaDescription;
    }

    public void close() throws IOException {
        this.nativeAvroRecordReader.close();
    }

    public Iterator<RowMetaAndData> iterator() {
        return new Iterator<RowMetaAndData>(){

            @Override
            public boolean hasNext() {
                return PentahoAvroRecordReader.this.nativeAvroRecordReader.hasNext();
            }

            @Override
            public RowMetaAndData next() {
                return AvroConverter.convertFromAvro((GenericRecord)PentahoAvroRecordReader.this.nativeAvroRecordReader.next(), PentahoAvroRecordReader.this.avroSchemaDescription, PentahoAvroRecordReader.this.metaSchemaDescription);
            }
        };
    }
}

