/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.IOException;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordinatorCommand;
import org.apache.oozie.store.CoordinatorStore;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;

public class CoordActionNotification
extends CoordinatorCommand<Void> {
    private CoordinatorActionBean actionBean;
    private static final String STATUS_PATTERN = "\\$status";
    private static final String ACTION_ID_PATTERN = "\\$actionId";
    private int retries = 0;
    private final XLog log = XLog.getLog(this.getClass());

    public CoordActionNotification(CoordinatorActionBean actionBean) {
        super("coord_action_notification", "coord_action_notification", 0, 1);
        this.actionBean = actionBean;
    }

    @Override
    protected Void call(CoordinatorStore store) throws StoreException, CommandException {
        XConfiguration conf;
        this.setLogInfo(this.actionBean);
        this.log.info("STARTED Coordinator Notification actionId=" + this.actionBean.getId() + " : " + this.actionBean.getStatus());
        try {
            conf = new XConfiguration(new StringReader(this.actionBean.getRunConf()));
        }
        catch (IOException e1) {
            this.log.warn("Configuration parse error. read from DB :" + this.actionBean.getRunConf());
            throw new CommandException(ErrorCode.E1005, e1.getMessage(), e1);
        }
        String url = conf.get("oozie.coord.action.notification.url");
        if (url != null) {
            url = url.replaceAll(ACTION_ID_PATTERN, this.actionBean.getId());
            url = url.replaceAll(STATUS_PATTERN, this.actionBean.getStatus().toString());
            this.log.debug("Notification URL :" + url);
            try {
                URL urlObj = new URL(url);
                HttpURLConnection urlConn = (HttpURLConnection)urlObj.openConnection();
                if (urlConn.getResponseCode() != 200) {
                    this.handleRetry(url);
                }
            }
            catch (IOException ex) {
                this.handleRetry(url);
            }
        } else {
            this.log.info("No Notification URL is defined. Therefore nothing to notify for job " + this.actionBean.getJobId() + " action ID " + this.actionBean.getId());
        }
        this.log.info("ENDED Coordinator Notification actionId=" + this.actionBean.getId());
        return null;
    }

    private void handleRetry(String url) {
        if (this.retries < 3) {
            ++this.retries;
            this.queueCallable(this, 60000L);
        } else {
            XLog.getLog(this.getClass()).warn(4, "could not send notification [{0}]", url);
        }
    }
}

