/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.StringReader;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordActionInputCheckCommand;
import org.apache.oozie.coord.CoordELEvaluator;
import org.apache.oozie.coord.CoordELFunctions;
import org.apache.oozie.coord.CoordUtils;
import org.apache.oozie.coord.CoordinatorJobException;
import org.apache.oozie.coord.SyncCoordAction;
import org.apache.oozie.coord.TimeUnit;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;

public class CoordCommandUtils {
    public static int CURRENT = 0;
    public static int LATEST = 1;
    public static int FUTURE = 2;
    public static int UNEXPECTED = -1;
    public static final String RESOLVED_UNRESOLVED_SEPARATOR = ";";

    public static int getInstanceNumber(String function, Element event, SyncCoordAction appInst, Configuration conf, StringBuilder restArg) throws Exception {
        ELEvaluator eval = CoordELEvaluator.createInstancesELEvaluator("coord-action-create-inst", event, appInst, conf);
        String newFunc = CoordELFunctions.evalAndWrap(eval, function);
        int funcType = CoordCommandUtils.getFuncType(newFunc);
        if (funcType == CURRENT || funcType == LATEST) {
            return CoordCommandUtils.parseOneArg(newFunc);
        }
        return CoordCommandUtils.parseMoreArgs(newFunc, restArg);
    }

    private static int parseOneArg(String funcName) throws Exception {
        String tmp;
        int firstPos = funcName.indexOf("(");
        int lastPos = funcName.lastIndexOf(")");
        if (firstPos >= 0 && lastPos > firstPos && (tmp = funcName.substring(firstPos + 1, lastPos).trim()).length() > 0) {
            return (int)Double.parseDouble(tmp);
        }
        throw new RuntimeException("Unformatted function :" + funcName);
    }

    private static int parseMoreArgs(String funcName, StringBuilder restArg) throws Exception {
        String tmp;
        int firstPos = funcName.indexOf("(");
        int secondPos = funcName.lastIndexOf(",");
        int lastPos = funcName.lastIndexOf(")");
        if (firstPos >= 0 && secondPos > firstPos && (tmp = funcName.substring(firstPos + 1, secondPos).trim()).length() > 0) {
            restArg.append(funcName.substring(secondPos + 1, lastPos).trim());
            return (int)Double.parseDouble(tmp);
        }
        throw new RuntimeException("Unformatted function :" + funcName);
    }

    public static int getFuncType(String function) {
        if (function.indexOf("current") >= 0) {
            return CURRENT;
        }
        if (function.indexOf("latest") >= 0) {
            return LATEST;
        }
        if (function.indexOf("future") >= 0) {
            return FUTURE;
        }
        return UNEXPECTED;
    }

    public static void checkIfBothSameType(String startInst, String endInst) throws CommandException {
        if (CoordCommandUtils.getFuncType(startInst) != CoordCommandUtils.getFuncType(endInst)) {
            throw new CommandException(ErrorCode.E1010, " start-instance and end-instance both should be either latest or current or future\n start " + startInst + " and end " + endInst);
        }
    }

    public static void resolveInstances(Element event, StringBuilder instances, SyncCoordAction actionInst, Configuration conf, ELEvaluator eval) throws Exception {
        for (Element eInstance : event.getChildren("instance", event.getNamespace())) {
            if (instances.length() > 0) {
                instances.append("#");
            }
            instances.append(CoordCommandUtils.materializeInstance(event, eInstance.getTextTrim(), actionInst, conf, eval));
        }
        event.removeChildren("instance", event.getNamespace());
    }

    public static void resolveInstanceRange(Element event, StringBuilder instances, SyncCoordAction appInst, Configuration conf, ELEvaluator eval) throws Exception {
        Element eStartInst = event.getChild("start-instance", event.getNamespace());
        Element eEndInst = event.getChild("end-instance", event.getNamespace());
        if (eStartInst != null && eEndInst != null) {
            int startIndex;
            String strStart = eStartInst.getTextTrim();
            String strEnd = eEndInst.getTextTrim();
            CoordCommandUtils.checkIfBothSameType(strStart, strEnd);
            StringBuilder restArg = new StringBuilder();
            restArg.delete(0, restArg.length());
            int endIndex = CoordCommandUtils.getInstanceNumber(strEnd, event, appInst, conf, restArg);
            if (startIndex > endIndex) {
                throw new CommandException(ErrorCode.E1010, " start-instance should be equal or earlier than the end-instance \n" + XmlUtils.prettyPrint(event));
            }
            int funcType = CoordCommandUtils.getFuncType(strStart);
            if (funcType == CURRENT) {
                String matInstance;
                for (int i = endIndex; i >= startIndex && (matInstance = CoordCommandUtils.materializeInstance(event, "${coord:current(" + i + ")}", appInst, conf, eval)) != null && matInstance.length() != 0; --i) {
                    if (instances.length() > 0) {
                        instances.append("#");
                    }
                    instances.append(matInstance);
                }
            } else {
                for (startIndex = CoordCommandUtils.getInstanceNumber(strStart, event, appInst, conf, restArg); startIndex <= endIndex; ++startIndex) {
                    if (instances.length() > 0) {
                        instances.append("#");
                    }
                    if (funcType == LATEST) {
                        instances.append("${coord:latest(" + startIndex + ")}");
                        continue;
                    }
                    instances.append("${coord:future(" + startIndex + ",'" + restArg + "')}");
                }
            }
            event.removeChild("start-instance", event.getNamespace());
            event.removeChild("end-instance", event.getNamespace());
        }
    }

    public static String materializeInstance(Element event, String expr, SyncCoordAction appInst, Configuration conf, ELEvaluator evalInst) throws Exception {
        if (event == null) {
            return null;
        }
        return CoordELFunctions.evalAndWrap(evalInst, expr);
    }

    public static void separateResolvedAndUnresolved(Element event, StringBuilder instances, StringBuffer dependencyList) throws Exception {
        StringBuilder unresolvedInstances = new StringBuilder();
        StringBuilder urisWithDoneFlag = new StringBuilder();
        String uris = CoordCommandUtils.createEarlyURIs(event, instances.toString(), unresolvedInstances, urisWithDoneFlag);
        if (uris.length() > 0) {
            Element uriInstance = new Element("uris", event.getNamespace());
            uriInstance.addContent(uris);
            event.getContent().add(1, uriInstance);
            if (dependencyList.length() > 0) {
                dependencyList.append("#");
            }
            dependencyList.append((CharSequence)urisWithDoneFlag);
        }
        if (unresolvedInstances.length() > 0) {
            Element elemInstance = new Element("unresolved-instances", event.getNamespace());
            elemInstance.addContent(unresolvedInstances.toString());
            event.getContent().add(1, elemInstance);
        }
    }

    public static String createEarlyURIs(Element event, String instances, StringBuilder unresolvedInstances, StringBuilder urisWithDoneFlag) throws Exception {
        if (instances == null || instances.length() == 0) {
            return "";
        }
        String[] instanceList = instances.split("#");
        StringBuilder uris = new StringBuilder();
        Element doneFlagElement = event.getChild("dataset", event.getNamespace()).getChild("done-flag", event.getNamespace());
        String doneFlag = CoordUtils.getDoneFlag(doneFlagElement);
        for (int i = 0; i < instanceList.length; ++i) {
            if (instanceList[i].trim().length() == 0) continue;
            int funcType = CoordCommandUtils.getFuncType(instanceList[i]);
            if (funcType == LATEST || funcType == FUTURE) {
                if (unresolvedInstances.length() > 0) {
                    unresolvedInstances.append("#");
                }
                unresolvedInstances.append(instanceList[i]);
                continue;
            }
            ELEvaluator eval = CoordELEvaluator.createURIELEvaluator(instanceList[i]);
            if (uris.length() > 0) {
                uris.append("#");
                urisWithDoneFlag.append("#");
            }
            String uriPath = CoordELFunctions.evalAndWrap(eval, event.getChild("dataset", event.getNamespace()).getChild("uri-template", event.getNamespace()).getTextTrim());
            uris.append(uriPath);
            if (doneFlag.length() > 0) {
                uriPath = uriPath + "/" + doneFlag;
            }
            urisWithDoneFlag.append(uriPath);
        }
        return uris.toString();
    }

    public static boolean materializeSLA(Element eSla, Date nominalTime, Configuration conf) throws CoordinatorJobException {
        if (eSla == null) {
            return false;
        }
        try {
            ELEvaluator evalSla = CoordELEvaluator.createSLAEvaluator(nominalTime, conf);
            List elemList = eSla.getChildren();
            for (Element elem : elemList) {
                String updated;
                try {
                    updated = CoordELFunctions.evalAndWrap(evalSla, elem.getText().trim());
                }
                catch (Exception e) {
                    throw new CoordinatorJobException(ErrorCode.E1004, e.getMessage(), e);
                }
                elem.removeContent();
                elem.addContent(updated);
            }
        }
        catch (Exception e) {
            throw new CoordinatorJobException(ErrorCode.E1004, e.getMessage(), e);
        }
        return true;
    }

    public static String materializeOneInstance(String jobId, boolean dryrun, Element eAction, Date nominalTime, Date actualTime, int instanceCount, Configuration conf, CoordinatorActionBean actionBean) throws Exception {
        String actionId = Services.get().get(UUIDService.class).generateChildId(jobId, instanceCount + "");
        SyncCoordAction appInst = new SyncCoordAction();
        appInst.setActionId(actionId);
        appInst.setName(eAction.getAttributeValue("name"));
        appInst.setNominalTime(nominalTime);
        appInst.setActualTime(actualTime);
        int frequency = Integer.parseInt(eAction.getAttributeValue("frequency"));
        appInst.setFrequency(frequency);
        appInst.setTimeUnit(TimeUnit.valueOf(eAction.getAttributeValue("freq_timeunit")));
        appInst.setTimeZone(DateUtils.getTimeZone(eAction.getAttributeValue("timezone")));
        appInst.setEndOfDuration(TimeUnit.valueOf(eAction.getAttributeValue("end_of_duration")));
        StringBuffer dependencyList = new StringBuffer();
        Element inputList = eAction.getChild("input-events", eAction.getNamespace());
        List dataInList = null;
        if (inputList != null) {
            dataInList = inputList.getChildren("data-in", eAction.getNamespace());
            CoordCommandUtils.materializeDataEvents(dataInList, appInst, conf, dependencyList);
        }
        Element outputList = eAction.getChild("output-events", eAction.getNamespace());
        List dataOutList = null;
        if (outputList != null) {
            dataOutList = outputList.getChildren("data-out", eAction.getNamespace());
            StringBuffer tmp = new StringBuffer();
            CoordCommandUtils.materializeDataEvents(dataOutList, appInst, conf, tmp);
        }
        eAction.removeAttribute("start");
        eAction.removeAttribute("end");
        eAction.setAttribute("instance-number", Integer.toString(instanceCount));
        eAction.setAttribute("action-nominal-time", DateUtils.formatDateUTC(nominalTime));
        eAction.setAttribute("action-actual-time", DateUtils.formatDateUTC(actualTime));
        boolean isSla = CoordCommandUtils.materializeSLA(eAction.getChild("action", eAction.getNamespace()).getChild("info", eAction.getNamespace("sla")), nominalTime, conf);
        actionBean.setCreatedConf(XmlUtils.prettyPrint(conf).toString());
        actionBean.setRunConf(XmlUtils.prettyPrint(conf).toString());
        actionBean.setCreatedTime(actualTime);
        actionBean.setJobId(jobId);
        actionBean.setId(actionId);
        actionBean.setLastModifiedTime(new Date());
        actionBean.setStatus(CoordinatorAction.Status.WAITING);
        actionBean.setActionNumber(instanceCount);
        actionBean.setMissingDependencies(dependencyList.toString());
        actionBean.setNominalTime(nominalTime);
        if (isSla) {
            actionBean.setSlaXml(XmlUtils.prettyPrint(eAction.getChild("action", eAction.getNamespace()).getChild("info", eAction.getNamespace("sla"))).toString());
        }
        if (!dryrun) {
            return XmlUtils.prettyPrint(eAction).toString();
        }
        String action = XmlUtils.prettyPrint(eAction).toString();
        CoordActionInputCheckCommand coordActionInput = new CoordActionInputCheckCommand(actionBean.getId());
        StringBuilder actionXml = new StringBuilder(action);
        StringBuilder existList = new StringBuilder();
        StringBuilder nonExistList = new StringBuilder();
        StringBuilder nonResolvedList = new StringBuilder();
        CoordCommandUtils.getResolvedList(actionBean.getMissingDependencies(), nonExistList, nonResolvedList);
        XConfiguration actionConf = new XConfiguration(new StringReader(actionBean.getRunConf()));
        coordActionInput.checkInput(actionXml, existList, nonExistList, actionConf);
        return actionXml.toString();
    }

    public static void materializeDataEvents(List<Element> events, SyncCoordAction appInst, Configuration conf, StringBuffer dependencyList) throws Exception {
        if (events == null) {
            return;
        }
        StringBuffer unresolvedList = new StringBuffer();
        for (Element event : events) {
            StringBuilder instances = new StringBuilder();
            ELEvaluator eval = CoordELEvaluator.createInstancesELEvaluator(event, appInst, conf);
            CoordCommandUtils.resolveInstances(event, instances, appInst, conf, eval);
            CoordCommandUtils.resolveInstanceRange(event, instances, appInst, conf, eval);
            CoordCommandUtils.separateResolvedAndUnresolved(event, instances, dependencyList);
            String tmpUnresolved = event.getChildTextTrim("unresolved-instances", event.getNamespace());
            if (tmpUnresolved == null) continue;
            if (unresolvedList.length() > 0) {
                unresolvedList.append("#");
            }
            unresolvedList.append(tmpUnresolved);
        }
        if (unresolvedList.length() > 0) {
            dependencyList.append(RESOLVED_UNRESOLVED_SEPARATOR);
            dependencyList.append(unresolvedList);
        }
    }

    public static String getResolvedList(String missDepList, StringBuilder resolved, StringBuilder unresolved) {
        if (missDepList != null) {
            int index = missDepList.indexOf(RESOLVED_UNRESOLVED_SEPARATOR);
            if (index < 0) {
                resolved.append(missDepList);
            } else {
                resolved.append(missDepList.substring(0, index));
                unresolved.append(missDepList.substring(index + 1));
            }
        }
        return resolved.toString();
    }
}

