/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.DagELFunctions;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.wf.ActionEndCommand;
import org.apache.oozie.command.wf.KillCommand;
import org.apache.oozie.command.wf.NotificationCommand;
import org.apache.oozie.command.wf.SuspendCommand;
import org.apache.oozie.command.wf.WorkflowCommand;
import org.apache.oozie.service.CallbackService;
import org.apache.oozie.service.ELService;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.store.WorkflowStore;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.lite.LiteWorkflowInstance;

public abstract class ActionCommand<T>
extends WorkflowCommand<Void> {
    private static final String INSTRUMENTATION_GROUP = "action.executors";
    protected static final String INSTR_FAILED_JOBS_COUNTER = "failed";
    protected static final String RECOVERY_ID_SEPARATOR = "@";

    public ActionCommand(String name, String type, int priority) {
        super(name, type, priority, 1);
    }

    protected boolean handleTransient(ActionExecutor.Context context, ActionExecutor executor, WorkflowAction.Status status) throws StoreException, CommandException {
        XLog.getLog(this.getClass()).debug("Attempting to retry");
        ActionExecutorContext aContext = (ActionExecutorContext)context;
        WorkflowActionBean action = (WorkflowActionBean)aContext.getAction();
        this.incrActionErrorCounter(action.getType(), "transient", 1);
        int actionRetryCount = action.getRetries();
        if (actionRetryCount >= executor.getMaxRetries()) {
            XLog.getLog(this.getClass()).warn("Exceeded max retry count [{0}]. Suspending Job", executor.getMaxRetries());
            return false;
        }
        action.setStatus(status);
        action.setPending();
        action.incRetries();
        long retryDelayMillis = executor.getRetryInterval() * 1000L;
        action.setPendingAge(new Date(System.currentTimeMillis() + retryDelayMillis));
        XLog.getLog(this.getClass()).info("Next Retry, Attempt Number [{0}] in [{1}] milliseconds", actionRetryCount + 1, retryDelayMillis);
        this.queueCallable(this, retryDelayMillis);
        return true;
    }

    protected void handleNonTransient(WorkflowStore store, ActionExecutor.Context context, ActionExecutor executor, WorkflowAction.Status status) throws StoreException, CommandException {
        ActionExecutorContext aContext = (ActionExecutorContext)context;
        WorkflowActionBean action = (WorkflowActionBean)aContext.getAction();
        this.incrActionErrorCounter(action.getType(), "nontransient", 1);
        WorkflowJobBean workflow = (WorkflowJobBean)context.getWorkflow();
        String id = workflow.getId();
        action.setStatus(status);
        action.resetPendingOnly();
        XLog.getLog(this.getClass()).warn("Suspending Workflow Job id=" + id);
        try {
            SuspendCommand.suspendJob(store, workflow, id, action.getId());
        }
        catch (WorkflowException e) {
            throw new CommandException(e);
        }
    }

    protected void handleError(ActionExecutor.Context context, ActionExecutor executor, String message, boolean isStart, WorkflowAction.Status status) throws CommandException {
        XLog.getLog(this.getClass()).warn("Setting Action Status to [{0}]", status);
        ActionExecutorContext aContext = (ActionExecutorContext)context;
        WorkflowActionBean action = (WorkflowActionBean)aContext.getAction();
        this.incrActionErrorCounter(action.getType(), "error", 1);
        action.setPending();
        if (isStart) {
            action.setExecutionData(message, null);
            this.queueCallable(new ActionEndCommand(action.getId(), action.getType()));
        } else {
            action.setEndData(status, WorkflowAction.Status.ERROR.toString());
        }
    }

    public void failJob(ActionExecutor.Context context) throws CommandException {
        ActionExecutorContext aContext = (ActionExecutorContext)context;
        WorkflowActionBean action = (WorkflowActionBean)aContext.getAction();
        this.incrActionErrorCounter(action.getType(), INSTR_FAILED_JOBS_COUNTER, 1);
        WorkflowJobBean workflow = (WorkflowJobBean)context.getWorkflow();
        XLog.getLog(this.getClass()).warn("Failing Job due to failed action [{0}]", action.getName());
        try {
            workflow.getWorkflowInstance().fail(action.getName());
            WorkflowInstance wfInstance = workflow.getWorkflowInstance();
            ((LiteWorkflowInstance)wfInstance).setStatus(WorkflowInstance.Status.FAILED);
            workflow.setWorkflowInstance(wfInstance);
            workflow.setStatus(WorkflowJob.Status.FAILED);
            action.setStatus(WorkflowAction.Status.FAILED);
            action.resetPending();
            this.queueCallable(new NotificationCommand(workflow, action));
            this.queueCallable(new KillCommand(workflow.getId()));
            this.incrJobCounter(INSTR_FAILED_JOBS_COUNTER, 1);
        }
        catch (WorkflowException ex) {
            throw new CommandException(ex);
        }
    }

    private void incrActionErrorCounter(String type, String error, int count) {
        this.getInstrumentation().incr(INSTRUMENTATION_GROUP, type + "#ex." + error, count);
    }

    protected void incrActionCounter(String type, int count) {
        this.getInstrumentation().incr(INSTRUMENTATION_GROUP, type + "#" + this.getName(), count);
    }

    protected void addActionCron(String type, Instrumentation.Cron cron) {
        this.getInstrumentation().addCron(INSTRUMENTATION_GROUP, type + "#" + this.getName(), cron);
    }

    public static class ActionExecutorContext
    implements ActionExecutor.Context {
        private WorkflowJobBean workflow;
        private Configuration protoConf;
        private WorkflowActionBean action;
        private boolean isRetry;
        private boolean started;
        private boolean ended;
        private boolean executed;

        public ActionExecutorContext(WorkflowJobBean workflow, WorkflowActionBean action, boolean isRetry) {
            this.workflow = workflow;
            this.action = action;
            this.isRetry = isRetry;
            try {
                this.protoConf = new XConfiguration(new StringReader(workflow.getProtoActionConf()));
            }
            catch (IOException ex) {
                throw new RuntimeException("It should not happen", ex);
            }
        }

        @Override
        public String getCallbackUrl(String externalStatusVar) {
            return Services.get().get(CallbackService.class).createCallBackUrl(this.action.getId(), externalStatusVar);
        }

        @Override
        public Configuration getProtoActionConf() {
            return this.protoConf;
        }

        @Override
        public WorkflowJob getWorkflow() {
            return this.workflow;
        }

        public WorkflowAction getAction() {
            return this.action;
        }

        @Override
        public ELEvaluator getELEvaluator() {
            ELEvaluator evaluator = Services.get().get(ELService.class).createEvaluator("workflow");
            DagELFunctions.configureEvaluator(evaluator, this.workflow, this.action);
            return evaluator;
        }

        @Override
        public void setVar(String name, String value) {
            name = this.action.getName() + "#" + name;
            WorkflowInstance wfInstance = this.workflow.getWorkflowInstance();
            wfInstance.setVar(name, value);
            this.workflow.setWorkflowInstance(wfInstance);
        }

        @Override
        public String getVar(String name) {
            name = this.action.getName() + "#" + name;
            return this.workflow.getWorkflowInstance().getVar(name);
        }

        @Override
        public void setStartData(String externalId, String trackerUri, String consoleUrl) {
            this.action.setStartData(externalId, trackerUri, consoleUrl);
            this.started = true;
        }

        @Override
        public void setExecutionData(String externalStatus, Properties actionData) {
            this.action.setExecutionData(externalStatus, actionData);
            this.executed = true;
        }

        @Override
        public void setEndData(WorkflowAction.Status status, String signalValue) {
            this.action.setEndData(status, signalValue);
            this.ended = true;
        }

        @Override
        public boolean isRetry() {
            return this.isRetry;
        }

        public boolean isStarted() {
            return this.started;
        }

        public boolean isExecuted() {
            return this.executed;
        }

        public boolean isEnded() {
            return this.ended;
        }

        @Override
        public void setExternalStatus(String externalStatus) {
            this.action.setExternalStatus(externalStatus);
        }

        @Override
        public String getRecoveryId() {
            return this.action.getId() + ActionCommand.RECOVERY_ID_SEPARATOR + this.workflow.getRun();
        }

        @Override
        public Path getActionDir() throws HadoopAccessorException, IOException, URISyntaxException {
            String name = this.getWorkflow().getId() + "/" + this.action.getName() + "--" + this.action.getType();
            FileSystem fs = this.getAppFileSystem();
            String actionDirPath = Services.get().getSystemId() + "/" + name;
            Path fqActionDir = new Path(fs.getHomeDirectory(), actionDirPath);
            return fqActionDir;
        }

        @Override
        public FileSystem getAppFileSystem() throws HadoopAccessorException, IOException, URISyntaxException {
            WorkflowJob workflow = this.getWorkflow();
            XConfiguration jobConf = new XConfiguration(new StringReader(workflow.getConf()));
            Configuration fsConf = new Configuration();
            XConfiguration.copy(jobConf, fsConf);
            return Services.get().get(HadoopAccessorService.class).createFileSystem(workflow.getUser(), workflow.getGroup(), new URI(this.getWorkflow().getAppPath()), fsConf);
        }

        @Override
        public void setErrorInfo(String str, String exMsg) {
            this.action.setErrorInfo(str, exMsg);
        }
    }
}

