/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.DagEngine;
import org.apache.oozie.DagEngineException;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.WorkflowsInfo;
import org.apache.oozie.service.DagEngineService;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.JobServlet;
import org.apache.oozie.servlet.JsonRestServlet;
import org.apache.oozie.servlet.XServletException;
import org.apache.oozie.util.XConfiguration;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class JobsServlet
extends JsonRestServlet {
    private static final String INSTRUMENTATION_NAME = "jobs";
    private static final JsonRestServlet.ResourceInfo[] RESOURCES_INFO = new JsonRestServlet.ResourceInfo[1];

    public JobsServlet() {
        super(INSTRUMENTATION_NAME, RESOURCES_INFO);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.validateContentType(request, "application/xml");
        request.setAttribute("audit.operation", (Object)request.getParameter("action"));
        XConfiguration conf = new XConfiguration((InputStream)request.getInputStream());
        this.stopCron();
        conf = conf.trim();
        conf = conf.resolve();
        JobsServlet.validateJobConfiguration(conf);
        JobServlet.checkAuthorizationForApp(this.getUser(request), conf);
        String action = request.getParameter("action");
        if (action != null && !action.equals("start")) {
            throw new XServletException(400, ErrorCode.E0303, "action", action);
        }
        try {
            boolean startJob = action != null;
            String user = conf.get("user.name");
            DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(user, this.getAuthToken(request));
            String id = dagEngine.submitJob(conf, startJob);
            JSONObject json = new JSONObject();
            json.put((Object)"id", (Object)id);
            this.startCron();
            this.sendJsonResponse(response, 201, (JSONStreamAware)json);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    static void validateJobConfiguration(Configuration conf) throws XServletException {
        if (conf.get("user.name") == null) {
            throw new XServletException(400, ErrorCode.E0401, "user.name");
        }
        String localRealm = Services.get().getConf().get("local.realm");
        if (conf.get("mapreduce.jobtracker.kerberos.principal") == null) {
            conf.set("mapreduce.jobtracker.kerberos.principal", "mapred/_HOST@" + localRealm);
        }
        if (conf.get("dfs.namenode.kerberos.principal") == null) {
            conf.set("dfs.namenode.kerberos.principal", "hdfs/_HOST@" + localRealm);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String externalId = request.getParameter("external-id");
            if (externalId != null) {
                this.stopCron();
                DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request), this.getAuthToken(request));
                String jobId = dagEngine.getJobIdForExternalId(externalId);
                JSONObject json = new JSONObject();
                json.put((Object)"id", (Object)jobId);
                this.startCron();
                this.sendJsonResponse(response, 200, (JSONStreamAware)json);
            } else {
                String filter = request.getParameter("filter");
                String startStr = request.getParameter("offset");
                String lenStr = request.getParameter("len");
                int start = startStr != null ? Integer.parseInt(startStr) : 1;
                start = start < 1 ? 1 : start;
                int len = lenStr != null ? Integer.parseInt(lenStr) : 50;
                len = len < 1 ? 50 : len;
                this.stopCron();
                DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request), this.getAuthToken(request));
                WorkflowsInfo jobs = dagEngine.getJobs(filter, start, len);
                List<WorkflowJobBean> jsonWorkflows = jobs.getWorkflows();
                this.startCron();
                JSONObject json = new JSONObject();
                json.put((Object)"workflows", (Object)WorkflowJobBean.toJSONArray(jsonWorkflows));
                json.put((Object)"total", (Object)jobs.getTotal());
                json.put((Object)"offset", (Object)jobs.getStart());
                json.put((Object)"len", (Object)jobs.getLen());
                this.sendJsonResponse(response, 200, (JSONStreamAware)json);
            }
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    static {
        JobsServlet.RESOURCES_INFO[0] = new JsonRestServlet.ResourceInfo("", Arrays.asList("POST", "GET"), Arrays.asList(new JsonRestServlet.ParameterInfo("action", String.class, false, Arrays.asList("POST")), new JsonRestServlet.ParameterInfo("filter", String.class, false, Arrays.asList("GET")), new JsonRestServlet.ParameterInfo("jobtype", String.class, false, Arrays.asList("GET")), new JsonRestServlet.ParameterInfo("offset", String.class, false, Arrays.asList("GET")), new JsonRestServlet.ParameterInfo("len", String.class, false, Arrays.asList("GET")), new JsonRestServlet.ParameterInfo("external-id", String.class, false, Arrays.asList("GET"))));
    }
}

