/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.engine.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdNodeBasedDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.di.engine.api.events.LogEvent;
import org.pentaho.di.engine.api.model.LogicalModelElement;
import org.pentaho.di.engine.api.remote.RemoteSource;
import org.pentaho.di.engine.api.reporting.LogEntry;
import org.pentaho.di.engine.api.reporting.LogLevel;
import org.pentaho.pdi.engine.serializers.BaseSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogEventSerializer
extends BaseSerializer<LogEvent> {
    public static final DateFormat DATE_TIME_INSTANCE = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public LogEventSerializer() {
        super(LogEvent.class);
        SimpleModule module = new SimpleModule();
        module.addSerializer(LogEvent.class, (JsonSerializer)new JsonSerializer<LogEvent>(){

            public void serialize(LogEvent logEvent, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
                Map extras;
                jsonGenerator.writeStartObject();
                LogEntry data = (LogEntry)logEvent.getData();
                jsonGenerator.writeStringField("message", data.getMessage());
                if (data.getThrowable() != null) {
                    StringWriter stackTrace = new StringWriter();
                    data.getThrowable().printStackTrace(new PrintWriter(stackTrace));
                    jsonGenerator.writeStringField("stacktrace", stackTrace.toString());
                }
                if ((extras = data.getExtras()).size() > 0) {
                    jsonGenerator.writeArrayFieldStart("extras");
                    for (Map.Entry entry : extras.entrySet()) {
                        jsonGenerator.writeStartObject();
                        jsonGenerator.writeStringField("key", (String)entry.getKey());
                        jsonGenerator.writeStringField("value", (String)entry.getValue());
                        jsonGenerator.writeEndObject();
                    }
                    jsonGenerator.writeEndArray();
                }
                jsonGenerator.writeStringField("timestamp", DATE_TIME_INSTANCE.format(data.getTimestamp()));
                jsonGenerator.writeStringField("level", data.getLogLogLevel().toString());
                jsonGenerator.writeStringField("model-id", logEvent.getSource().getId());
                jsonGenerator.writeEndObject();
            }
        });
        module.addDeserializer(LogEvent.class, (JsonDeserializer)new StdNodeBasedDeserializer<LogEvent>(LogEvent.class){

            public LogEvent convert(JsonNode jsonNode, DeserializationContext deserializationContext) throws IOException {
                LogEntry.LogEntryBuilder builder = new LogEntry.LogEntryBuilder();
                builder.withLogLevel(LogLevel.valueOf((String)jsonNode.get("level").asText()));
                try {
                    builder.withTimestamp(DATE_TIME_INSTANCE.parse(jsonNode.get("timestamp").asText()));
                }
                catch (ParseException e) {
                    LogEventSerializer.this.logger.error("Error parsing Log timestamp: " + jsonNode.get("timestamp"));
                    builder.withTimestamp(new Date());
                }
                if (jsonNode.has("stacktrace")) {
                    builder.withMessage(jsonNode.get("message").asText() + "\n\nStackTrace: \n" + jsonNode.get("stacktrace").asText());
                } else {
                    builder.withMessage(jsonNode.get("message").asText());
                }
                if (jsonNode.has("extras")) {
                    HashMap<String, String> extras = new HashMap<String, String>();
                    for (JsonNode extra : jsonNode.get("extras")) {
                        extras.put(extra.get("key").asText(), extra.get("value").asText());
                    }
                    builder.withExtras(extras);
                }
                LogEntry entry = builder.build();
                return new LogEvent((LogicalModelElement)new RemoteSource(jsonNode.get("model-id").asText()), entry);
            }
        });
        this.mapper.registerModule((Module)module);
    }
}

