/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pdi.engine.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdNodeBasedDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.pentaho.di.engine.api.events.MetricsEvent;
import org.pentaho.di.engine.api.model.LogicalModelElement;
import org.pentaho.di.engine.api.remote.RemoteSource;
import org.pentaho.di.engine.api.reporting.Metrics;
import org.pentaho.pdi.engine.serializers.BaseSerializer;

public class MetricsEventSerializer
extends BaseSerializer<MetricsEvent> {
    public MetricsEventSerializer() {
        super(MetricsEvent.class);
        SimpleModule module = new SimpleModule();
        module.addSerializer(MetricsEvent.class, (JsonSerializer)new JsonSerializer<MetricsEvent>(){

            public void serialize(MetricsEvent metricsEvent, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
                jsonGenerator.writeStartObject();
                Metrics data = (Metrics)metricsEvent.getData();
                jsonGenerator.writeStringField("model-id", metricsEvent.getSource().getId());
                jsonGenerator.writeNumberField("dropped", data.getDropped());
                jsonGenerator.writeNumberField("in", data.getIn());
                jsonGenerator.writeNumberField("in-flight", data.getInFlight());
                jsonGenerator.writeNumberField("out", data.getOut());
                jsonGenerator.writeEndObject();
            }
        });
        module.addDeserializer(MetricsEvent.class, (JsonDeserializer)new StdNodeBasedDeserializer<MetricsEvent>(MetricsEvent.class){

            public MetricsEvent convert(JsonNode jsonNode, DeserializationContext deserializationContext) throws IOException {
                Metrics metrics = new Metrics((long)jsonNode.get("in").asInt(), (long)jsonNode.get("out").asInt(), (long)jsonNode.get("dropped").asInt(), (long)jsonNode.get("in-flight").asInt());
                return new MetricsEvent((LogicalModelElement)new RemoteSource(jsonNode.get("model-id").asText()), metrics);
            }
        });
        this.mapper.registerModule((Module)module);
    }
}

