/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.ui.controller;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.Const;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.serialization.DataServiceValidationException;
import org.pentaho.di.trans.dataservice.ui.DataServiceDelegate;
import org.pentaho.di.trans.dataservice.ui.DataServiceDialog;
import org.pentaho.di.trans.dataservice.ui.controller.AbstractController;
import org.pentaho.di.trans.dataservice.ui.model.DataServiceModel;
import org.pentaho.di.ui.util.HelpUtils;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulMenuList;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.swt.tags.SwtDialog;

public class DataServiceDialogController
extends AbstractController {
    public static final String XUL_DIALOG_ID = "dataservice-dialog";
    private final DataServiceDelegate delegate;
    private final DataServiceModel model;
    private DataServiceMeta dataService;
    private static final Class<?> PKG = DataServiceDialog.class;
    private static final String NAME = "dataServiceDialogController";

    public DataServiceDialogController(DataServiceModel model, DataServiceDelegate delegate) {
        this.setName(NAME);
        this.delegate = delegate;
        this.model = model;
    }

    public void init() throws InvocationTargetException, XulException {
        BindingFactory bindingFactory = this.getBindingFactory();
        XulTextbox serviceName = (XulTextbox)this.getElementById("service-name");
        XulMenuList steps = (XulMenuList)this.getElementById("trans-steps");
        steps.setElements((Collection)ImmutableList.copyOf((Object[])this.model.getTransMeta().getStepNames()));
        bindingFactory.setBindingType(Binding.Type.BI_DIRECTIONAL);
        bindingFactory.createBinding((Object)this.model, "serviceStep", (Object)steps, "selectedItem", new BindingConvertor[0]).fireSourceChanged();
        bindingFactory.createBinding((Object)this.model, "serviceName", (Object)serviceName, "value", new BindingConvertor[0]).fireSourceChanged();
    }

    public void showTestDialog() throws XulException {
        if (this.dataServiceHasNoName(this.model)) {
            return;
        }
        this.delegate.showTestDataServiceDialog(this.model.getDataService(), this.getDialog().getShell());
    }

    public void saveAndClose() throws XulException {
        try {
            if (this.dataServiceHasNoName(this.model)) {
                return;
            }
            String existing = this.dataService != null ? this.dataService.getName() : null;
            this.delegate.save(this.delegate.checkConflict(this.delegate.checkDefined(this.model.getDataService()), existing));
            if (this.dataService != null && !this.model.getServiceName().equals(existing)) {
                this.delegate.removeDataService(this.dataService);
            }
            this.delegate.createSyncService().install(this.model.getTransMeta());
            this.close();
        }
        catch (DataServiceValidationException e) {
            this.error(BaseMessages.getString(PKG, (String)"DataServiceDialog.SaveError.Title", (String[])new String[0]), e.getMessage());
        }
        catch (Exception e) {
            this.error(BaseMessages.getString(PKG, (String)"DataServiceDialog.SaveError.Title", (String[])new String[0]), e.getMessage());
            this.getLogChannel().logError(e.getMessage(), (Throwable)e);
        }
    }

    public void open() {
        this.getDialog().show();
    }

    public void close() {
        this.getDialog().dispose();
    }

    public void showHelp() {
        String title = BaseMessages.getString(PKG, (String)"DataServiceDialog.Help.Title", (String[])new String[0]);
        String docUrl = Const.getDocUrl((String)BaseMessages.getString(PKG, (String)"DataServiceDialog.Help.Url", (String[])new String[0]));
        String header = "";
        HelpUtils.openHelpDialog((Shell)this.getDialog().getShell(), (String)title, (String)docUrl, (String)header);
    }

    public void showDriverDetailsDialog() {
        this.delegate.showDriverDetailsDialog(this.getDialog().getShell());
    }

    SwtDialog getDialog() {
        return (SwtDialog)this.getElementById(XUL_DIALOG_ID);
    }

    public void setDataService(DataServiceMeta dataService) {
        this.dataService = dataService;
    }

    private boolean dataServiceHasNoName(DataServiceModel serviceModel) throws XulException {
        boolean noName = Strings.isNullOrEmpty((String)serviceModel.getServiceName());
        if (noName) {
            this.error(BaseMessages.getString(PKG, (String)"DataServiceDialog.NameMissingError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DataServiceDialog.NameMissingError.Message", (String[])new String[0]));
        }
        return noName;
    }
}

