/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.avro;

import java.io.IOException;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.commons.vfs2.FileExtensionSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.hadoop.shim.api.format.IPentahoAvroInputFormat;
import org.pentaho.hadoop.shim.api.format.IPentahoInputFormat;
import org.pentaho.hadoop.shim.api.format.SchemaDescription;
import org.pentaho.hadoop.shim.common.format.avro.AvroSchemaConverter;
import org.pentaho.hadoop.shim.common.format.avro.PentahoAvroRecordReader;

public class PentahoAvroInputFormat
implements IPentahoAvroInputFormat {
    private String fileName;
    private String schemaFileName;
    private SchemaDescription schemaDescriptionFromMeta;

    public List<IPentahoInputFormat.IPentahoInputSplit> getSplits() throws Exception {
        return null;
    }

    public IPentahoInputFormat.IPentahoRecordReader createRecordReader(IPentahoInputFormat.IPentahoInputSplit split) throws Exception {
        DataFileStream<GenericRecord> dfs = this.createDataFileStream(this.schemaFileName, this.fileName);
        if (dfs == null) {
            throw new Exception("Unable to read data from file " + this.fileName);
        }
        SchemaDescription avroSchemaDescription = null;
        SchemaDescription metaSchemaDescription = null;
        avroSchemaDescription = this.readSchema(this.schemaFileName, this.fileName);
        metaSchemaDescription = this.schemaDescriptionFromMeta;
        return new PentahoAvroRecordReader(dfs, avroSchemaDescription, metaSchemaDescription);
    }

    public SchemaDescription readSchema(String schemaFileName, String fileName) throws Exception {
        if (schemaFileName != null && schemaFileName.length() > 0) {
            return AvroSchemaConverter.createSchemaDescription(this.readAvroSchema(schemaFileName));
        }
        if (fileName != null && fileName.length() > 0) {
            DataFileStream<GenericRecord> dataFileStream = this.createDataFileStream(schemaFileName, fileName);
            SchemaDescription schemaDescription = AvroSchemaConverter.createSchemaDescription(dataFileStream.getSchema());
            dataFileStream.close();
            return schemaDescription;
        }
        throw new Exception("The file you provided does not contain a schema.  Please choose a schema file, or another file that contains a schema.");
    }

    public void setSchema(SchemaDescription schema) throws Exception {
        this.schemaDescriptionFromMeta = schema;
    }

    public void setInputFile(String fileName) throws Exception {
        this.fileName = fileName;
    }

    public void setInputSchemaFile(String schemaFileName) throws Exception {
        this.schemaFileName = schemaFileName;
    }

    public void setSplitSize(long blockSize) throws Exception {
    }

    private Schema readAvroSchema(String schemaFile) throws KettleFileException, IOException {
        return new Schema.Parser().parse(KettleVFS.getInputStream((String)schemaFile));
    }

    private DataFileStream<GenericRecord> createDataFileStream(String schemaFileName, String fileName) throws Exception {
        GenericDatumReader datumReader = schemaFileName != null && schemaFileName.length() > 0 ? new GenericDatumReader(this.readAvroSchema(schemaFileName)) : new GenericDatumReader();
        FileObject fileObject = KettleVFS.getFileObject((String)fileName);
        if (fileObject.isFile()) {
            return new DataFileStream(fileObject.getContent().getInputStream(), (DatumReader)datumReader);
        }
        Object[] avroFiles = fileObject.findFiles((FileSelector)new FileExtensionSelector(new String[]{"avro"}));
        if (!Utils.isEmpty((Object[])avroFiles)) {
            return new DataFileStream(avroFiles[0].getContent().getInputStream(), (DatumReader)datumReader);
        }
        return null;
    }
}

