/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.mql.dialect;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.pms.core.exception.PentahoMetadataException;
import org.pentaho.pms.messages.Messages;
import org.pentaho.pms.messages.util.LocaleHelper;
import org.pentaho.pms.mql.DateMath;
import org.pentaho.pms.mql.dialect.DefaultSQLFunctionGenerator;
import org.pentaho.pms.mql.dialect.DefaultSQLOperatorGenerator;
import org.pentaho.pms.mql.dialect.FormulaTraversalInterface;
import org.pentaho.pms.mql.dialect.JoinType;
import org.pentaho.pms.mql.dialect.SQLDialectInterface;
import org.pentaho.pms.mql.dialect.SQLFunctionGeneratorInterface;
import org.pentaho.pms.mql.dialect.SQLJoin;
import org.pentaho.pms.mql.dialect.SQLOperatorGeneratorInterface;
import org.pentaho.pms.mql.dialect.SQLQueryModel;
import org.pentaho.pms.util.Const;
import org.pentaho.reporting.libraries.formula.lvalues.ContextLookup;
import org.pentaho.reporting.libraries.formula.lvalues.FormulaFunction;
import org.pentaho.reporting.libraries.formula.lvalues.StaticValue;

public class DefaultSQLDialect
implements SQLDialectInterface {
    private static final String TOP_KEYWORD = "TOP";
    protected Map<String, SQLFunctionGeneratorInterface> supportedFunctions = new HashMap<String, SQLFunctionGeneratorInterface>();
    protected Map<String, SQLOperatorGeneratorInterface> supportedInfixOperators = new HashMap<String, SQLOperatorGeneratorInterface>();
    String databaseType;
    DatabaseMeta databaseMeta;
    private String concatOperator = System.getProperty("default.sql.dialect.concat.operator", "||");

    public DefaultSQLDialect() {
        this("GENERIC");
    }

    public DefaultSQLDialect(String databaseType) {
        this.databaseType = databaseType;
        this.databaseMeta = new DatabaseMeta("", databaseType, "Native", "", "", "", "", "");
        this.supportedFunctions.put("AND", new DefaultSQLFunctionGenerator(0, "AND"));
        this.supportedFunctions.put("OR", new DefaultSQLFunctionGenerator(0, "OR"));
        this.supportedFunctions.put("NOT", new DefaultSQLFunctionGenerator(1, "NOT", 1));
        this.supportedFunctions.put("ISNA", new DefaultSQLFunctionGenerator(0, "IS NULL", 1));
        this.supportedFunctions.put("NULL", new DefaultSQLFunctionGenerator(1, "NULL", false));
        this.supportedInfixOperators.put("+", new DefaultSQLOperatorGenerator("+"));
        this.supportedInfixOperators.put("-", new DefaultSQLOperatorGenerator("-"));
        this.supportedInfixOperators.put("*", new DefaultSQLOperatorGenerator("*"));
        this.supportedInfixOperators.put("/", new DefaultSQLOperatorGenerator("/"));
        this.supportedInfixOperators.put("=", new DefaultSQLOperatorGenerator("="));
        this.supportedInfixOperators.put("<", new DefaultSQLOperatorGenerator("<"));
        this.supportedInfixOperators.put(">", new DefaultSQLOperatorGenerator(">"));
        this.supportedInfixOperators.put("<=", new DefaultSQLOperatorGenerator("<="));
        this.supportedInfixOperators.put(">=", new DefaultSQLOperatorGenerator(">="));
        this.supportedInfixOperators.put("<>", new DefaultSQLOperatorGenerator("<>"));
        this.supportedInfixOperators.put("LIKE", new DefaultSQLOperatorGenerator("LIKE"));
        this.supportedFunctions.put("LIKE", new DefaultSQLFunctionGenerator(0, "LIKE", 2, false){});
        this.supportedFunctions.put("CONTAINS", new DefaultSQLFunctionGenerator(0, "LIKE", 2, false){

            @Override
            public void generateFunctionSQL(FormulaTraversalInterface formula, StringBuffer sb, String locale, FormulaFunction f) throws PentahoMetadataException {
                if (f.getChildValues() != null && f.getChildValues().length > 0) {
                    formula.generateSQL(f, f.getChildValues()[0], sb, locale);
                    String quotedWildcard = DefaultSQLDialect.this.quoteStringLiteral(DefaultSQLDialect.this.getStringWildCard());
                    for (int i = 1; i < f.getChildValues().length; ++i) {
                        sb.append(" " + this.getSQL() + " ");
                        StringBuffer tmpsb = new StringBuffer();
                        formula.generateSQL(f, f.getChildValues()[i], tmpsb, locale);
                        sb.append(DefaultSQLDialect.this.generateStringConcat(quotedWildcard, tmpsb.toString(), quotedWildcard));
                    }
                }
            }
        });
        this.supportedFunctions.put("BEGINSWITH", new DefaultSQLFunctionGenerator(0, "LIKE", 2, false){

            @Override
            public void generateFunctionSQL(FormulaTraversalInterface formula, StringBuffer sb, String locale, FormulaFunction f) throws PentahoMetadataException {
                if (f.getChildValues() != null && f.getChildValues().length > 0) {
                    formula.generateSQL(f, f.getChildValues()[0], sb, locale);
                    String quotedWildcard = DefaultSQLDialect.this.quoteStringLiteral(DefaultSQLDialect.this.getStringWildCard());
                    for (int i = 1; i < f.getChildValues().length; ++i) {
                        sb.append(" " + this.getSQL() + " ");
                        StringBuffer tmpsb = new StringBuffer();
                        formula.generateSQL(f, f.getChildValues()[i], tmpsb, locale);
                        sb.append(DefaultSQLDialect.this.generateStringConcat(tmpsb.toString(), quotedWildcard));
                    }
                }
            }
        });
        this.supportedFunctions.put("ENDSWITH", new DefaultSQLFunctionGenerator(0, "LIKE", 2, false){

            @Override
            public void generateFunctionSQL(FormulaTraversalInterface formula, StringBuffer sb, String locale, FormulaFunction f) throws PentahoMetadataException {
                if (f.getChildValues() != null && f.getChildValues().length > 0) {
                    formula.generateSQL(f, f.getChildValues()[0], sb, locale);
                    String quotedWildcard = DefaultSQLDialect.this.quoteStringLiteral(DefaultSQLDialect.this.getStringWildCard());
                    for (int i = 1; i < f.getChildValues().length; ++i) {
                        sb.append(" " + this.getSQL() + " ");
                        StringBuffer tmpsb = new StringBuffer();
                        formula.generateSQL(f, f.getChildValues()[i], tmpsb, locale);
                        sb.append(DefaultSQLDialect.this.generateStringConcat(quotedWildcard, tmpsb.toString()));
                    }
                }
            }
        });
        this.supportedFunctions.put("IN", new DefaultSQLFunctionGenerator(1, "IN", 2){

            @Override
            public void validateFunction(FormulaFunction f) throws PentahoMetadataException {
                if (f.getChildValues() == null || f.getChildValues().length < 2) {
                    throw new PentahoMetadataException(Messages.getErrorString("PMSFormulaContext.ERROR_0002_INVALID_NUMBER_PARAMS", f.getFunctionName(), "" + this.paramCount));
                }
            }

            @Override
            public void generateFunctionSQL(FormulaTraversalInterface formula, StringBuffer sb, String locale, FormulaFunction f) throws PentahoMetadataException {
                formula.generateSQL(f, f.getChildValues()[0], sb, locale);
                sb.append(" IN ( ");
                formula.generateSQL(f, f.getChildValues()[1], sb, locale);
                for (int i = 2; i < f.getChildValues().length; ++i) {
                    sb.append(" , ");
                    formula.generateSQL(f, f.getChildValues()[i], sb, locale);
                }
                sb.append(" ) ");
            }

            @Override
            public boolean isMultiValuedParamAware() {
                return true;
            }
        });
        this.supportedFunctions.put("EQUALS", new DefaultSQLFunctionGenerator(1, "EQUALS", 2){

            @Override
            public void generateFunctionSQL(FormulaTraversalInterface formula, StringBuffer sb, String locale, FormulaFunction f) throws PentahoMetadataException {
                Object val;
                boolean multiVal = false;
                if (f.getChildValues()[1] instanceof ContextLookup) {
                    val = formula.getParameterValue((ContextLookup)f.getChildValues()[1]);
                    boolean bl = multiVal = val instanceof Object[] && ((Object[])val).length > 1;
                }
                if (f.getChildValues()[1] instanceof FormulaFunction && ((FormulaFunction)f.getChildValues()[1]).getFunctionName().equals("DATEVALUE") && f.getChildValues()[1].getChildValues() != null && f.getChildValues()[1].getChildValues()[0] != null && f.getChildValues()[1].getChildValues()[0] instanceof ContextLookup) {
                    val = formula.getParameterValue((ContextLookup)f.getChildValues()[1].getChildValues()[0]);
                    boolean bl = multiVal = multiVal || val instanceof Object[] && ((Object[])val).length > 1;
                }
                if (multiVal) {
                    formula.generateSQL(f, f.getChildValues()[0], sb, locale);
                    sb.append(" IN ( ");
                    formula.generateSQL(f, f.getChildValues()[1], sb, locale);
                    sb.append(" ) ");
                } else {
                    formula.generateSQL(f, f.getChildValues()[0], sb, locale);
                    sb.append(" = ");
                    formula.generateSQL(f, f.getChildValues()[1], sb, locale);
                }
            }

            @Override
            public boolean isMultiValuedParamAware() {
                return true;
            }
        });
        this.supportedFunctions.put("COUNT", new DefaultSQLFunctionGenerator(2){

            @Override
            public String getSQL() {
                return DefaultSQLDialect.this.databaseMeta.getFunctionCount();
            }
        });
        this.supportedFunctions.put("SUM", new DefaultSQLFunctionGenerator(2){

            @Override
            public String getSQL() {
                return DefaultSQLDialect.this.databaseMeta.getFunctionSum();
            }
        });
        this.supportedFunctions.put("AVG", new DefaultSQLFunctionGenerator(2){

            @Override
            public String getSQL() {
                return DefaultSQLDialect.this.databaseMeta.getFunctionAverage();
            }
        });
        this.supportedFunctions.put("MIN", new DefaultSQLFunctionGenerator(2){

            @Override
            public String getSQL() {
                return DefaultSQLDialect.this.databaseMeta.getFunctionMinimum();
            }
        });
        this.supportedFunctions.put("MAX", new DefaultSQLFunctionGenerator(2){

            @Override
            public String getSQL() {
                return DefaultSQLDialect.this.databaseMeta.getFunctionMaximum();
            }
        });
        this.supportedFunctions.put("NOW", new DefaultSQLFunctionGenerator(1, "NOW()", 0){

            @Override
            public void generateFunctionSQL(FormulaTraversalInterface formula, StringBuffer sb, String locale, FormulaFunction f) throws PentahoMetadataException {
                sb.append(this.sql);
            }
        });
        this.supportedFunctions.put("DATE", new DefaultSQLFunctionGenerator(1, "DATE", 3){

            @Override
            public void generateFunctionSQL(FormulaTraversalInterface formula, StringBuffer sb, String locale, FormulaFunction f) throws PentahoMetadataException {
                BigDecimal year = (BigDecimal)((StaticValue)f.getChildValues()[0]).getValue();
                BigDecimal month = (BigDecimal)((StaticValue)f.getChildValues()[1]).getValue();
                BigDecimal day = (BigDecimal)((StaticValue)f.getChildValues()[2]).getValue();
                sb.append(DefaultSQLDialect.this.getDateSQL(year.intValue(), month.intValue(), day.intValue()));
            }

            @Override
            public void validateFunction(FormulaFunction f) throws PentahoMetadataException {
                super.validateFunction(f);
                this.verifyAllStaticNumbers(f);
            }
        });
        this.supportedFunctions.put("DATEMATH", new DefaultSQLFunctionGenerator(1, "DATEMATH", 1){

            @Override
            public void generateFunctionSQL(FormulaTraversalInterface formula, StringBuffer sb, String locale, FormulaFunction f) throws PentahoMetadataException {
                String exp = (String)((StaticValue)f.getChildValues()[0]).getValue();
                try {
                    Calendar cal = DateMath.calculateDate(exp);
                    sb.append(DefaultSQLDialect.this.getDateSQL(cal.get(1), cal.get(2) + 1, cal.get(5)));
                }
                catch (IllegalArgumentException ex) {
                    throw new PentahoMetadataException(Messages.getErrorString("DefaultSQLDialect.ERROR_0002_DATE_MATH_SYNTAX_INVALID", exp), ex);
                }
            }

            @Override
            public void validateFunction(FormulaFunction f) throws PentahoMetadataException {
                super.validateFunction(f);
                this.verifyAllStaticStrings(f);
            }
        });
        this.supportedFunctions.put("DATEVALUE", new DefaultSQLFunctionGenerator(1, "DATE", 1){

            @Override
            public void generateFunctionSQL(FormulaTraversalInterface formula, StringBuffer sb, String locale, FormulaFunction f) throws PentahoMetadataException {
                Object dateValue = null;
                if (f.getChildValues()[0] instanceof StaticValue) {
                    dateValue = ((StaticValue)f.getChildValues()[0]).getValue();
                } else if (f.getChildValues()[0] instanceof ContextLookup) {
                    dateValue = formula.getParameterValue((ContextLookup)f.getChildValues()[0]);
                }
                if (dateValue instanceof Object[]) {
                    formula.generateSQL(f, f.getChildValues()[0], sb, locale);
                } else {
                    int year = 0;
                    int month = 0;
                    int day = 0;
                    int hour = 0;
                    int minute = 0;
                    int second = 0;
                    int milli = 0;
                    boolean useTime = false;
                    if (dateValue instanceof String) {
                        Pattern p = Pattern.compile("(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d) (\\d\\d):(\\d\\d):(\\d\\d)\\.(\\d*)");
                        Matcher m = p.matcher((String)dateValue);
                        if (m.matches()) {
                            useTime = true;
                            hour = Integer.parseInt(m.group(4));
                            minute = Integer.parseInt(m.group(5));
                            second = Integer.parseInt(m.group(6));
                            milli = Integer.parseInt(m.group(7));
                        } else {
                            p = Pattern.compile("(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)");
                            m = p.matcher((String)dateValue);
                            if (!m.matches()) {
                                throw new PentahoMetadataException(Messages.getErrorString("DefaultSQLDialect.ERROR_0001_DATE_STRING_SYNTAX_INVALID", (String)dateValue));
                            }
                        }
                        year = Integer.parseInt(m.group(1));
                        month = Integer.parseInt(m.group(2));
                        day = Integer.parseInt(m.group(3));
                    } else if (dateValue instanceof Timestamp) {
                        useTime = true;
                        Calendar c = Calendar.getInstance();
                        c.setTime((Timestamp)dateValue);
                        year = c.get(1);
                        month = c.get(2) + 1;
                        day = c.get(5);
                        hour = c.get(11);
                        minute = c.get(12);
                        second = c.get(13);
                        milli = c.get(14);
                    } else if (dateValue instanceof Date) {
                        Calendar c = Calendar.getInstance();
                        c.setTime((Date)dateValue);
                        year = c.get(1);
                        month = c.get(2) + 1;
                        day = c.get(5);
                    } else {
                        String dateValueType = dateValue == null ? "null" : dateValue.getClass().getName();
                        throw new PentahoMetadataException(Messages.getErrorString("DefaultSQLDialect.ERROR_0003_DATE_PARAMETER_UNRECOGNIZED", dateValueType));
                    }
                    if (useTime) {
                        sb.append(DefaultSQLDialect.this.getDateSQL(year, month, day, hour, minute, second, milli));
                    } else {
                        sb.append(DefaultSQLDialect.this.getDateSQL(year, month, day));
                    }
                }
            }

            @Override
            public void validateFunction(FormulaFunction f) throws PentahoMetadataException {
                super.validateFunction(f);
                this.verifyAllStaticStrings(f);
            }
        });
        this.supportedFunctions.put("CASE", new DefaultSQLFunctionGenerator(1, "CASE"){

            @Override
            public void validateFunction(FormulaFunction f) throws PentahoMetadataException {
                if (f.getChildValues() == null || f.getChildValues().length < 2) {
                    throw new PentahoMetadataException(Messages.getErrorString("PMSFormulaContext.ERROR_0002_INVALID_NUMBER_PARAMS", f.getFunctionName(), "2"));
                }
            }

            @Override
            public void generateFunctionSQL(FormulaTraversalInterface formula, StringBuffer sb, String locale, FormulaFunction f) throws PentahoMetadataException {
                sb.append(" CASE ");
                for (int i = 1; i < f.getChildValues().length; i += 2) {
                    sb.append(" WHEN ");
                    formula.generateSQL(f, f.getChildValues()[i - 1], sb, locale);
                    sb.append(" THEN ");
                    formula.generateSQL(f, f.getChildValues()[i], sb, locale);
                }
                if (f.getChildValues().length % 2 == 1) {
                    sb.append(" ELSE ");
                    formula.generateSQL(f, f.getChildValues()[f.getChildValues().length - 1], sb, locale);
                }
                sb.append(" END ");
            }
        });
        this.supportedFunctions.put("COALESCE", new DefaultSQLFunctionGenerator(1, "COALESCE"){

            @Override
            public void validateFunction(FormulaFunction f) throws PentahoMetadataException {
                if (f.getChildValues() == null || f.getChildValues().length < 1) {
                    throw new PentahoMetadataException(Messages.getErrorString("PMSFormulaContext.ERROR_0002_INVALID_NUMBER_PARAMS", f.getFunctionName(), "1"));
                }
            }
        });
        this.supportedFunctions.put("TRUE", new DefaultSQLFunctionGenerator(1, "TRUE()", 0){

            @Override
            public void generateFunctionSQL(FormulaTraversalInterface formula, StringBuffer sb, String locale, FormulaFunction f) throws PentahoMetadataException {
                sb.append("TRUE");
            }
        });
        this.supportedFunctions.put("FALSE", new DefaultSQLFunctionGenerator(1, "FALSE()", 0){

            @Override
            public void generateFunctionSQL(FormulaTraversalInterface formula, StringBuffer sb, String locale, FormulaFunction f) throws PentahoMetadataException {
                sb.append("FALSE");
            }
        });
    }

    protected String displayAsTwoOrMoreDigits(int number) {
        if (number >= 0 && number < 10) {
            return "0" + number;
        }
        return "" + number;
    }

    @Override
    public String getDateSQL(int year, int month, int day) {
        return this.quoteStringLiteral(year + "-" + this.displayAsTwoOrMoreDigits(month) + "-" + this.displayAsTwoOrMoreDigits(day));
    }

    @Override
    public String getDateSQL(int year, int month, int day, int hour, int minute, int second, int milli) {
        return this.quoteStringLiteral(year + "-" + this.displayAsTwoOrMoreDigits(month) + "-" + this.displayAsTwoOrMoreDigits(day) + " " + this.displayAsTwoOrMoreDigits(hour) + ":" + this.displayAsTwoOrMoreDigits(minute) + ":" + this.displayAsTwoOrMoreDigits(second) + "." + milli);
    }

    @Override
    public String getDatabaseType() {
        return this.databaseType;
    }

    @Override
    public boolean isSupportedFunction(String functionName) {
        return this.supportedFunctions.containsKey(functionName);
    }

    @Override
    public boolean isAggregateFunction(String functionName) {
        SQLFunctionGeneratorInterface gen = this.getFunctionSQLGenerator(functionName);
        if (gen != null) {
            return gen.getType() == 2;
        }
        return false;
    }

    @Override
    public boolean isSupportedInfixOperator(String operator) {
        return this.supportedInfixOperators.containsKey(operator);
    }

    @Override
    public SQLFunctionGeneratorInterface getFunctionSQLGenerator(String functionName) {
        return this.supportedFunctions.get(functionName);
    }

    @Override
    public SQLOperatorGeneratorInterface getInfixOperatorSQLGenerator(String operatorName) {
        return this.supportedInfixOperators.get(operatorName);
    }

    @Override
    public String quoteStringLiteral(Object str) {
        String strval = null;
        if (str != null) {
            strval = str.toString();
            strval = strval.replaceAll("'", "''");
        }
        if (!LocaleHelper.isAscii(strval) && this.supportsNLSLiteral()) {
            return "N'" + strval + "'";
        }
        return "'" + strval + "'";
    }

    @Override
    public boolean supportsNLSLiteral() {
        return false;
    }

    protected void generateSelect(SQLQueryModel query, StringBuilder sql) {
        sql.append("SELECT ");
        this.generateSelectPredicate(query, sql);
        sql.append(Const.CR);
        boolean first = true;
        for (SQLQueryModel.SQLSelection selection : query.getSelections()) {
            if (first) {
                first = false;
                sql.append("          ");
            } else {
                sql.append("         ,");
            }
            sql.append(selection.getFormula());
            if (selection.getAlias() != null) {
                sql.append(" AS ");
                sql.append(selection.getAlias());
            }
            sql.append(Const.CR);
        }
    }

    protected void generateSelectPredicate(SQLQueryModel query, StringBuilder sql) {
        this.generateTopAfterDistinct(query, sql, TOP_KEYWORD);
    }

    protected void generateDistinct(SQLQueryModel query, StringBuilder sql) {
        if (query.getDistinct()) {
            sql.append("DISTINCT ");
        }
    }

    protected void generateTopBeforeDistinct(SQLQueryModel query, StringBuilder sql, String topKeyword) {
        this.generateTop(query, sql, topKeyword);
        this.generateDistinct(query, sql);
    }

    protected void generateTopAfterDistinct(SQLQueryModel query, StringBuilder sql, String topKeyword) {
        this.generateDistinct(query, sql);
        this.generateTop(query, sql, topKeyword);
    }

    protected void generateTop(SQLQueryModel query, StringBuilder sql, String topKeyword) {
        if (query.getLimit() >= 0) {
            sql.append(" ");
            sql.append(topKeyword);
            sql.append(" ");
            sql.append(query.getLimit());
            sql.append(" ");
        }
    }

    protected void generateFrom(SQLQueryModel query, StringBuilder sql) {
        sql.append("FROM ").append(Const.CR);
        boolean first = true;
        for (SQLQueryModel.SQLTable table : query.getTables()) {
            if (first) {
                first = false;
                sql.append("          ");
            } else {
                sql.append("         ,");
            }
            sql.append(table.getTableName());
            if (table.getAlias() != null) {
                sql.append(" ");
                sql.append(table.getAlias());
            }
            sql.append(Const.CR);
        }
    }

    protected void generateWhere(SQLQueryModel query, StringBuilder sql, List<SQLQueryModel.SQLWhereFormula> usedSQLWhereFormula) {
        boolean addSecurityConstraint = query.getSecurityConstraint() != null && !query.getSecurityConstraint().isContainingAggregate();
        ArrayList<SQLQueryModel.SQLWhereFormula> remainingFormulas = new ArrayList<SQLQueryModel.SQLWhereFormula>();
        if (query.getWhereFormulas().size() > 0 || addSecurityConstraint) {
            boolean whereFormulasRemaining;
            boolean first = true;
            for (SQLQueryModel.SQLWhereFormula whereFormula : query.getWhereFormulas()) {
                if (usedSQLWhereFormula.contains(whereFormula)) continue;
                remainingFormulas.add(whereFormula);
            }
            boolean bl = whereFormulasRemaining = remainingFormulas.size() > 0;
            if (whereFormulasRemaining || addSecurityConstraint) {
                if (!this.containsWhereCondition(query, sql, usedSQLWhereFormula)) {
                    sql.append("WHERE ").append(Const.CR);
                } else {
                    sql.append("      AND ").append(Const.CR);
                }
            }
            if (addSecurityConstraint) {
                sql.append("        (").append(Const.CR);
                sql.append("          ");
                sql.append(query.getSecurityConstraint().getFormula()).append(Const.CR);
                if (whereFormulasRemaining) {
                    sql.append("        ) AND ").append(Const.CR);
                } else {
                    sql.append("        )").append(Const.CR);
                }
            }
            if (whereFormulasRemaining) {
                sql.append("        (").append(Const.CR);
                for (SQLQueryModel.SQLWhereFormula whereFormula : remainingFormulas) {
                    if (first) {
                        if (whereFormula.getOperator().endsWith("NOT")) {
                            sql.append("      NOT (");
                        } else {
                            sql.append("          (");
                        }
                        first = false;
                    } else {
                        sql.append("      ");
                        sql.append(whereFormula.getOperator());
                        sql.append(" (");
                    }
                    sql.append(Const.CR);
                    sql.append("             ");
                    sql.append(whereFormula.getFormula());
                    sql.append(Const.CR);
                    sql.append("          )").append(Const.CR);
                }
                sql.append("        )").append(Const.CR);
            }
        }
    }

    protected boolean containsWhereCondition(SQLQueryModel query, StringBuilder sql, List<SQLQueryModel.SQLWhereFormula> usedSQLWhereFormula) {
        return query.getJoins().size() != 0 && !query.containsOuterJoins();
    }

    protected void generateJoins(SQLQueryModel query, StringBuilder sql) {
        if (query.getJoins().size() > 0) {
            boolean first = true;
            sql.append("WHERE ").append(Const.CR);
            ArrayList<SQLJoin> sortedJoins = new ArrayList<SQLJoin>(query.getJoins());
            Collections.sort(sortedJoins);
            for (SQLJoin join : sortedJoins) {
                if (first) {
                    first = false;
                    sql.append("          ( ");
                } else {
                    sql.append("      AND ( ");
                }
                sql.append(join.getSqlWhereFormula().getFormula());
                sql.append(" )").append(Const.CR);
            }
        }
    }

    protected void generateGroupBy(SQLQueryModel query, StringBuilder sql) {
        if (query.getGroupBys().size() > 0) {
            sql.append("GROUP BY ").append(Const.CR);
            boolean first = true;
            for (SQLQueryModel.SQLSelection groupby : query.getGroupBys()) {
                if (first) {
                    first = false;
                    sql.append("          ");
                } else {
                    sql.append("         ,");
                }
                if (groupby.getAlias() != null) {
                    sql.append(groupby.getAlias());
                } else {
                    sql.append(groupby.getFormula());
                }
                sql.append(Const.CR);
            }
        }
    }

    protected void generateHaving(SQLQueryModel query, StringBuilder sql) {
        boolean addSecurityConstraint;
        boolean bl = addSecurityConstraint = query.getSecurityConstraint() != null && query.getSecurityConstraint().isContainingAggregate();
        if (query.getHavings().size() > 0 || addSecurityConstraint) {
            sql.append("HAVING ").append(Const.CR);
            if (addSecurityConstraint) {
                sql.append("        (").append(Const.CR);
                sql.append("          ");
                sql.append(query.getSecurityConstraint().getFormula()).append(Const.CR);
                if (query.getHavings().size() > 0) {
                    sql.append("        ) AND (").append(Const.CR);
                }
            }
            boolean first = true;
            for (SQLQueryModel.SQLWhereFormula havingFormula : query.getHavings()) {
                if (first) {
                    first = false;
                    if (havingFormula.getOperator().endsWith("NOT")) {
                        sql.append("      NOT (");
                    } else {
                        sql.append("          (");
                    }
                } else {
                    sql.append("      ");
                    sql.append(havingFormula.getOperator());
                    sql.append(" (");
                }
                sql.append(Const.CR);
                sql.append("             ");
                sql.append(havingFormula.getFormula());
                sql.append(Const.CR);
                sql.append("          )").append(Const.CR);
            }
            if (addSecurityConstraint) {
                sql.append("        )").append(Const.CR);
            }
        }
    }

    protected String getStringConcatOperator() {
        return this.concatOperator;
    }

    protected String generateStringConcat(String ... vals) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < vals.length; ++i) {
            if (i != 0) {
                sb.append(" ").append(this.getStringConcatOperator()).append(" ");
            }
            sb.append(vals[i]);
        }
        return sb.toString();
    }

    protected void generateOrderBy(SQLQueryModel query, StringBuilder sql) {
        if (query.getOrderBys().size() > 0) {
            sql.append("ORDER BY ").append(Const.CR);
            boolean first = true;
            for (SQLQueryModel.SQLOrderBy orderby : query.getOrderBys()) {
                if (first) {
                    first = false;
                    sql.append("          ");
                } else {
                    sql.append("         ,");
                }
                if (orderby.getSelection().getAlias() != null) {
                    sql.append(orderby.getSelection().getAlias());
                } else {
                    sql.append(orderby.getSelection().getFormula());
                }
                if (orderby.getOrder() != null) {
                    sql.append(" ");
                    switch (orderby.getOrder()) {
                        case ASCENDING: {
                            sql.append("ASC");
                            break;
                        }
                        case DESCENDING: {
                            sql.append("DESC");
                            break;
                        }
                        default: {
                            throw new RuntimeException("unsupported order type: " + (Object)((Object)orderby.getOrder()));
                        }
                    }
                }
                sql.append(Const.CR);
            }
        }
    }

    protected void generatePostOrderBy(SQLQueryModel query, StringBuilder sql) {
    }

    protected void generateLimit(SQLQueryModel query, StringBuilder sql) {
        if (query.getLimit() >= 0) {
            sql.append(this.databaseMeta.getLimitClause(query.getLimit()));
        }
    }

    protected List<SQLQueryModel.SQLWhereFormula> generateOuterJoin(SQLQueryModel query, StringBuilder sql) {
        ArrayList<SQLQueryModel.SQLWhereFormula> usedSQLWhereFormula = new ArrayList<SQLQueryModel.SQLWhereFormula>();
        if (query.getJoins().size() == 0) {
            return usedSQLWhereFormula;
        }
        ArrayList<SQLJoin> sortedJoins = new ArrayList<SQLJoin>(query.getJoins());
        Collections.sort(sortedJoins);
        String joinClause = this.getJoinClause(query, sortedJoins, 0, new ArrayList<String>(), usedSQLWhereFormula);
        sql.append(Const.CR).append("FROM ").append(joinClause).append(Const.CR);
        return usedSQLWhereFormula;
    }

    private String getJoinClause(SQLQueryModel query, List<SQLJoin> sortedJoins, int index, List<String> usedTables, List<SQLQueryModel.SQLWhereFormula> usedSQLWhereFormula) {
        StringBuilder clause = new StringBuilder();
        String indent = Const.rightPad(" ", index + 1 + 3);
        SQLJoin join = sortedJoins.get(index);
        String leftTableNameAndAlias = join.getLeftTablename();
        String leftTableNameOrAlias = join.getLeftTablename();
        if (!Const.isEmpty(join.getLeftTableAlias())) {
            leftTableNameAndAlias = leftTableNameAndAlias + " " + join.getLeftTableAlias();
            leftTableNameOrAlias = join.getLeftTableAlias();
        }
        String rightTableNameAndAlias = join.getRightTablename();
        String rightTableNameOrAlias = join.getRightTablename();
        if (!Const.isEmpty(join.getRightTableAlias())) {
            rightTableNameAndAlias = rightTableNameAndAlias + " " + join.getRightTableAlias();
            rightTableNameOrAlias = join.getRightTableAlias();
        }
        JoinType joinType = join.getJoinType();
        String rightClause = index < sortedJoins.size() - 1 ? this.getJoinClause(query, sortedJoins, index + 1, usedTables, usedSQLWhereFormula) : rightTableNameAndAlias;
        if (usedTables.contains(leftTableNameOrAlias)) {
            leftTableNameAndAlias = join.getRightTablename();
            leftTableNameOrAlias = join.getRightTablename();
            if (!Const.isEmpty(join.getRightTableAlias())) {
                leftTableNameAndAlias = leftTableNameAndAlias + " " + join.getRightTableAlias();
                leftTableNameOrAlias = join.getRightTableAlias();
            }
            rightTableNameAndAlias = join.getLeftTablename();
            rightTableNameOrAlias = join.getLeftTablename();
            if (!Const.isEmpty(join.getLeftTableAlias())) {
                rightTableNameAndAlias = rightTableNameAndAlias + " " + join.getLeftTableAlias();
                rightTableNameOrAlias = join.getLeftTableAlias();
            }
            if (join.getJoinType().equals((Object)JoinType.LEFT_OUTER_JOIN)) {
                joinType = JoinType.RIGHT_OUTER_JOIN;
            } else if (join.getJoinType().equals((Object)JoinType.RIGHT_OUTER_JOIN)) {
                joinType = JoinType.LEFT_OUTER_JOIN;
            }
        }
        clause.append(leftTableNameAndAlias);
        usedTables.add(leftTableNameOrAlias);
        switch (joinType) {
            case INNER_JOIN: {
                clause.append(" JOIN ");
                break;
            }
            case LEFT_OUTER_JOIN: {
                clause.append(" LEFT OUTER JOIN ");
                break;
            }
            case RIGHT_OUTER_JOIN: {
                clause.append(" RIGHT OUTER JOIN ");
                break;
            }
            case FULL_OUTER_JOIN: {
                clause.append(" FULL OUTER JOIN ");
            }
        }
        if (index < sortedJoins.size() - 1) {
            clause.append(Const.CR).append(indent).append(" ( ").append(Const.CR).append(indent).append("  ");
            clause.append(rightClause);
            clause.append(indent).append(" ) ");
        } else {
            clause.append(rightTableNameAndAlias);
            usedTables.add(rightTableNameOrAlias);
        }
        SQLQueryModel.SQLWhereFormula joinFormula = join.getSqlWhereFormula();
        clause.append(Const.CR).append(indent).append(" ON ( ");
        clause.append(joinFormula.getFormula());
        if (!joinType.equals((Object)JoinType.FULL_OUTER_JOIN) && !query.getDelayOuterJoinConditions()) {
            for (SQLQueryModel.SQLWhereFormula sqlWhereFormula : query.getWhereFormulas()) {
                if (usedSQLWhereFormula.contains(sqlWhereFormula) || sqlWhereFormula.isContainingAggregate()) continue;
                boolean allInvolvedAvailableHere = true;
                for (String involvedTable : sqlWhereFormula.involvedTables) {
                    if (involvedTable.equalsIgnoreCase(leftTableNameOrAlias) || involvedTable.equalsIgnoreCase(rightTableNameOrAlias)) continue;
                    allInvolvedAvailableHere = false;
                }
                if (joinType.equals((Object)JoinType.LEFT_OUTER_JOIN) && Const.indexOfString(leftTableNameOrAlias, sqlWhereFormula.involvedTables) >= 0) {
                    allInvolvedAvailableHere = false;
                }
                if (joinType.equals((Object)JoinType.RIGHT_OUTER_JOIN) && Const.indexOfString(rightTableNameOrAlias, sqlWhereFormula.involvedTables) >= 0) {
                    allInvolvedAvailableHere = false;
                }
                if (!allInvolvedAvailableHere) continue;
                clause.append(" AND ( ").append(sqlWhereFormula.getFormula()).append(" ) ");
                usedSQLWhereFormula.add(sqlWhereFormula);
            }
        }
        clause.append(" )").append(Const.CR);
        return clause.toString();
    }

    public String getStringWildCard() {
        return "%";
    }

    public String getCharWildCard() {
        return "_";
    }

    @Override
    public String generateSelectStatement(SQLQueryModel query) {
        StringBuilder sql = new StringBuilder();
        this.generateSelect(query, sql);
        ArrayList<SQLQueryModel.SQLWhereFormula> usedSQLWhereFormula = new ArrayList();
        if (query.containsOuterJoins()) {
            usedSQLWhereFormula = this.generateOuterJoin(query, sql);
        } else {
            this.generateFrom(query, sql);
            this.generateJoins(query, sql);
        }
        this.generateWhere(query, sql, usedSQLWhereFormula);
        this.generateGroupBy(query, sql);
        this.generateHaving(query, sql);
        this.generateOrderBy(query, sql);
        this.generatePostOrderBy(query, sql);
        return sql.toString();
    }

    @Override
    public int getMaxTableNameLength() {
        return Integer.MAX_VALUE;
    }
}

