/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.teradatabulkloader;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ProvidesDatabaseConnectionInformation;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.teradatabulkloader.TeraDataBulkLoader;
import org.pentaho.di.trans.steps.teradatabulkloader.TeraDataBulkLoaderData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="TeraDataBulkLoader", image="BLKTDTPT.svg", name="Teradata TPT Bulk Loader", description="Teradata TPT bulkloader, using tbuild command", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.Bulk", documentationUrl="http://wiki.pentaho.com/display/EAI/Teradata+TPT+Insert+Upsert+Bulk+Loader")
public class TeraDataBulkLoaderMeta
extends BaseStepMeta
implements StepMetaInterface,
ProvidesDatabaseConnectionInformation {
    private static Class<?> PKG = TeraDataBulkLoaderMeta.class;
    public static final int FIELD_FORMAT_TYPE_OK = 0;
    public static final int FIELD_FORMAT_TYPE_DATE = 1;
    public static final int FIELD_FORMAT_TYPE_TIMESTAMP = 2;
    public static final int FIELD_FORMAT_TYPE_NUMBER = 3;
    public static final int FIELD_FORMAT_TYPE_STRING_ESCAPE = 4;
    private static final String[] fieldFormatTypeCodes = new String[]{"OK", "DATE", "TIMESTAMP", "NUMBER", "STRING_ESC"};
    private static final String[] fieldFormatTypeDescriptions = new String[]{BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.FieldFormatType.OK.Description", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.FieldFormatType.Date.Description", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.FieldFormatType.Timestamp.Description", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.FieldFormatType.Number.Description", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.FieldFormatType.StringEscape.Description", (String[])new String[0])};
    public static final String CONNECTION_FIELD = "connection";
    public static final String GENERATE_SCRIPT_FIELD = "generateScript";
    public static final String TBUILD_PATH_FIELD = "tbuildPath";
    public static final String TBUILD_LIB_PATH_FIELD = "tbuildLibPath";
    public static final String LIB_PATH_FIELD = "libPath";
    public static final String TDICU_LIB_PATH_FIELD = "tdicuLibPath";
    public static final String COP_LIB_PATH_FIELD = "copLibPath";
    public static final String TWB_ROOT_FIELD = "twbRoot";
    public static final String INSTALL_PATH_FIELD = "installPath";
    public static final String JOB_NAME_FIELD = "jobName";
    public static final String SCHEMA_FIELD = "schema";
    public static final String TABLE_FIELD = "table";
    public static final String LOG_TABLE_FIELD = "logTable";
    public static final String WORK_TABLE_FIELD = "workTable";
    public static final String ERROR_TABLE_FIELD = "errorTable";
    public static final String ERROR_TABLE_2_FIELD = "errorTable2";
    public static final String DROP_LOG_TABLE_FIELD = "dropLogTable";
    public static final String DROP_WORK_TABLE_FIELD = "dropWorkTable";
    public static final String DROP_ERROR_TABLE_FIELD = "dropErrorTable";
    public static final String DROP_ERROR_TABLE_2_FIELD = "dropErrorTable2";
    public static final String IGNORE_DUP_UPDATE_FIELD = "ignoreDupUpdate";
    public static final String INSERT_MISSING_UPDATE_FIELD = "insertMissingUpdate";
    public static final String IGNORE_MISSING_UPDATE_FIELD = "ignoreMissingUpdate";
    public static final String ACCESS_LOG_FILE_FIELD = "accessLogFile";
    public static final String UPDATE_LOG_FILE_FIELD = "updateLogFile";
    public static final String FIFO_FILE_NAME_FIELD = "fifoFileName";
    public static final String RANDOMIZE_FIFO_FILE_NAME_FIELD = "randomizeFifoFilename";
    public static final String SCRIPT_FILE_NAME_FIELD = "scriptFileName";
    public static final String ACTION_TYPE_FIELD = "actionType";
    public static final String KEY_STREAM_FIELD = "keyStream";
    public static final String KEY_LOOKUP_FIELD = "keyLookup";
    public static final String KEY_CONDITION_FIELD = "keyCondition";
    public static final String FIELD_TABLE_FIELD = "fieldTable";
    public static final String FIELD_STREAM_FIELD = "fieldStream";
    public static final String FIELD_UPDATE_FIELD = "fieldUpdate";
    public static final String EXISTING_SCRIPT_FILE_FIELD = "existingScriptFile";
    public static final String SUBSTITUTE_SCRIPT_FILE_FIELD = "substituteScriptFile";
    public static final String EXISTING_VARIABLE_FILE_FIELD = "existingVariableFile";
    public static final String SUBSTITUTE_VARIABLE_FILE_FIELD = "substituteVariableFile";
    private TeraDataBulkLoader myStep;
    private DatabaseMeta databaseMeta;
    private String tbuildPath = null;
    private String jobName = null;
    private boolean generateScript = false;
    private String tbuildLibPath = null;
    private String libPath = null;
    private String copLibPath = null;
    private String tdicuLibPath = null;
    private String installPath = BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.TbuildClientRoot", (String[])new String[0]);
    private String twbRoot = null;
    private String existingScriptFile = null;
    private String existingVariableFile = null;
    private boolean substituteScriptFile = false;
    private boolean substituteVariableFile = false;
    private String fifoFileName = null;
    private boolean randomizeFifoFilename = false;
    private String scriptFileName = null;
    private String schemaName = null;
    private String tableName = null;
    private String logTable = null;
    private String workTable = null;
    private String errorTable = null;
    private String errorTable2 = null;
    private boolean dropLogTable = false;
    private boolean dropWorkTable = false;
    private boolean dropErrorTable = false;
    private boolean dropErrorTable2 = false;
    private boolean ignoreDupUpdate = false;
    private boolean insertMissingUpdate = false;
    private boolean ignoreMissingUpdate = false;
    private String accessLogFile = null;
    private String updateLogFile = null;
    private int actionType = 0;
    private String[] fieldTable = null;
    private String[] fieldStream = null;
    private Boolean[] fieldUpdate = null;
    private String[] keyStream = null;
    private String[] keyLookup = null;
    private String[] keyCondition = null;

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public TeraDataBulkLoader getStep() {
        return this.myStep;
    }

    public boolean setGenerateScript(boolean val) {
        this.generateScript = val;
        return this.generateScript;
    }

    public boolean getGenerateScript() {
        return this.generateScript;
    }

    public boolean setSubstituteControlFile(boolean val) {
        this.substituteScriptFile = val;
        return this.substituteScriptFile;
    }

    public boolean getSubstituteControlFile() {
        return this.substituteScriptFile;
    }

    public String setExistingScriptFile(String val) {
        this.existingScriptFile = val;
        return this.existingScriptFile;
    }

    public String getExistingScriptFile() {
        return this.existingScriptFile;
    }

    public String setJobName(String val) {
        this.jobName = val;
        return this.jobName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getVariableFile() {
        return this.existingVariableFile;
    }

    public String setVariableFile(String val) {
        this.existingVariableFile = val;
        return this.existingVariableFile;
    }

    public boolean getDropLogTable() {
        return this.dropLogTable;
    }

    public boolean setDropLogTable(boolean val) {
        this.dropLogTable = val;
        return this.dropLogTable;
    }

    public boolean getDropWorkTable() {
        return this.dropWorkTable;
    }

    public boolean setDropWorkTable(boolean val) {
        this.dropWorkTable = val;
        return this.dropWorkTable;
    }

    public boolean getDropErrorTable() {
        return this.dropErrorTable;
    }

    public boolean setDropErrorTable(boolean val) {
        this.dropErrorTable = val;
        return this.dropErrorTable;
    }

    public boolean getDropErrorTable2() {
        return this.dropErrorTable2;
    }

    public boolean setDropErrorTable2(boolean val) {
        this.dropErrorTable2 = val;
        return this.dropErrorTable2;
    }

    public boolean getIgnoreDupUpdate() {
        return this.ignoreDupUpdate;
    }

    public boolean setIgnoreDupUpdate(boolean val) {
        this.ignoreDupUpdate = val;
        return this.ignoreDupUpdate;
    }

    public boolean getInsertMissingUpdate() {
        return this.insertMissingUpdate;
    }

    public boolean setInsertMissingUpdate(boolean val) {
        this.insertMissingUpdate = val;
        return this.insertMissingUpdate;
    }

    public boolean getIgnoreMissingUpdate() {
        return this.ignoreMissingUpdate;
    }

    public boolean setIgnoreMissingUpdate(boolean val) {
        this.ignoreMissingUpdate = val;
        return this.ignoreMissingUpdate;
    }

    public boolean getSubstituteVariableFile() {
        return this.substituteVariableFile;
    }

    public boolean setSubstituteVariableFile(boolean val) {
        this.substituteVariableFile = val;
        return this.substituteVariableFile;
    }

    public String setTbuildPath(String val) {
        this.tbuildPath = val;
        return this.tbuildPath;
    }

    public String getTdInstallPath() {
        return this.installPath;
    }

    public String getTbuildPath() {
        return Const.isEmpty((String)this.tbuildPath) ? this.getTwbRoot() + "/bin/tbuild" : this.tbuildPath;
    }

    public String getTbuildLibPath() {
        return Const.isEmpty((String)this.tbuildLibPath) ? this.getTwbRoot() + "/lib" : this.tbuildLibPath;
    }

    public String getLibPath() {
        return Const.isEmpty((String)this.libPath) ? this.installPath + "/lib" : this.libPath;
    }

    public String getCopLibPath() {
        return Const.isEmpty((String)this.copLibPath) ? this.installPath + "/lib" : this.copLibPath;
    }

    public String getTdicuLibPath() {
        return Const.isEmpty((String)this.tdicuLibPath) ? this.installPath + "/tdicu/lib" : this.tdicuLibPath;
    }

    public String getTwbRoot() {
        return Const.isEmpty((String)this.twbRoot) ? this.installPath + "/tbuild" : this.twbRoot;
    }

    public String setTbuildLibPath(String s) {
        this.tbuildLibPath = s;
        return this.tbuildLibPath;
    }

    public String setLibPath(String s) {
        this.libPath = s;
        return this.libPath;
    }

    public String setCopLibPath(String s) {
        this.copLibPath = s;
        return this.copLibPath;
    }

    public String setTdicuLibPath(String s) {
        this.tdicuLibPath = s;
        return this.tdicuLibPath;
    }

    public String setTdInstallPath(String s) {
        this.installPath = s;
        return this.installPath;
    }

    public String setTwbRoot(String s) {
        this.twbRoot = s;
        return this.twbRoot;
    }

    public String setFifoFileName(String val) {
        this.fifoFileName = val;
        return this.fifoFileName;
    }

    public String getFifoFileName() {
        return this.fifoFileName;
    }

    public boolean isRandomizeFifoFilename() {
        return this.randomizeFifoFilename;
    }

    public void setRandomizeFifoFilename(boolean randomizeFifoFilename) {
        this.randomizeFifoFilename = randomizeFifoFilename;
    }

    public String setScriptFileName(String val) {
        this.scriptFileName = val;
        return this.scriptFileName;
    }

    public String getScriptFileName() {
        return this.scriptFileName;
    }

    public String getDbName() {
        return this.databaseMeta.getDatabaseInterface().getDatabaseName();
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String setSchemaName(String val) {
        this.schemaName = val;
        return this.schemaName;
    }

    public String getLogTable() {
        return this.logTable;
    }

    public String setLogTable(String val) {
        this.logTable = val;
        return this.logTable;
    }

    public String getWorkTable() {
        return this.workTable;
    }

    public String setWorkTable(String val) {
        this.workTable = val;
        return this.workTable;
    }

    public String getErrorTable() {
        return this.errorTable;
    }

    public String setErrorTable(String val) {
        this.errorTable = val;
        return this.errorTable;
    }

    public String getErrorTable2() {
        return this.errorTable2;
    }

    public String setErrorTable2(String val) {
        this.errorTable2 = val;
        return this.errorTable2;
    }

    public String getAccessLogFile() {
        return this.accessLogFile;
    }

    public String setAccessLogFile(String val) {
        this.accessLogFile = val;
        return this.accessLogFile;
    }

    public String getUpdateLogFile() {
        return this.updateLogFile;
    }

    public String setUpdateLogFile(String val) {
        this.updateLogFile = val;
        return this.updateLogFile;
    }

    public int getActionType() {
        return this.actionType;
    }

    public int setActionType(int val) {
        this.actionType = val;
        return this.actionType;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String[] getFieldTable() {
        return this.fieldTable;
    }

    public void setFieldTable(String[] fieldTable) {
        this.fieldTable = fieldTable;
    }

    public String[] getFieldStream() {
        return this.fieldStream;
    }

    public void setFieldStream(String[] fieldStream) {
        this.fieldStream = fieldStream;
    }

    public Boolean[] getFieldUpdate() {
        return this.fieldUpdate;
    }

    public void setFieldUpdate(Boolean[] fieldUpdate) {
        this.fieldUpdate = fieldUpdate;
    }

    public String[] getKeyStream() {
        return this.keyStream;
    }

    public void setKeyStream(String[] fieldStream) {
        this.keyStream = fieldStream;
    }

    public String[] getKeyLookup() {
        return this.keyLookup;
    }

    public void setKeyLookup(String[] fieldStream) {
        this.keyLookup = fieldStream;
    }

    public String[] getKeyCondition() {
        return this.keyCondition;
    }

    public void setKeyCondition(String[] fieldStream) {
        this.keyCondition = fieldStream;
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    public void allocate(int nrkeys, int nrvalues) {
        this.keyStream = new String[nrkeys];
        this.keyLookup = new String[nrkeys];
        this.keyCondition = new String[nrkeys];
        this.fieldTable = new String[nrvalues];
        this.fieldStream = new String[nrvalues];
        this.fieldUpdate = new Boolean[nrvalues];
    }

    public Object clone() {
        int i;
        TeraDataBulkLoaderMeta retval = (TeraDataBulkLoaderMeta)((Object)super.clone());
        int nrvalues = this.fieldTable.length;
        int nrkeys = this.keyStream.length;
        retval.allocate(nrkeys, nrvalues);
        for (i = 0; i < nrkeys; ++i) {
            retval.keyStream[i] = this.keyStream[i];
            retval.keyLookup[i] = this.keyLookup[i];
            retval.keyCondition[i] = this.keyCondition[i];
        }
        for (i = 0; i < nrvalues; ++i) {
            retval.fieldTable[i] = this.fieldTable[i];
            retval.fieldStream[i] = this.fieldStream[i];
            retval.fieldUpdate[i] = this.fieldUpdate[i];
        }
        return retval;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            int i;
            this.tbuildPath = XMLHandler.getTagValue((Node)stepnode, (String)TBUILD_PATH_FIELD);
            this.tbuildLibPath = XMLHandler.getTagValue((Node)stepnode, (String)TBUILD_LIB_PATH_FIELD);
            this.libPath = XMLHandler.getTagValue((Node)stepnode, (String)LIB_PATH_FIELD);
            this.copLibPath = XMLHandler.getTagValue((Node)stepnode, (String)COP_LIB_PATH_FIELD);
            this.tdicuLibPath = XMLHandler.getTagValue((Node)stepnode, (String)TDICU_LIB_PATH_FIELD);
            this.installPath = XMLHandler.getTagValue((Node)stepnode, (String)INSTALL_PATH_FIELD);
            this.twbRoot = XMLHandler.getTagValue((Node)stepnode, (String)TWB_ROOT_FIELD);
            this.jobName = XMLHandler.getTagValue((Node)stepnode, (String)JOB_NAME_FIELD);
            String con = XMLHandler.getTagValue((Node)stepnode, (String)CONNECTION_FIELD);
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)con);
            this.generateScript = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)GENERATE_SCRIPT_FIELD));
            this.schemaName = XMLHandler.getTagValue((Node)stepnode, (String)SCHEMA_FIELD);
            this.tableName = XMLHandler.getTagValue((Node)stepnode, (String)TABLE_FIELD);
            this.logTable = XMLHandler.getTagValue((Node)stepnode, (String)LOG_TABLE_FIELD);
            this.workTable = XMLHandler.getTagValue((Node)stepnode, (String)WORK_TABLE_FIELD);
            this.errorTable = XMLHandler.getTagValue((Node)stepnode, (String)ERROR_TABLE_FIELD);
            this.errorTable2 = XMLHandler.getTagValue((Node)stepnode, (String)ERROR_TABLE_2_FIELD);
            this.dropLogTable = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)DROP_LOG_TABLE_FIELD));
            this.dropWorkTable = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)DROP_WORK_TABLE_FIELD));
            this.dropErrorTable = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)DROP_ERROR_TABLE_FIELD));
            this.dropErrorTable2 = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)DROP_ERROR_TABLE_2_FIELD));
            this.ignoreDupUpdate = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)IGNORE_DUP_UPDATE_FIELD));
            this.insertMissingUpdate = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)INSERT_MISSING_UPDATE_FIELD));
            this.ignoreMissingUpdate = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)IGNORE_MISSING_UPDATE_FIELD));
            this.accessLogFile = XMLHandler.getTagValue((Node)stepnode, (String)ACCESS_LOG_FILE_FIELD);
            this.updateLogFile = XMLHandler.getTagValue((Node)stepnode, (String)UPDATE_LOG_FILE_FIELD);
            this.fifoFileName = XMLHandler.getTagValue((Node)stepnode, (String)FIFO_FILE_NAME_FIELD);
            this.randomizeFifoFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)RANDOMIZE_FIFO_FILE_NAME_FIELD));
            this.scriptFileName = XMLHandler.getTagValue((Node)stepnode, (String)SCRIPT_FILE_NAME_FIELD);
            String sactionType = XMLHandler.getTagValue((Node)stepnode, (String)ACTION_TYPE_FIELD);
            if (sactionType != null) {
                this.actionType = Integer.parseInt(sactionType);
            }
            this.existingScriptFile = XMLHandler.getTagValue((Node)stepnode, (String)EXISTING_SCRIPT_FILE_FIELD);
            this.substituteScriptFile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)SUBSTITUTE_SCRIPT_FILE_FIELD));
            this.existingVariableFile = XMLHandler.getTagValue((Node)stepnode, (String)EXISTING_VARIABLE_FILE_FIELD);
            this.substituteVariableFile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)SUBSTITUTE_VARIABLE_FILE_FIELD));
            Node lookup = XMLHandler.getSubNode((Node)stepnode, (String)"lookup");
            int nrvalues = XMLHandler.countNodes((Node)stepnode, (String)"mapping");
            int nrkeys = XMLHandler.countNodes((Node)lookup, (String)"key");
            this.allocate(nrkeys, nrvalues);
            for (i = 0; i < nrkeys; ++i) {
                Node knode = XMLHandler.getSubNodeByNr((Node)lookup, (String)"key", (int)i);
                this.keyStream[i] = XMLHandler.getTagValue((Node)knode, (String)"name");
                this.keyLookup[i] = XMLHandler.getTagValue((Node)knode, (String)"field");
                this.keyCondition[i] = XMLHandler.getTagValue((Node)knode, (String)"condition");
                if (this.keyCondition[i] != null) continue;
                this.keyCondition[i] = "=";
            }
            for (i = 0; i < nrvalues; ++i) {
                String updateValue;
                Node vnode = XMLHandler.getSubNodeByNr((Node)stepnode, (String)"mapping", (int)i);
                this.fieldTable[i] = XMLHandler.getTagValue((Node)vnode, (String)"stream_name");
                this.fieldStream[i] = XMLHandler.getTagValue((Node)vnode, (String)"field_name");
                if (this.fieldStream[i] == null) {
                    this.fieldStream[i] = this.fieldTable[i];
                }
                this.fieldUpdate[i] = (updateValue = XMLHandler.getTagValue((Node)vnode, (String)"update")) == null ? Boolean.TRUE : (updateValue.equalsIgnoreCase("Y") ? Boolean.TRUE : Boolean.FALSE);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.Exception.UnableToReadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.fieldTable = null;
        this.databaseMeta = null;
        this.generateScript = true;
        this.allocate(0, 0);
    }

    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer(3000);
        retval.append("    ").append(XMLHandler.addTagValue((String)CONNECTION_FIELD, (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    ").append(XMLHandler.addTagValue((String)GENERATE_SCRIPT_FIELD, (boolean)this.generateScript));
        retval.append("    ").append(XMLHandler.addTagValue((String)TBUILD_PATH_FIELD, (String)this.tbuildPath));
        retval.append("    ").append(XMLHandler.addTagValue((String)TBUILD_LIB_PATH_FIELD, (String)this.tbuildLibPath));
        retval.append("    ").append(XMLHandler.addTagValue((String)LIB_PATH_FIELD, (String)this.libPath));
        retval.append("    ").append(XMLHandler.addTagValue((String)TDICU_LIB_PATH_FIELD, (String)this.tdicuLibPath));
        retval.append("    ").append(XMLHandler.addTagValue((String)COP_LIB_PATH_FIELD, (String)this.copLibPath));
        retval.append("    ").append(XMLHandler.addTagValue((String)TWB_ROOT_FIELD, (String)this.twbRoot));
        retval.append("    ").append(XMLHandler.addTagValue((String)INSTALL_PATH_FIELD, (String)this.installPath));
        retval.append("    ").append(XMLHandler.addTagValue((String)JOB_NAME_FIELD, (String)this.jobName));
        retval.append("    ").append(XMLHandler.addTagValue((String)SCHEMA_FIELD, (String)this.schemaName));
        retval.append("    ").append(XMLHandler.addTagValue((String)TABLE_FIELD, (String)this.tableName));
        retval.append("    ").append(XMLHandler.addTagValue((String)LOG_TABLE_FIELD, (String)this.logTable));
        retval.append("    ").append(XMLHandler.addTagValue((String)WORK_TABLE_FIELD, (String)this.workTable));
        retval.append("    ").append(XMLHandler.addTagValue((String)ERROR_TABLE_FIELD, (String)this.errorTable));
        retval.append("    ").append(XMLHandler.addTagValue((String)ERROR_TABLE_2_FIELD, (String)this.errorTable2));
        retval.append("    ").append(XMLHandler.addTagValue((String)DROP_LOG_TABLE_FIELD, (boolean)this.dropLogTable));
        retval.append("    ").append(XMLHandler.addTagValue((String)DROP_WORK_TABLE_FIELD, (boolean)this.dropWorkTable));
        retval.append("    ").append(XMLHandler.addTagValue((String)DROP_ERROR_TABLE_FIELD, (boolean)this.dropErrorTable));
        retval.append("    ").append(XMLHandler.addTagValue((String)DROP_ERROR_TABLE_2_FIELD, (boolean)this.dropErrorTable2));
        retval.append("    ").append(XMLHandler.addTagValue((String)IGNORE_DUP_UPDATE_FIELD, (boolean)this.ignoreDupUpdate));
        retval.append("    ").append(XMLHandler.addTagValue((String)INSERT_MISSING_UPDATE_FIELD, (boolean)this.insertMissingUpdate));
        retval.append("    ").append(XMLHandler.addTagValue((String)IGNORE_MISSING_UPDATE_FIELD, (boolean)this.ignoreMissingUpdate));
        retval.append("    ").append(XMLHandler.addTagValue((String)ACCESS_LOG_FILE_FIELD, (String)this.accessLogFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)UPDATE_LOG_FILE_FIELD, (String)this.updateLogFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)FIFO_FILE_NAME_FIELD, (String)this.fifoFileName));
        retval.append("    ").append(XMLHandler.addTagValue((String)RANDOMIZE_FIFO_FILE_NAME_FIELD, (boolean)this.randomizeFifoFilename));
        retval.append("    ").append(XMLHandler.addTagValue((String)SCRIPT_FILE_NAME_FIELD, (String)this.scriptFileName));
        retval.append("    ").append(XMLHandler.addTagValue((String)ACTION_TYPE_FIELD, (int)this.actionType));
        retval.append("    ").append(XMLHandler.addTagValue((String)EXISTING_SCRIPT_FILE_FIELD, (String)this.existingScriptFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)SUBSTITUTE_SCRIPT_FILE_FIELD, (boolean)this.substituteScriptFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)EXISTING_VARIABLE_FILE_FIELD, (String)this.existingVariableFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)SUBSTITUTE_VARIABLE_FILE_FIELD, (boolean)this.substituteVariableFile));
        retval.append("    <lookup>").append(Const.CR);
        for (i = 0; i < this.keyStream.length; ++i) {
            retval.append("      <key>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.keyStream[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"field", (String)this.keyLookup[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"condition", (String)this.keyCondition[i]));
            retval.append("      </key>").append(Const.CR);
        }
        retval.append("    </lookup>").append(Const.CR);
        for (i = 0; i < this.fieldTable.length; ++i) {
            retval.append("      <mapping>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"stream_name", (String)this.fieldTable[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"field_name", (String)this.fieldStream[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"update", (boolean)this.fieldUpdate[i]));
            retval.append("      </mapping>").append(Const.CR);
        }
        return retval.toString();
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int i;
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(id_step, "id_connection", databases);
            this.tableName = rep.getStepAttributeString(id_step, TABLE_FIELD);
            int nrkeys = rep.countNrStepAttributes(id_step, "key_field");
            int nrvalues = rep.countNrStepAttributes(id_step, "stream_name");
            this.allocate(nrkeys, nrvalues);
            for (i = 0; i < nrkeys; ++i) {
                this.keyStream[i] = rep.getStepAttributeString(id_step, i, "key_name");
                this.keyLookup[i] = rep.getStepAttributeString(id_step, i, "key_field");
                this.keyCondition[i] = rep.getStepAttributeString(id_step, i, "key_condition");
            }
            for (i = 0; i < nrvalues; ++i) {
                this.fieldTable[i] = rep.getStepAttributeString(id_step, i, "stream_name");
                this.fieldStream[i] = rep.getStepAttributeString(id_step, i, "field_name");
                if (this.fieldStream[i] == null) {
                    this.fieldStream[i] = this.fieldTable[i];
                }
                this.fieldUpdate[i] = rep.getStepAttributeBoolean(id_step, i, "value_update", true);
            }
            this.generateScript = rep.getStepAttributeBoolean(id_step, GENERATE_SCRIPT_FIELD);
            this.tbuildPath = rep.getStepAttributeString(id_step, TBUILD_PATH_FIELD);
            this.tbuildLibPath = rep.getStepAttributeString(id_step, TBUILD_LIB_PATH_FIELD);
            this.libPath = rep.getStepAttributeString(id_step, LIB_PATH_FIELD);
            this.tdicuLibPath = rep.getStepAttributeString(id_step, TDICU_LIB_PATH_FIELD);
            this.copLibPath = rep.getStepAttributeString(id_step, COP_LIB_PATH_FIELD);
            this.twbRoot = rep.getStepAttributeString(id_step, TWB_ROOT_FIELD);
            this.installPath = rep.getStepAttributeString(id_step, INSTALL_PATH_FIELD);
            this.jobName = rep.getStepAttributeString(id_step, JOB_NAME_FIELD);
            this.fifoFileName = rep.getStepAttributeString(id_step, FIFO_FILE_NAME_FIELD);
            this.randomizeFifoFilename = rep.getStepAttributeBoolean(id_step, RANDOMIZE_FIFO_FILE_NAME_FIELD);
            this.schemaName = rep.getStepAttributeString(id_step, SCHEMA_FIELD);
            this.tableName = rep.getStepAttributeString(id_step, TABLE_FIELD);
            this.logTable = rep.getStepAttributeString(id_step, LOG_TABLE_FIELD);
            this.workTable = rep.getStepAttributeString(id_step, WORK_TABLE_FIELD);
            this.errorTable = rep.getStepAttributeString(id_step, ERROR_TABLE_FIELD);
            this.errorTable2 = rep.getStepAttributeString(id_step, ERROR_TABLE_2_FIELD);
            this.dropLogTable = rep.getStepAttributeBoolean(id_step, DROP_LOG_TABLE_FIELD);
            this.dropWorkTable = rep.getStepAttributeBoolean(id_step, DROP_WORK_TABLE_FIELD);
            this.dropErrorTable = rep.getStepAttributeBoolean(id_step, DROP_ERROR_TABLE_FIELD);
            this.dropErrorTable2 = rep.getStepAttributeBoolean(id_step, DROP_ERROR_TABLE_2_FIELD);
            this.ignoreDupUpdate = rep.getStepAttributeBoolean(id_step, IGNORE_DUP_UPDATE_FIELD);
            this.insertMissingUpdate = rep.getStepAttributeBoolean(id_step, INSERT_MISSING_UPDATE_FIELD);
            this.ignoreMissingUpdate = rep.getStepAttributeBoolean(id_step, IGNORE_MISSING_UPDATE_FIELD);
            this.accessLogFile = rep.getStepAttributeString(id_step, ACCESS_LOG_FILE_FIELD);
            this.updateLogFile = rep.getStepAttributeString(id_step, UPDATE_LOG_FILE_FIELD);
            this.scriptFileName = rep.getStepAttributeString(id_step, SCRIPT_FILE_NAME_FIELD);
            this.actionType = (int)rep.getStepAttributeInteger(id_step, ACTION_TYPE_FIELD);
            this.existingScriptFile = rep.getStepAttributeString(id_step, EXISTING_SCRIPT_FILE_FIELD);
            this.substituteScriptFile = rep.getStepAttributeBoolean(id_step, SUBSTITUTE_SCRIPT_FILE_FIELD);
            this.existingVariableFile = rep.getStepAttributeString(id_step, EXISTING_VARIABLE_FILE_FIELD);
            this.substituteVariableFile = rep.getStepAttributeBoolean(id_step, SUBSTITUTE_VARIABLE_FILE_FIELD);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.Exception.UnexpectedErrorReadingStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta);
            rep.saveStepAttribute(id_transformation, id_step, TABLE_FIELD, this.tableName);
            for (i = 0; i < this.keyStream.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "key_name", this.keyStream[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "key_field", this.keyLookup[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "key_condition", this.keyCondition[i]);
            }
            for (i = 0; i < this.fieldTable.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "stream_name", this.fieldTable[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.fieldStream[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "value_update", this.fieldUpdate[i].booleanValue());
            }
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getObjectId());
            }
            rep.saveStepAttribute(id_transformation, id_step, GENERATE_SCRIPT_FIELD, this.generateScript);
            rep.saveStepAttribute(id_transformation, id_step, TBUILD_PATH_FIELD, this.tbuildPath);
            rep.saveStepAttribute(id_transformation, id_step, TBUILD_LIB_PATH_FIELD, this.tbuildLibPath);
            rep.saveStepAttribute(id_transformation, id_step, LIB_PATH_FIELD, this.libPath);
            rep.saveStepAttribute(id_transformation, id_step, TDICU_LIB_PATH_FIELD, this.tdicuLibPath);
            rep.saveStepAttribute(id_transformation, id_step, COP_LIB_PATH_FIELD, this.copLibPath);
            rep.saveStepAttribute(id_transformation, id_step, TWB_ROOT_FIELD, this.twbRoot);
            rep.saveStepAttribute(id_transformation, id_step, INSTALL_PATH_FIELD, this.installPath);
            rep.saveStepAttribute(id_transformation, id_step, JOB_NAME_FIELD, this.jobName);
            rep.saveStepAttribute(id_transformation, id_step, FIFO_FILE_NAME_FIELD, this.fifoFileName);
            rep.saveStepAttribute(id_transformation, id_step, RANDOMIZE_FIFO_FILE_NAME_FIELD, this.randomizeFifoFilename);
            rep.saveStepAttribute(id_transformation, id_step, SCHEMA_FIELD, this.schemaName);
            rep.saveStepAttribute(id_transformation, id_step, LOG_TABLE_FIELD, this.logTable);
            rep.saveStepAttribute(id_transformation, id_step, WORK_TABLE_FIELD, this.workTable);
            rep.saveStepAttribute(id_transformation, id_step, ERROR_TABLE_FIELD, this.errorTable);
            rep.saveStepAttribute(id_transformation, id_step, ERROR_TABLE_2_FIELD, this.errorTable2);
            rep.saveStepAttribute(id_transformation, id_step, DROP_LOG_TABLE_FIELD, this.dropLogTable);
            rep.saveStepAttribute(id_transformation, id_step, DROP_WORK_TABLE_FIELD, this.dropWorkTable);
            rep.saveStepAttribute(id_transformation, id_step, DROP_ERROR_TABLE_FIELD, this.dropErrorTable);
            rep.saveStepAttribute(id_transformation, id_step, DROP_ERROR_TABLE_2_FIELD, this.dropErrorTable2);
            rep.saveStepAttribute(id_transformation, id_step, IGNORE_DUP_UPDATE_FIELD, this.ignoreDupUpdate);
            rep.saveStepAttribute(id_transformation, id_step, INSERT_MISSING_UPDATE_FIELD, this.insertMissingUpdate);
            rep.saveStepAttribute(id_transformation, id_step, IGNORE_MISSING_UPDATE_FIELD, this.ignoreMissingUpdate);
            rep.saveStepAttribute(id_transformation, id_step, ACCESS_LOG_FILE_FIELD, this.accessLogFile);
            rep.saveStepAttribute(id_transformation, id_step, UPDATE_LOG_FILE_FIELD, this.updateLogFile);
            rep.saveStepAttribute(id_transformation, id_step, SCRIPT_FILE_NAME_FIELD, this.scriptFileName);
            rep.saveStepAttribute(id_transformation, id_step, ACTION_TYPE_FIELD, (long)this.actionType);
            rep.saveStepAttribute(id_transformation, id_step, EXISTING_SCRIPT_FILE_FIELD, this.existingScriptFile);
            rep.saveStepAttribute(id_transformation, id_step, SUBSTITUTE_SCRIPT_FILE_FIELD, this.substituteScriptFile);
            rep.saveStepAttribute(id_transformation, id_step, EXISTING_VARIABLE_FILE_FIELD, this.existingVariableFile);
            rep.saveStepAttribute(id_transformation, id_step, SUBSTITUTE_VARIABLE_FILE_FIELD, this.substituteVariableFile);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface arg6) {
        CheckResult cr;
        String error_message = "";
        if (this.databaseMeta != null) {
            Database db = new Database(loggingObject, this.databaseMeta);
            db.shareVariablesWith((VariableSpace)transMeta);
            try {
                boolean error_found;
                boolean first;
                db.connect();
                if (!Const.isEmpty((String)this.tableName)) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.CheckResult.TableNameOK", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                    first = true;
                    error_found = false;
                    error_message = "";
                    String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(transMeta.environmentSubstitute(this.schemaName), transMeta.environmentSubstitute(this.tableName));
                    RowMetaInterface r = db.getTableFields(schemaTable);
                    if (r != null) {
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.CheckResult.TableExists", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                        first = true;
                        error_found = false;
                        error_message = "";
                        for (int i = 0; i < this.fieldTable.length; ++i) {
                            String field = this.fieldTable[i];
                            ValueMetaInterface v = r.searchValueMeta(field);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                error_message = error_message + BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.CheckResult.MissingFieldsToLoadInTargetTable", (String[])new String[0]) + Const.CR;
                            }
                            error_found = true;
                            error_message = error_message + "\t\t" + field + Const.CR;
                        }
                        cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.CheckResult.AllFieldsFoundInTargetTable", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    } else {
                        error_message = BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.CheckResult.CouldNotReadTableInfo", (String[])new String[0]);
                        cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    }
                }
                if (prev != null && prev.size() > 0) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.CheckResult.StepReceivingDatas", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                    first = true;
                    error_message = "";
                    error_found = false;
                    for (int i = 0; i < this.fieldStream.length; ++i) {
                        ValueMetaInterface v = prev.searchValueMeta(this.fieldStream[i]);
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            error_message = error_message + BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.CheckResult.MissingFieldsInInput", (String[])new String[0]) + Const.CR;
                        }
                        error_found = true;
                        error_message = error_message + "\t\t" + this.fieldStream[i] + Const.CR;
                    }
                    cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.CheckResult.AllFieldsFoundInInput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                error_message = BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.CheckResult.MissingFieldsInInput3", (String[])new String[0]) + Const.CR;
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            catch (KettleException e) {
                error_message = BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.CheckResult.DatabaseErrorOccurred", (String[])new String[0]) + e.getMessage();
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            error_message = BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.CheckResult.StepReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.CheckResult.NoInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, Repository repository) throws KettleStepException {
        SQLStatement retval;
        block11: {
            retval = new SQLStatement(stepMeta.getName(), this.databaseMeta, null);
            if (this.databaseMeta != null) {
                if (prev != null && prev.size() > 0) {
                    RowMeta tableFields = new RowMeta();
                    for (int i = 0; i < this.fieldTable.length; ++i) {
                        ValueMetaInterface v = prev.searchValueMeta(this.fieldStream[i]);
                        if (v == null) {
                            throw new KettleStepException(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.Exception.CannotFindFieldInInput", (String[])new String[]{this.fieldStream[i]}));
                        }
                        ValueMetaInterface tableField = v.clone();
                        tableField.setName(this.fieldTable[i]);
                        tableFields.addValueMeta(tableField);
                    }
                    if (!Const.isEmpty((String)this.tableName)) {
                        Database db = new Database(loggingObject, this.databaseMeta);
                        db.shareVariablesWith((VariableSpace)transMeta);
                        try {
                            String cr_table;
                            db.connect();
                            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(transMeta.environmentSubstitute(this.schemaName), transMeta.environmentSubstitute(this.tableName));
                            String sql = cr_table = db.getDDL(schemaTable, (RowMetaInterface)tableFields, null, false, null, true);
                            if (sql.length() == 0) {
                                retval.setSQL(null);
                                break block11;
                            }
                            retval.setSQL(sql);
                        }
                        catch (KettleException e) {
                            retval.setError(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.GetSQL.ErrorOccurred", (String[])new String[0]) + e.getMessage());
                        }
                    } else {
                        retval.setError(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.GetSQL.NoTableDefinedOnConnection", (String[])new String[0]));
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.GetSQL.NotReceivingAnyFields", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.GetSQL.NoConnectionDefined", (String[])new String[0]));
            }
        }
        return retval;
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        this.myStep = new TeraDataBulkLoader(stepMeta, stepDataInterface, cnr, transMeta, trans);
        return this.myStep;
    }

    public StepDataInterface getStepData() {
        return new TeraDataBulkLoaderData();
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RowMetaInterface getRequiredFields(VariableSpace space) throws KettleException {
        String realTableName = space.environmentSubstitute(this.tableName);
        String realSchemaName = space.environmentSubstitute(this.schemaName);
        if (this.databaseMeta == null) throw new KettleException(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.Exception.ConnectionNotDefined", (String[])new String[0]));
        Database db = new Database(loggingObject, this.databaseMeta);
        try {
            db.connect();
            if (Const.isEmpty((String)realTableName)) throw new KettleException(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.Exception.TableNotSpecified", (String[])new String[0]));
            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(realSchemaName, realTableName);
            if (db.checkTableExists(schemaTable)) {
                RowMetaInterface rv;
                RowMetaInterface rowMetaInterface = rv = db.getTableFields(schemaTable);
                return rowMetaInterface;
            }
            try {
                throw new KettleException(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.Exception.TableNotFound", (String[])new String[0]));
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderMeta.Exception.ErrorGettingFields", (String[])new String[0]), (Throwable)e);
            }
        }
        finally {
            db.disconnect();
        }
    }

    public static String[] getFieldFormatTypeCodes() {
        return fieldFormatTypeCodes;
    }

    public static String[] getFieldFormatTypeDescriptions() {
        return fieldFormatTypeDescriptions;
    }

    public static String getFieldFormatTypeCode(int type) {
        return fieldFormatTypeCodes[type];
    }

    public static String getFieldFormatTypeDescription(int type) {
        return fieldFormatTypeDescriptions[type];
    }

    public static int getFieldFormatType(String codeOrDescription) {
        int i;
        for (i = 0; i < fieldFormatTypeCodes.length; ++i) {
            if (!fieldFormatTypeCodes[i].equalsIgnoreCase(codeOrDescription)) continue;
            return i;
        }
        for (i = 0; i < fieldFormatTypeDescriptions.length; ++i) {
            if (!fieldFormatTypeDescriptions[i].equalsIgnoreCase(codeOrDescription)) continue;
            return i;
        }
        return 0;
    }

    public String getMissingDatabaseConnectionInformationMessage() {
        return null;
    }
}

