/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.List;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.unit.TimeValue;

public abstract class ClusterStateUpdateTask
extends ClusterStateTaskExecutor<ClusterStateUpdateTask>
implements ClusterStateTaskConfig,
ClusterStateTaskListener {
    private final Priority priority;

    public ClusterStateUpdateTask() {
        this(Priority.NORMAL);
    }

    public ClusterStateUpdateTask(Priority priority) {
        this.priority = priority;
    }

    @Override
    public final ClusterStateTaskExecutor.BatchResult<ClusterStateUpdateTask> execute(ClusterState currentState, List<ClusterStateUpdateTask> tasks) throws Exception {
        ClusterState result = this.execute(currentState);
        return ClusterStateTaskExecutor.BatchResult.builder().successes(tasks).build(result);
    }

    public abstract ClusterState execute(ClusterState var1) throws Exception;

    @Override
    public abstract void onFailure(String var1, Throwable var2);

    @Override
    public void onNoLongerMaster(String source) {
        this.onFailure(source, new NotMasterException("no longer master. source: [" + source + "]"));
    }

    @Override
    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
    }

    @Override
    @Nullable
    public TimeValue timeout() {
        return null;
    }

    @Override
    public Priority priority() {
        return this.priority;
    }
}

