/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.index.FilterableTermsEnum;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.LongArray;

public class FreqTermsEnum
extends FilterableTermsEnum
implements Releasable {
    private static final int INITIAL_NUM_TERM_FREQS_CACHED = 512;
    private final BigArrays bigArrays;
    private IntArray termDocFreqs;
    private LongArray termsTotalFreqs;
    private BytesRefHash cachedTermOrds;
    private final boolean needDocFreqs;
    private final boolean needTotalTermFreqs;

    public FreqTermsEnum(IndexReader reader, String field, boolean needDocFreq, boolean needTotalTermFreq, @Nullable Query filter, BigArrays bigArrays) throws IOException {
        super(reader, field, needTotalTermFreq ? 8 : 0, filter);
        this.bigArrays = bigArrays;
        this.needDocFreqs = needDocFreq;
        this.needTotalTermFreqs = needTotalTermFreq;
        this.termDocFreqs = needDocFreq ? bigArrays.newIntArray(512L, false) : null;
        this.termsTotalFreqs = needTotalTermFreq ? bigArrays.newLongArray(512L, false) : null;
        this.cachedTermOrds = new BytesRefHash(512L, bigArrays);
    }

    @Override
    public boolean seekExact(BytesRef text) throws IOException {
        long currentTermOrd = this.cachedTermOrds.add(text);
        if (currentTermOrd < 0L) {
            currentTermOrd = -1L - currentTermOrd;
            boolean found = true;
            if (this.needDocFreqs) {
                this.currentDocFreq = this.termDocFreqs.get(currentTermOrd);
                boolean bl = found = this.currentDocFreq != -1;
            }
            if (this.needTotalTermFreqs) {
                this.currentTotalTermFreq = this.termsTotalFreqs.get(currentTermOrd);
                found = this.currentTotalTermFreq != -1L;
            }
            this.current = found ? text : null;
            return found;
        }
        boolean found = super.seekExact(text);
        if (this.needDocFreqs) {
            this.termDocFreqs = this.bigArrays.grow(this.termDocFreqs, currentTermOrd + 1L);
            this.termDocFreqs.set(currentTermOrd, this.currentDocFreq);
        }
        if (this.needTotalTermFreqs) {
            this.termsTotalFreqs = this.bigArrays.grow(this.termsTotalFreqs, currentTermOrd + 1L);
            this.termsTotalFreqs.set(currentTermOrd, this.currentTotalTermFreq);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            Releasables.close(this.cachedTermOrds, this.termDocFreqs, this.termsTotalFreqs);
        }
        finally {
            this.cachedTermOrds = null;
            this.termDocFreqs = null;
            this.termsTotalFreqs = null;
        }
    }
}

