/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.Content;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import org.apache.hadoop.hdfs.server.namenode.FileUnderConstructionFeature;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFileAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileDiff;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileDiffList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileWithSnapshotFeature;
import org.apache.hadoop.hdfs.util.LongBitFormat;

@InterfaceAudience.Private
public class INodeFile
extends INodeWithAdditionalFields
implements INodeFileAttributes,
BlockCollection {
    private long header = 0L;
    private BlockInfo[] blocks;

    public static INodeFile valueOf(INode inode, String path) throws FileNotFoundException {
        return INodeFile.valueOf(inode, path, false);
    }

    public static INodeFile valueOf(INode inode, String path, boolean acceptNull) throws FileNotFoundException {
        if (inode == null) {
            if (acceptNull) {
                return null;
            }
            throw new FileNotFoundException("File does not exist: " + path);
        }
        if (!inode.isFile()) {
            throw new FileNotFoundException("Path is not a file: " + path);
        }
        return inode.asFile();
    }

    INodeFile(long id, byte[] name, PermissionStatus permissions, long mtime, long atime, BlockInfo[] blklist, short replication, long preferredBlockSize) {
        this(id, name, permissions, mtime, atime, blklist, replication, preferredBlockSize, 0);
    }

    INodeFile(long id, byte[] name, PermissionStatus permissions, long mtime, long atime, BlockInfo[] blklist, short replication, long preferredBlockSize, byte storagePolicyID) {
        super(id, name, permissions, mtime, atime);
        this.header = HeaderFormat.toLong(preferredBlockSize, replication, storagePolicyID);
        this.blocks = blklist;
    }

    public INodeFile(INodeFile that) {
        super(that);
        this.header = that.header;
        this.blocks = that.blocks;
        this.features = that.features;
    }

    public INodeFile(INodeFile that, FileDiffList diffs) {
        this(that);
        Preconditions.checkArgument((!that.isWithSnapshot() ? 1 : 0) != 0);
        this.addSnapshotFeature(diffs);
    }

    @Override
    public final boolean isFile() {
        return true;
    }

    @Override
    public final INodeFile asFile() {
        return this;
    }

    @Override
    public boolean metadataEquals(INodeFileAttributes other) {
        return other != null && this.getHeaderLong() == other.getHeaderLong() && this.getPermissionLong() == other.getPermissionLong() && this.getAclFeature() == other.getAclFeature() && this.getXAttrFeature() == other.getXAttrFeature();
    }

    public final FileUnderConstructionFeature getFileUnderConstructionFeature() {
        return (FileUnderConstructionFeature)this.getFeature(FileUnderConstructionFeature.class);
    }

    @Override
    public boolean isUnderConstruction() {
        return this.getFileUnderConstructionFeature() != null;
    }

    INodeFile toUnderConstruction(String clientName, String clientMachine) {
        Preconditions.checkState((!this.isUnderConstruction() ? 1 : 0) != 0, (Object)"file is already under construction");
        FileUnderConstructionFeature uc = new FileUnderConstructionFeature(clientName, clientMachine);
        this.addFeature(uc);
        return this;
    }

    public INodeFile toCompleteFile(long mtime) {
        Preconditions.checkState((boolean)this.isUnderConstruction(), (Object)"file is no longer under construction");
        FileUnderConstructionFeature uc = this.getFileUnderConstructionFeature();
        if (uc != null) {
            this.assertAllBlocksComplete();
            this.removeFeature(uc);
            this.setModificationTime(mtime);
        }
        return this;
    }

    private void assertAllBlocksComplete() {
        if (this.blocks == null) {
            return;
        }
        for (int i = 0; i < this.blocks.length; ++i) {
            Preconditions.checkState((boolean)this.blocks[i].isComplete(), (String)"Failed to finalize %s %s since blocks[%s] is non-complete, where blocks=%s.", (Object[])new Object[]{this.getClass().getSimpleName(), this, i, Arrays.asList(this.blocks)});
        }
    }

    @Override
    public void setBlock(int index, BlockInfo blk) {
        this.blocks[index] = blk;
    }

    @Override
    public BlockInfoUnderConstruction setLastBlock(BlockInfo lastBlock, DatanodeStorageInfo[] locations) throws IOException {
        Preconditions.checkState((boolean)this.isUnderConstruction(), (Object)"file is no longer under construction");
        if (this.numBlocks() == 0) {
            throw new IOException("Failed to set last block: File is empty.");
        }
        BlockInfoUnderConstruction ucBlock = lastBlock.convertToBlockUnderConstruction(HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, locations);
        ucBlock.setBlockCollection(this);
        this.setBlock(this.numBlocks() - 1, ucBlock);
        return ucBlock;
    }

    boolean removeLastBlock(Block oldblock) {
        Preconditions.checkState((boolean)this.isUnderConstruction(), (Object)"file is no longer under construction");
        if (this.blocks == null || this.blocks.length == 0) {
            return false;
        }
        int size_1 = this.blocks.length - 1;
        if (!this.blocks[size_1].equals(oldblock)) {
            return false;
        }
        BlockInfo[] newlist = new BlockInfo[size_1];
        System.arraycopy(this.blocks, 0, newlist, 0, size_1);
        this.setBlocks(newlist);
        return true;
    }

    public FileWithSnapshotFeature addSnapshotFeature(FileDiffList diffs) {
        Preconditions.checkState((!this.isWithSnapshot() ? 1 : 0) != 0, (Object)"File is already with snapshot");
        FileWithSnapshotFeature sf = new FileWithSnapshotFeature(diffs);
        this.addFeature(sf);
        return sf;
    }

    public final FileWithSnapshotFeature getFileWithSnapshotFeature() {
        return (FileWithSnapshotFeature)this.getFeature(FileWithSnapshotFeature.class);
    }

    public final boolean isWithSnapshot() {
        return this.getFileWithSnapshotFeature() != null;
    }

    @Override
    public String toDetailString() {
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        return super.toDetailString() + (sf == null ? "" : sf.getDetailedString());
    }

    @Override
    public INodeFileAttributes getSnapshotINode(int snapshotId) {
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (sf != null) {
            return sf.getDiffs().getSnapshotINode(snapshotId, this);
        }
        return this;
    }

    @Override
    public void recordModification(int latestSnapshotId) {
        this.recordModification(latestSnapshotId, false);
    }

    public void recordModification(int latestSnapshotId, boolean withBlocks) {
        if (this.isInLatestSnapshot(latestSnapshotId) && !this.shouldRecordInSrcSnapshot(latestSnapshotId)) {
            FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
            if (sf == null) {
                sf = this.addSnapshotFeature(null);
            }
            sf.getDiffs().saveSelf2Snapshot(latestSnapshotId, this, null);
        }
    }

    public FileDiffList getDiffs() {
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (sf != null) {
            return sf.getDiffs();
        }
        return null;
    }

    public final short getFileReplication(int snapshot) {
        if (snapshot != 0x7FFFFFFE) {
            return this.getSnapshotINode(snapshot).getFileReplication();
        }
        return HeaderFormat.getReplication(this.header);
    }

    @Override
    public final short getFileReplication() {
        return this.getFileReplication(0x7FFFFFFE);
    }

    @Override
    public short getBlockReplication() {
        short max = this.getFileReplication(0x7FFFFFFE);
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (sf != null) {
            short maxInSnapshot = sf.getMaxBlockRepInDiffs();
            if (sf.isCurrentFileDeleted()) {
                return maxInSnapshot;
            }
            max = maxInSnapshot > max ? maxInSnapshot : max;
        }
        return max;
    }

    public final void setFileReplication(short replication) {
        this.header = HeaderFormat.REPLICATION.BITS.combine(replication, this.header);
    }

    public final INodeFile setFileReplication(short replication, int latestSnapshotId) throws QuotaExceededException {
        this.recordModification(latestSnapshotId);
        this.setFileReplication(replication);
        return this;
    }

    @Override
    public long getPreferredBlockSize() {
        return HeaderFormat.getPreferredBlockSize(this.header);
    }

    @Override
    public byte getLocalStoragePolicyID() {
        return HeaderFormat.getStoragePolicyID(this.header);
    }

    @Override
    public byte getStoragePolicyID() {
        byte id = this.getLocalStoragePolicyID();
        if (id == 0) {
            return this.getParent() != null ? this.getParent().getStoragePolicyID() : id;
        }
        return id;
    }

    private void setStoragePolicyID(byte storagePolicyId) {
        this.header = HeaderFormat.STORAGE_POLICY_ID.BITS.combine(storagePolicyId, this.header);
    }

    public final void setStoragePolicyID(byte storagePolicyId, int latestSnapshotId) throws QuotaExceededException {
        this.recordModification(latestSnapshotId);
        this.setStoragePolicyID(storagePolicyId);
    }

    @Override
    public long getHeaderLong() {
        return this.header;
    }

    final long getBlockDiskspace() {
        return this.getPreferredBlockSize() * (long)this.getBlockReplication();
    }

    @Override
    public BlockInfo[] getBlocks() {
        return this.blocks;
    }

    void updateBlockCollection() {
        if (this.blocks != null) {
            for (BlockInfo b : this.blocks) {
                b.setBlockCollection(this);
            }
        }
    }

    void concatBlocks(INodeFile[] inodes) {
        int size = this.blocks.length;
        int totalAddedBlocks = 0;
        for (INodeFile f : inodes) {
            totalAddedBlocks += f.blocks.length;
        }
        BlockInfo[] newlist = new BlockInfo[size + totalAddedBlocks];
        System.arraycopy(this.blocks, 0, newlist, 0, size);
        for (INodeFile in : inodes) {
            System.arraycopy(in.blocks, 0, newlist, size, in.blocks.length);
            size += in.blocks.length;
        }
        this.setBlocks(newlist);
        this.updateBlockCollection();
    }

    void addBlock(BlockInfo newblock) {
        if (this.blocks == null) {
            this.setBlocks(new BlockInfo[]{newblock});
        } else {
            int size = this.blocks.length;
            BlockInfo[] newlist = new BlockInfo[size + 1];
            System.arraycopy(this.blocks, 0, newlist, 0, size);
            newlist[size] = newblock;
            this.setBlocks(newlist);
        }
    }

    public void setBlocks(BlockInfo[] blocks) {
        this.blocks = blocks;
    }

    @Override
    public Quota.Counts cleanSubtree(int snapshot, int priorSnapshotId, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes, List<Long> removedUCFiles) {
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (sf != null) {
            return sf.cleanFile(this, snapshot, priorSnapshotId, collectedBlocks, removedINodes, removedUCFiles);
        }
        Quota.Counts counts = Quota.Counts.newInstance();
        if (snapshot == 0x7FFFFFFE) {
            if (priorSnapshotId == -1) {
                this.computeQuotaUsage(counts, false);
                this.destroyAndCollectBlocks(collectedBlocks, removedINodes, removedUCFiles);
            } else {
                FileUnderConstructionFeature uc = this.getFileUnderConstructionFeature();
                if (uc != null) {
                    uc.cleanZeroSizeBlock(this, collectedBlocks);
                    if (removedUCFiles != null) {
                        removedUCFiles.add(this.getId());
                    }
                }
            }
        }
        return counts;
    }

    @Override
    public void destroyAndCollectBlocks(INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes, List<Long> removedUCFiles) {
        if (this.blocks != null && collectedBlocks != null) {
            for (BlockInfo blk : this.blocks) {
                collectedBlocks.addDeleteBlock(blk);
                blk.setBlockCollection(null);
            }
        }
        this.setBlocks(BlockInfo.EMPTY_ARRAY);
        this.clear();
        removedINodes.add(this);
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (sf != null) {
            sf.clearDiffs();
        }
        if (this.isUnderConstruction() && removedUCFiles != null) {
            removedUCFiles.add(this.getId());
        }
    }

    @Override
    public String getName() {
        return this.getFullPathName();
    }

    @Override
    public final Quota.Counts computeQuotaUsage(Quota.Counts counts, boolean useCache, int lastSnapshotId) {
        long dsDelta;
        long nsDelta = 1L;
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (sf != null) {
            FileDiffList fileDiffList = sf.getDiffs();
            int last = fileDiffList.getLastSnapshotId();
            if (lastSnapshotId == 0x7FFFFFFE || last == 0x7FFFFFFE) {
                dsDelta = this.diskspaceConsumed();
            } else if (last < lastSnapshotId) {
                dsDelta = this.computeFileSize(true, false) * (long)this.getFileReplication();
            } else {
                int sid = fileDiffList.getSnapshotById(lastSnapshotId);
                dsDelta = this.diskspaceConsumed(sid);
            }
        } else {
            dsDelta = this.diskspaceConsumed();
        }
        counts.add(Quota.NAMESPACE, nsDelta);
        counts.add(Quota.DISKSPACE, dsDelta);
        return counts;
    }

    @Override
    public final ContentSummaryComputationContext computeContentSummary(int snapshotId, ContentSummaryComputationContext summary) {
        this.computeContentSummary4Snapshot(summary.getCounts());
        this.computeContentSummary4Current(snapshotId, summary.getCounts());
        return summary;
    }

    private void computeContentSummary4Snapshot(Content.Counts counts) {
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (sf != null) {
            FileDiffList diffs = sf.getDiffs();
            int n = diffs.asList().size();
            counts.add(Content.FILE, n);
            if (n > 0 && sf.isCurrentFileDeleted()) {
                counts.add(Content.LENGTH, ((FileDiff)diffs.getLast()).getFileSize());
            }
            if (sf.isCurrentFileDeleted()) {
                long lastFileSize = ((FileDiff)diffs.getLast()).getFileSize();
                counts.add(Content.DISKSPACE, lastFileSize * (long)this.getBlockReplication());
            }
        }
    }

    private void computeContentSummary4Current(int snapshotId, Content.Counts counts) {
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (sf != null && sf.isCurrentFileDeleted()) {
            return;
        }
        counts.add(Content.FILE, 1L);
        long fileLen = this.computeFileSize(snapshotId);
        counts.add(Content.LENGTH, fileLen);
        counts.add(Content.DISKSPACE, this.diskspaceConsumed());
    }

    public final long computeFileSize() {
        return this.computeFileSize(0x7FFFFFFE);
    }

    public final long computeFileSize(int snapshotId) {
        FileDiff d;
        FileWithSnapshotFeature sf = this.getFileWithSnapshotFeature();
        if (snapshotId != 0x7FFFFFFE && sf != null && (d = (FileDiff)sf.getDiffs().getDiffById(snapshotId)) != null) {
            return d.getFileSize();
        }
        return this.computeFileSize(true, false);
    }

    public final long computeFileSizeNotIncludingLastUcBlock() {
        return this.computeFileSize(false, false);
    }

    public final long computeFileSize(boolean includesLastUcBlock, boolean usePreferredBlockSize4LastUcBlock) {
        if (this.blocks == null || this.blocks.length == 0) {
            return 0L;
        }
        int last = this.blocks.length - 1;
        long size = this.blocks[last].getNumBytes();
        if (this.blocks[last] instanceof BlockInfoUnderConstruction) {
            if (!includesLastUcBlock) {
                size = 0L;
            } else if (usePreferredBlockSize4LastUcBlock) {
                size = this.getPreferredBlockSize();
            }
        }
        for (int i = 0; i < last; ++i) {
            size += this.blocks[i].getNumBytes();
        }
        return size;
    }

    public final long diskspaceConsumed() {
        return this.computeFileSize(true, true) * (long)this.getBlockReplication();
    }

    public final long diskspaceConsumed(int lastSnapshotId) {
        if (lastSnapshotId != 0x7FFFFFFE) {
            return this.computeFileSize(lastSnapshotId) * (long)this.getFileReplication(lastSnapshotId);
        }
        return this.diskspaceConsumed();
    }

    BlockInfo getPenultimateBlock() {
        if (this.blocks == null || this.blocks.length <= 1) {
            return null;
        }
        return this.blocks[this.blocks.length - 2];
    }

    @Override
    public BlockInfo getLastBlock() {
        return this.blocks == null || this.blocks.length == 0 ? null : this.blocks[this.blocks.length - 1];
    }

    @Override
    public int numBlocks() {
        return this.blocks == null ? 0 : this.blocks.length;
    }

    @Override
    @VisibleForTesting
    public void dumpTreeRecursively(PrintWriter out, StringBuilder prefix, int snapshotId) {
        super.dumpTreeRecursively(out, prefix, snapshotId);
        out.print(", fileSize=" + this.computeFileSize(snapshotId));
        out.print(", blocks=");
        out.print(this.blocks == null || this.blocks.length == 0 ? null : this.blocks[0]);
        out.println();
    }

    static enum HeaderFormat {
        PREFERRED_BLOCK_SIZE(null, 48, 1L),
        REPLICATION(HeaderFormat.PREFERRED_BLOCK_SIZE.BITS, 12, 1L),
        STORAGE_POLICY_ID(HeaderFormat.REPLICATION.BITS, 4, 0L);

        private final LongBitFormat BITS;

        private HeaderFormat(LongBitFormat previous, int length, long min) {
            this.BITS = new LongBitFormat(this.name(), previous, length, min);
        }

        static short getReplication(long header) {
            return (short)HeaderFormat.REPLICATION.BITS.retrieve(header);
        }

        static long getPreferredBlockSize(long header) {
            return HeaderFormat.PREFERRED_BLOCK_SIZE.BITS.retrieve(header);
        }

        static byte getStoragePolicyID(long header) {
            return (byte)HeaderFormat.STORAGE_POLICY_ID.BITS.retrieve(header);
        }

        static long toLong(long preferredBlockSize, short replication, byte storagePolicyID) {
            long h = 0L;
            if (preferredBlockSize == 0L) {
                preferredBlockSize = HeaderFormat.PREFERRED_BLOCK_SIZE.BITS.getMin();
            }
            h = HeaderFormat.PREFERRED_BLOCK_SIZE.BITS.combine(preferredBlockSize, h);
            h = HeaderFormat.REPLICATION.BITS.combine(replication, h);
            h = HeaderFormat.STORAGE_POLICY_ID.BITS.combine(storagePolicyID, h);
            return h;
        }
    }
}

