/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import org.drools.util.CompositeClassLoader;

public class ClassLoaderUtil {
    public static CompositeClassLoader getClassLoader(ClassLoader[] classLoaders, Class<?> cls, boolean enableCache) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader currentClassLoader = cls != null ? cls.getClassLoader() : ClassLoaderUtil.class.getClassLoader();
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        CompositeClassLoader cl = new CompositeClassLoader();
        if (systemClassLoader != null) {
            cl.addClassLoader(systemClassLoader);
        }
        if (currentClassLoader != null) {
            cl.addClassLoader(currentClassLoader);
        }
        if (contextClassLoader != null) {
            cl.addClassLoader(contextClassLoader);
        }
        if (classLoaders != null && classLoaders.length > 0) {
            for (ClassLoader classLoader : classLoaders) {
                if (classLoader == null) continue;
                cl.addClassLoader(classLoader);
            }
        }
        cl.setCachingEnabled(enableCache);
        return cl;
    }
}

