/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.luciddbstreamingloader;

import java.util.List;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.luciddbstreamingloader.LucidDBStreamingLoader;
import org.pentaho.di.trans.steps.luciddbstreamingloader.LucidDBStreamingLoaderData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="LucidDBStreamingLoader", image="BLKLS.svg", i18nPackageName="org.pentaho.di.trans.steps.luciddbstreamingloader", name="LucidDBStreamingLoaderMeta.Name", description="LucidDBStreamingLoaderMeta.Description", categoryDescription="i18n:org.pentaho.di.job:JobCategory.Category.Deprecated")
public class LucidDBStreamingLoaderMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = LucidDBStreamingLoaderMeta.class;
    public static String TARGET_TABLE_ALIAS = "TGT";
    public static String SOURCE_TABLE_ALIAS = "SRC";
    public static String REMOTE_ROWS_UDX = "APPLIB.REMOTE_ROWS";
    public static String OPERATION_MERGE = "MERGE";
    public static String OPERATION_INSERT = "INSERT";
    public static String OPERATION_UPDATE = "UPDATE";
    public static String OPERATION_CUSTOM = "CUSTOM";
    private String schemaName;
    private String tableName;
    private DatabaseMeta databaseMeta;
    private String host;
    private String port;
    private String operation;
    private String[] fieldTableForKeys;
    private String[] fieldStreamForKeys;
    private String[] fieldTableForFields;
    private String[] fieldStreamForFields;
    private boolean[] insOrUptFlag;
    private String custom_sql;
    private boolean[] tabIsEnable;

    public boolean[] getTabIsEnable() {
        return this.tabIsEnable;
    }

    public void setTabIsEnable(boolean[] tabIsEnable) {
        this.tabIsEnable = tabIsEnable;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    public void allocate(int nrKeyMapping, int nrFieldMapping, int nrTabIsEnable) {
        this.fieldTableForKeys = new String[nrKeyMapping];
        this.fieldStreamForKeys = new String[nrKeyMapping];
        this.fieldTableForFields = new String[nrFieldMapping];
        this.fieldStreamForFields = new String[nrFieldMapping];
        this.insOrUptFlag = new boolean[nrFieldMapping];
        this.tabIsEnable = new boolean[nrTabIsEnable];
    }

    public Object clone() {
        int i;
        LucidDBStreamingLoaderMeta retval = (LucidDBStreamingLoaderMeta)((Object)super.clone());
        int nrKeyMapping = this.fieldTableForKeys.length;
        int nrFieldMapping = this.fieldTableForFields.length;
        int nrTabIsEnable = this.tabIsEnable.length;
        retval.allocate(nrKeyMapping, nrFieldMapping, nrTabIsEnable);
        for (i = 0; i < nrKeyMapping; ++i) {
            retval.fieldTableForKeys[i] = this.fieldTableForKeys[i];
            retval.fieldStreamForKeys[i] = this.fieldStreamForKeys[i];
        }
        for (i = 0; i < nrFieldMapping; ++i) {
            retval.fieldTableForFields[i] = this.fieldTableForFields[i];
            retval.fieldStreamForFields[i] = this.fieldStreamForFields[i];
            retval.insOrUptFlag[i] = this.insOrUptFlag[i];
        }
        for (i = 0; i < nrTabIsEnable; ++i) {
            retval.tabIsEnable[i] = this.tabIsEnable[i];
        }
        return retval;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            Node vnode;
            int i;
            String con = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)con);
            this.schemaName = XMLHandler.getTagValue((Node)stepnode, (String)"schema");
            this.tableName = XMLHandler.getTagValue((Node)stepnode, (String)"table");
            this.host = XMLHandler.getTagValue((Node)stepnode, (String)"host");
            this.port = XMLHandler.getTagValue((Node)stepnode, (String)"port");
            this.operation = XMLHandler.getTagValue((Node)stepnode, (String)"operation");
            this.custom_sql = XMLHandler.getTagValue((Node)stepnode, (String)"custom_sql");
            int nrKeyMapping = XMLHandler.countNodes((Node)stepnode, (String)"keys_mapping");
            int nrFieldMapping = XMLHandler.countNodes((Node)stepnode, (String)"fields_mapping");
            int nrTabIsEnable = XMLHandler.countNodes((Node)stepnode, (String)"tab_is_enable_mapping");
            this.allocate(nrKeyMapping, nrFieldMapping, nrTabIsEnable);
            for (i = 0; i < nrKeyMapping; ++i) {
                vnode = XMLHandler.getSubNodeByNr((Node)stepnode, (String)"keys_mapping", (int)i);
                this.fieldTableForKeys[i] = XMLHandler.getTagValue((Node)vnode, (String)"key_field_name");
                this.fieldStreamForKeys[i] = XMLHandler.getTagValue((Node)vnode, (String)"key_stream_name");
                if (this.fieldStreamForKeys[i] != null) continue;
                this.fieldStreamForKeys[i] = this.fieldTableForKeys[i];
            }
            for (i = 0; i < nrFieldMapping; ++i) {
                vnode = XMLHandler.getSubNodeByNr((Node)stepnode, (String)"fields_mapping", (int)i);
                this.fieldTableForFields[i] = XMLHandler.getTagValue((Node)vnode, (String)"field_field_name");
                this.fieldStreamForFields[i] = XMLHandler.getTagValue((Node)vnode, (String)"field_stream_name");
                if (this.fieldStreamForFields[i] == null) {
                    this.fieldStreamForFields[i] = this.fieldTableForFields[i];
                }
                this.insOrUptFlag[i] = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)vnode, (String)"insert_or_update_flag"));
            }
            for (i = 0; i < nrTabIsEnable; ++i) {
                vnode = XMLHandler.getSubNodeByNr((Node)stepnode, (String)"tab_is_enable_mapping", (int)i);
                this.tabIsEnable[i] = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)vnode, (String)"tab_is_enable"));
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderMeta.Exception.UnableToReadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.databaseMeta = null;
        this.schemaName = "";
        this.tableName = BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderMeta.DefaultTableName", (String[])new String[0]);
        this.host = "localhost";
        this.port = "9034";
        this.operation = "MERGE";
        this.allocate(0, 0, 0);
    }

    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    ").append(XMLHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"table", (String)this.tableName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"host", (String)this.host));
        retval.append("    ").append(XMLHandler.addTagValue((String)"port", (String)this.port));
        retval.append("    ").append(XMLHandler.addTagValue((String)"operation", (String)this.operation));
        retval.append("    ").append(XMLHandler.addTagValue((String)"custom_sql", (String)this.custom_sql));
        for (i = 0; i < this.fieldTableForKeys.length; ++i) {
            retval.append("      <keys_mapping>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"key_field_name", (String)this.fieldTableForKeys[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"key_stream_name", (String)this.fieldStreamForKeys[i]));
            retval.append("      </keys_mapping>").append(Const.CR);
        }
        for (i = 0; i < this.fieldTableForFields.length; ++i) {
            retval.append("      <fields_mapping>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"field_field_name", (String)this.fieldTableForFields[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"field_stream_name", (String)this.fieldStreamForFields[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"insert_or_update_flag", (boolean)this.insOrUptFlag[i]));
            retval.append("      </fields_mapping>").append(Const.CR);
        }
        for (i = 0; i < this.tabIsEnable.length; ++i) {
            retval.append("      <tab_is_enable_mapping>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"tab_is_enable", (boolean)this.tabIsEnable[i]));
            retval.append("      </tab_is_enable_mapping>").append(Const.CR);
        }
        return retval.toString();
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int i;
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(id_step, "id_connection", databases);
            this.schemaName = rep.getStepAttributeString(id_step, "schema");
            this.tableName = rep.getStepAttributeString(id_step, "table");
            this.host = rep.getStepAttributeString(id_step, "host");
            this.port = rep.getStepAttributeString(id_step, "port");
            this.operation = rep.getStepAttributeString(id_step, "operation");
            this.custom_sql = rep.getStepAttributeString(id_step, "custom_sql");
            int nrKeyMapping = rep.countNrStepAttributes(id_step, "key_field_name");
            int nrFieldMapping = rep.countNrStepAttributes(id_step, "field_field_name");
            int nrTabIsEnable = rep.countNrStepAttributes(id_step, "tab_is_enable_mapping");
            this.allocate(nrKeyMapping, nrFieldMapping, nrTabIsEnable);
            for (i = 0; i < nrKeyMapping; ++i) {
                this.fieldTableForKeys[i] = rep.getStepAttributeString(id_step, i, "key_field_name");
                this.fieldStreamForKeys[i] = rep.getStepAttributeString(id_step, i, "key_stream_name");
                if (this.fieldStreamForKeys[i] != null) continue;
                this.fieldStreamForKeys[i] = this.fieldTableForKeys[i];
            }
            for (i = 0; i < nrFieldMapping; ++i) {
                this.fieldTableForFields[i] = rep.getStepAttributeString(id_step, i, "field_field_name");
                this.fieldStreamForFields[i] = rep.getStepAttributeString(id_step, i, "field_stream_name");
                if (this.fieldStreamForFields[i] == null) {
                    this.fieldStreamForFields[i] = this.fieldTableForFields[i];
                }
                this.insOrUptFlag[i] = rep.getStepAttributeBoolean(id_step, i, "insert_or_update_flag");
            }
            for (i = 0; i < nrTabIsEnable; ++i) {
                this.tabIsEnable[i] = rep.getStepAttributeBoolean(id_step, i, "tab_is_enable");
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderMeta.Exception.UnexpectedErrorReadingStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta);
            rep.saveStepAttribute(id_transformation, id_step, "schema", this.schemaName);
            rep.saveStepAttribute(id_transformation, id_step, "table", this.tableName);
            rep.saveStepAttribute(id_transformation, id_step, "host", this.host);
            rep.saveStepAttribute(id_transformation, id_step, "port", this.port);
            rep.saveStepAttribute(id_transformation, id_step, "operation", this.operation);
            rep.saveStepAttribute(id_transformation, id_step, "custom_sql", this.custom_sql);
            for (i = 0; i < this.fieldTableForKeys.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "key_field_name", this.fieldTableForKeys[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "key_stream_name", this.fieldStreamForKeys[i]);
            }
            for (i = 0; i < this.fieldTableForFields.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "field_field_name", this.fieldTableForFields[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_stream_name", this.fieldStreamForFields[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "insert_or_update_flag", this.insOrUptFlag[i]);
            }
            for (i = 0; i < this.tabIsEnable.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "tab_is_enable", this.tabIsEnable[i]);
            }
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getObjectId());
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderMeta.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
    }

    public boolean isInKeys(String streamFieldName) {
        for (int i = 0; i < this.fieldStreamForKeys.length; ++i) {
            if (!streamFieldName.equals(this.fieldStreamForKeys[i])) continue;
            return true;
        }
        return false;
    }

    private String buildFakeCursorRowString(ValueMetaInterface v, String columnName) throws KettleStepException {
        StringBuffer sb = new StringBuffer();
        sb.append("CAST (null AS ");
        sb.append(this.databaseMeta.getFieldDefinition(v, null, null, false, false, false));
        sb.append(") AS " + this.databaseMeta.getStartQuote() + columnName + this.databaseMeta.getEndQuote());
        return sb.toString();
    }

    private String buildRemoteRowsCursorFromInput(RowMetaInterface prev) throws KettleStepException {
        int i;
        boolean suppress_comma = true;
        StringBuffer sb = new StringBuffer(300);
        for (i = 0; i < this.fieldStreamForKeys.length; ++i) {
            if (suppress_comma) {
                suppress_comma = false;
            } else {
                sb.append(",");
            }
            String keyStreamFieldName = this.fieldStreamForKeys[i];
            ValueMetaInterface keyStreamField = prev.searchValueMeta(this.fieldStreamForKeys[i]);
            if (keyStreamField == null) {
                throw new KettleStepException("Unable to find key field '" + keyStreamFieldName + "' in the input fields");
            }
            sb.append(this.buildFakeCursorRowString(keyStreamField, keyStreamFieldName)).append(Const.CR);
        }
        for (i = 0; i < this.fieldStreamForFields.length; ++i) {
            if (this.isInKeys(this.fieldStreamForFields[i])) continue;
            if (suppress_comma) {
                suppress_comma = false;
            } else {
                sb.append(",");
            }
            sb.append(this.buildFakeCursorRowString(prev.searchValueMeta(this.fieldStreamForFields[i]), this.fieldStreamForFields[i]) + Const.CR);
        }
        return sb.toString();
    }

    private String buildRemoteRowsFragment(RowMetaInterface prev) throws KettleStepException {
        return this.buildRemoteRowsFragment(prev, false);
    }

    private String buildRemoteRowsFragment(RowMetaInterface prev, boolean statement_alone) throws KettleStepException {
        StringBuffer fragment = new StringBuffer();
        if (!statement_alone) {
            fragment.append("(");
        }
        fragment.append("SELECT * FROM TABLE ( " + REMOTE_ROWS_UDX + "(" + Const.CR);
        fragment.append("CURSOR (SELECT ");
        fragment.append(this.buildRemoteRowsCursorFromInput(prev));
        fragment.append(" FROM (VALUES(0)))" + Const.CR);
        fragment.append(" , " + this.getPort() + Const.CR);
        fragment.append(" , false" + Const.CR);
        fragment.append(" ))");
        if (!statement_alone) {
            fragment.append(")");
        }
        if (!statement_alone) {
            fragment.append(" AS " + this.databaseMeta.getStartQuote() + SOURCE_TABLE_ALIAS + this.databaseMeta.getEndQuote());
        }
        if (this.isDebug()) {
            this.logDebug("------buildRemoteRowsFragment------ " + fragment + "-----END buildRemoteRowsFragment------");
        }
        return fragment.toString();
    }

    private String buildTargetColumnsForInsert() {
        int i;
        boolean suppress_comma = true;
        StringBuffer sb = new StringBuffer(300);
        sb.append("(");
        for (i = 0; i < this.fieldTableForKeys.length; ++i) {
            if (suppress_comma) {
                suppress_comma = false;
            } else {
                sb.append(",");
            }
            sb.append(this.databaseMeta.quoteField(this.fieldTableForKeys[i]));
        }
        for (i = 0; i < this.fieldTableForFields.length; ++i) {
            if (Const.indexOfString((String)this.fieldTableForFields[i], (String[])this.fieldTableForKeys) >= 0) continue;
            if (suppress_comma) {
                suppress_comma = false;
            } else {
                sb.append(",");
            }
            sb.append(this.databaseMeta.quoteField(this.fieldTableForFields[i]));
        }
        sb.append(")");
        return sb.toString();
    }

    private String buildSourceColumnsForInsert() {
        int i;
        boolean suppress_comma = true;
        StringBuffer sb = new StringBuffer(300);
        sb.append("(");
        for (i = 0; i < this.fieldStreamForKeys.length; ++i) {
            if (suppress_comma) {
                suppress_comma = false;
            } else {
                sb.append(",");
            }
            sb.append(this.databaseMeta.quoteField(this.fieldStreamForKeys[i]));
        }
        for (i = 0; i < this.fieldStreamForFields.length; ++i) {
            if (this.isInKeys(this.fieldStreamForFields[i])) continue;
            if (suppress_comma) {
                suppress_comma = false;
            } else {
                sb.append(",");
            }
            sb.append(this.databaseMeta.quoteField(this.fieldStreamForFields[i]));
        }
        sb.append(")");
        return sb.toString();
    }

    private String buildMatchCondition() {
        StringBuffer matchCondition = new StringBuffer(300);
        if (this.fieldStreamForKeys != null) {
            for (int i = 0; i < this.fieldStreamForKeys.length; ++i) {
                if (i > 0) {
                    matchCondition.append(Const.CR + "AND ");
                }
                matchCondition.append(this.databaseMeta.quoteField(SOURCE_TABLE_ALIAS));
                matchCondition.append(".");
                matchCondition.append(this.databaseMeta.quoteField(this.fieldStreamForKeys[i]));
                matchCondition.append(" = ");
                matchCondition.append(this.databaseMeta.quoteField(TARGET_TABLE_ALIAS));
                matchCondition.append(".");
                matchCondition.append(this.databaseMeta.quoteField(this.fieldTableForKeys[i]));
                matchCondition.append(Const.CR);
            }
        }
        return matchCondition.toString();
    }

    private String buildMergeSetString() {
        boolean suppress_comma = true;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.fieldStreamForFields.length; ++i) {
            if (!this.insOrUptFlag[i]) continue;
            if (suppress_comma) {
                suppress_comma = false;
            } else {
                sb.append(",");
            }
            sb.append(this.databaseMeta.quoteField(this.fieldTableForFields[i]));
            sb.append(" = ");
            sb.append(this.databaseMeta.quoteField(SOURCE_TABLE_ALIAS)).append(".");
            sb.append(this.databaseMeta.quoteField(this.fieldStreamForFields[i]));
        }
        return sb.toString();
    }

    private String buildTargetTableString(VariableSpace space) {
        return this.databaseMeta.getQuotedSchemaTableCombination(space.environmentSubstitute(this.getSchemaName()), space.environmentSubstitute(this.getTableName()));
    }

    public String getDMLStatement(VariableSpace space, RowMetaInterface prev) throws KettleStepException {
        if (this.operation.equals(OPERATION_INSERT)) {
            StringBuffer insert = new StringBuffer();
            insert.append("INSERT INTO " + Const.CR);
            insert.append(this.buildTargetTableString(space) + Const.CR);
            insert.append(this.buildTargetColumnsForInsert() + Const.CR);
            insert.append(this.buildRemoteRowsFragment(prev, true));
            if (this.isDebug()) {
                this.logDebug("-----INSERT----" + insert + "-----END INSERT-----");
            }
            return insert.toString();
        }
        if (this.operation.equals(OPERATION_MERGE) || this.operation.equals(OPERATION_UPDATE)) {
            StringBuffer merge = new StringBuffer();
            merge.append("MERGE INTO " + this.buildTargetTableString(space));
            merge.append(" as " + this.databaseMeta.quoteField(TARGET_TABLE_ALIAS) + Const.CR);
            merge.append("USING " + this.buildRemoteRowsFragment(prev) + Const.CR);
            merge.append("ON " + this.buildMatchCondition() + Const.CR);
            merge.append("WHEN MATCHED THEN UPDATE SET " + Const.CR);
            merge.append(this.buildMergeSetString() + Const.CR);
            if (this.operation.equals(OPERATION_MERGE)) {
                merge.append("WHEN NOT MATCHED THEN " + Const.CR);
                merge.append("INSERT " + this.buildTargetColumnsForInsert() + Const.CR);
                merge.append("VALUES " + this.buildSourceColumnsForInsert() + Const.CR);
            }
            if (this.isDebug()) {
                this.logDebug("-----MERGE or UPDATE----" + merge + "-----END MERGE or UPDATE-----");
            }
            return merge.toString();
        }
        if (this.operation.equals(OPERATION_CUSTOM)) {
            String custom = this.getCustom_sql().replace("?", this.buildRemoteRowsFragment(prev, true));
            if (this.isDebug()) {
                this.logDebug("-----CUSTOM----" + custom + "-----END CUSTOM-----");
            }
            return custom.toString();
        }
        return "ERRORSQLSTATEMENT";
    }

    public String getCreateTableAsStatement(RowMetaInterface prev) throws KettleStepException {
        StringBuffer sb = new StringBuffer();
        sb.append("CALL APPLIB.CREATE_TABLE_AS (" + Const.CR);
        sb.append("'" + this.getSchemaName() + "'" + Const.CR);
        sb.append(",'" + this.getTableName() + "'" + Const.CR);
        sb.append(",'" + this.buildRemoteRowsFragment(prev) + "'" + Const.CR);
        sb.append(", false )");
        return sb.toString();
    }

    public void analyseImpact(List<DatabaseImpact> impact, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, Repository repository, IMetaStore metaStore) throws KettleStepException {
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new LucidDBStreamingLoader(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new LucidDBStreamingLoaderData();
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RowMetaInterface getRequiredFields(VariableSpace space) throws KettleException {
        String realTableName = space.environmentSubstitute(this.tableName);
        String realSchemaName = space.environmentSubstitute(this.schemaName);
        if (this.databaseMeta == null) throw new KettleException(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderMeta.Exception.ConnectionNotDefined", (String[])new String[0]));
        Database db = new Database(loggingObject, this.databaseMeta);
        try {
            db.connect();
            if (Utils.isEmpty((CharSequence)realTableName)) throw new KettleException(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderMeta.Exception.TableNotSpecified", (String[])new String[0]));
            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(realSchemaName, realTableName);
            if (db.checkTableExists(schemaTable)) {
                RowMetaInterface rowMetaInterface = db.getTableFields(schemaTable);
                return rowMetaInterface;
            }
            try {
                throw new KettleException(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderMeta.Exception.TableNotFound", (String[])new String[0]));
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderMeta.Exception.ErrorGettingFields", (String[])new String[0]), (Throwable)e);
            }
        }
        finally {
            db.disconnect();
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public boolean[] getInsOrUptFlag() {
        return this.insOrUptFlag;
    }

    public void setInsOrUptFlag(boolean[] insOrUptFlag) {
        this.insOrUptFlag = insOrUptFlag;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String[] getFieldStreamForFields() {
        return this.fieldStreamForFields;
    }

    public void setFieldStreamForFields(String[] fieldStreamForFields) {
        this.fieldStreamForFields = fieldStreamForFields;
    }

    public String[] getFieldStreamForKeys() {
        return this.fieldStreamForKeys;
    }

    public void setFieldStreamForKeys(String[] fieldStreamForKeys) {
        this.fieldStreamForKeys = fieldStreamForKeys;
    }

    public String[] getFieldTableForFields() {
        return this.fieldTableForFields;
    }

    public void setFieldTableForFields(String[] fieldTableForFields) {
        this.fieldTableForFields = fieldTableForFields;
    }

    public String[] getFieldTableForKeys() {
        return this.fieldTableForKeys;
    }

    public void setFieldTableForKeys(String[] fieldTableForKeys) {
        this.fieldTableForKeys = fieldTableForKeys;
    }

    public String getCustom_sql() {
        return this.custom_sql;
    }

    public void setCustom_sql(String custom_sql) {
        this.custom_sql = custom_sql;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, Repository repository, IMetaStore metaStore) throws KettleStepException {
        SQLStatement retval = super.getSQLStatements(transMeta, stepMeta, prev, repository, metaStore);
        if (this.databaseMeta != null) {
            if (prev != null && prev.size() > 0) {
                String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(transMeta.environmentSubstitute(this.schemaName), transMeta.environmentSubstitute(this.tableName));
                if (!Utils.isEmpty((CharSequence)schemaTable)) {
                    Database db = new Database(loggingObject, this.databaseMeta);
                    db.shareVariablesWith((VariableSpace)transMeta);
                    try {
                        db.connect();
                        String cr_table = db.getDDL(schemaTable, prev);
                        if (cr_table == null || cr_table.length() == 0) {
                            cr_table = null;
                        }
                        retval.setSQL(cr_table);
                    }
                    catch (KettleDatabaseException dbe) {
                        retval.setError(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderMeta.Error.ErrorConnecting", (String[])new String[]{dbe.getMessage()}));
                    }
                    finally {
                        db.disconnect();
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderMeta.Error.NoTable", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderMeta.Error.NoInput", (String[])new String[0]));
            }
        } else {
            retval.setError(BaseMessages.getString(PKG, (String)"LucidDBStreamingLoaderMeta.Error.NoConnection", (String[])new String[0]));
        }
        return retval;
    }
}

