/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.client;

import com.google.common.base.Supplier;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.pentaho.di.core.annotations.LifecyclePlugin;
import org.pentaho.di.core.lifecycle.LifeEventHandler;
import org.pentaho.di.core.lifecycle.LifecycleException;
import org.pentaho.di.core.lifecycle.LifecycleListener;
import org.pentaho.di.trans.dataservice.client.DataServiceClientService;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.metastore.api.IMetaStore;

@LifecyclePlugin(id="SpoonDataServiceLocalClientConfigurer")
public class SpoonDataServiceLocalClientConfigurer
implements LifecycleListener {
    private final Supplier<Spoon> spoonSupplier;
    private final AtomicReference<DataServiceClientService> dataServiceClientService = new AtomicReference();
    private final AtomicBoolean enabled = new AtomicBoolean(false);

    public SpoonDataServiceLocalClientConfigurer() {
        this(new Supplier<Spoon>(){

            public Spoon get() {
                return Spoon.getInstance();
            }
        });
    }

    public SpoonDataServiceLocalClientConfigurer(Supplier<Spoon> spoonSupplier) {
        this.spoonSupplier = spoonSupplier;
    }

    public void bind(DataServiceClientService service) {
        this.dataServiceClientService.set(service);
        this.setup(service);
    }

    public void unbind(DataServiceClientService service) {
        this.dataServiceClientService.set(null);
        this.setup(null);
    }

    public void onStart(LifeEventHandler handler) throws LifecycleException {
        if (this.enabled.compareAndSet(false, true)) {
            this.setup(this.dataServiceClientService.get());
        }
    }

    public void onExit(LifeEventHandler handler) throws LifecycleException {
        if (this.enabled.compareAndSet(true, false)) {
            this.setup(this.dataServiceClientService.get());
        }
    }

    private synchronized void setup(DataServiceClientService clientService) {
        if (this.enabled.get() && clientService != null) {
            Spoon spoon = (Spoon)this.spoonSupplier.get();
            clientService.setRepository(spoon.getRepository());
            clientService.setMetaStore((IMetaStore)spoon.getMetaStore());
        }
    }
}

