/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.jdbc;

import java.io.DataInputStream;
import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.trans.dataservice.client.DataServiceClientService;
import org.pentaho.di.trans.dataservice.jdbc.BaseResultSet;
import org.pentaho.di.trans.dataservice.jdbc.ThinDriver;
import org.pentaho.di.trans.dataservice.jdbc.ThinResultHeader;
import org.pentaho.di.trans.dataservice.jdbc.ThinResultSetMetaData;

public class ThinResultSet
extends BaseResultSet {
    private final ThinResultHeader thinResultHeader;
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private DataInputStream dataInputStream;
    private DataServiceClientService client;
    private int size = 1;

    public ThinResultSet(ThinResultHeader header, DataInputStream dataInputStream, DataServiceClientService client) {
        super(header.getRowMeta());
        this.thinResultHeader = header;
        this.dataInputStream = dataInputStream;
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        block10: {
            try {
                String id;
                if (this.dataInputStream != null) {
                    this.dataInputStream.close();
                }
                if (!this.stopped.compareAndSet(false, true) || Const.isEmpty((String)(id = this.thinResultHeader.getServiceObjectId()))) break block10;
                Boolean hasErrors = false;
                try (DataInputStream errorInputStream = this.client.query("[ errors " + this.thinResultHeader.getServiceObjectId() + " ]", 0);){
                    hasErrors = "true".equals(errorInputStream.readUTF());
                }
                DataInputStream stopInputStream = this.client.query("[ stop " + this.thinResultHeader.getServiceObjectId() + " ]", 0);
                stopInputStream.close();
                if (hasErrors.booleanValue()) {
                    throw new SQLException("An error occurred while processing request.");
                }
            }
            catch (IOException e) {
                ThinDriver.logger.warning(e.getMessage());
            }
            finally {
                this.dataInputStream = null;
            }
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.thinResultHeader.getServiceName();
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException("Only FETCH_FORWARD is allowed");
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchSize(int direction) throws SQLException {
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new ThinResultSetMetaData(this.thinResultHeader.getServiceName(), this.getRowMeta());
    }

    public ThinResultHeader getHeader() {
        return this.thinResultHeader;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.dataInputStream == null;
    }

    @Override
    protected Object[] retrieveRow(int i) throws Exception {
        if (this.isAfterLast() ? i > this.size() : i == this.getRow()) {
            return this.getCurrentRow();
        }
        if (i == this.getRow() + 1) {
            return this.readData();
        }
        throw new SQLFeatureNotSupportedException("Scrollable result sets are not supported");
    }

    private Object[] readData() throws KettleFileException, SQLException, IOException {
        try {
            Object[] data = this.getRowMeta().readData(this.dataInputStream);
            ++this.size;
            return data;
        }
        catch (KettleFileException e) {
            this.size = this.getRow();
            if (!this.isClosed()) {
                this.dataInputStream.close();
            }
            return null;
        }
    }

    @Override
    protected int size() throws SQLException {
        return this.size;
    }
}

