/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.jdbc;

import java.io.DataInputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import org.pentaho.di.trans.dataservice.jdbc.ThinBase;
import org.pentaho.di.trans.dataservice.jdbc.ThinConnection;
import org.pentaho.di.trans.dataservice.jdbc.ThinResultFactory;
import org.pentaho.di.trans.dataservice.jdbc.ThinResultSet;
import org.pentaho.di.trans.dataservice.jdbc.annotation.NotSupported;

public class ThinStatement
extends ThinBase
implements Statement {
    protected final ThinConnection connection;
    private final ThinResultFactory resultFactory;
    private ThinResultSet resultSet;
    protected int maxRows = -1;

    public ThinStatement(ThinConnection connection) {
        this(connection, new ThinResultFactory());
    }

    protected ThinStatement(ThinConnection connection, ThinResultFactory resultFactory) {
        this.connection = connection;
        this.resultFactory = resultFactory;
        this.connection.registerStatement(this);
    }

    @Override
    @NotSupported
    public void addBatch(String arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException("Batches not supported");
    }

    @Override
    public void cancel() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        this.connection.unregisterStatement(this);
    }

    @Override
    @NotSupported
    public void clearBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException("Batch update statements are not supported by the thin Kettle JDBC driver");
    }

    @Override
    public void close() throws SQLException {
        this.cancel();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.executeQuery(sql) != null;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeQuery(sql) != null;
    }

    @Override
    public boolean execute(String sql, int[] arg1) throws SQLException {
        return this.executeQuery(sql) != null;
    }

    @Override
    public boolean execute(String sql, String[] arg1) throws SQLException {
        return this.executeQuery(sql) != null;
    }

    @Override
    @NotSupported
    public int[] executeBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException("Batch update statements are not supported by the thin Kettle JDBC driver");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        DataInputStream dataInputStream = this.connection.getClientService().query(sql, this.maxRows);
        this.resultSet = this.resultFactory.loadResultSet(dataInputStream, this.connection.getClientService());
        this.resultSet.setStatement(this);
        return this.resultSet;
    }

    @Override
    @NotSupported
    public int executeUpdate(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("The thin Kettle JDBC driver is read-only");
    }

    @Override
    @NotSupported
    public int executeUpdate(String sql, int arg1) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    @NotSupported
    public int executeUpdate(String sql, int[] arg1) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    @NotSupported
    public int executeUpdate(String sql, String[] arg1) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 1;
    }

    @Override
    @NotSupported
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException("The thin Kettle JDBC driver is read-only");
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.resultSet == null) {
            throw new SQLException("Statement is closed.");
        }
        if (this.resultSet.isLast() || this.resultSet.isClosed()) {
            this.resultSet.close();
            return false;
        }
        return true;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (current != 1) {
            throw new SQLFeatureNotSupportedException("Multiple open result sets not supported");
        }
        return this.getMoreResults();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.resultSet.getConcurrency();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.resultSet.getHoldability();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.resultSet.getType();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.resultSet.isClosed();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    @NotSupported
    public void setCursorName(String arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException("Named cursors not supported");
    }

    @Override
    public void setEscapeProcessing(boolean arg0) throws SQLException {
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException("Only FETCH_FORWARD direction is supported");
        }
    }

    @Override
    public void setFetchSize(int arg0) throws SQLException {
    }

    @Override
    public void setMaxFieldSize(int arg0) throws SQLException {
    }

    @Override
    public void setPoolable(boolean arg0) throws SQLException {
    }

    @Override
    public void setQueryTimeout(int arg0) throws SQLException {
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }
}

