/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repo;

import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.ui.core.database.dialog.DatabaseDialog;
import org.pentaho.di.ui.core.dialog.ThinDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.repo.RepositoryConnectController;
import org.pentaho.di.ui.repo.RepositoryConnectMenu;
import org.pentaho.di.ui.util.HelpUtils;
import org.pentaho.platform.settings.ServerPort;
import org.pentaho.platform.settings.ServerPortRegistry;

public class RepositoryDialog
extends ThinDialog {
    private LogChannelInterface log = KettleLogStore.getLogChannelInterfaceFactory().create(RepositoryDialog.class);
    private static Class<?> PKG = RepositoryConnectMenu.class;
    public static final String HELP_URL = Const.getDocUrl((String)BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.Help", (String[])new String[0]));
    private static final int WIDTH = 630;
    private static final int HEIGHT = 630;
    private static final int OPTIONS = 67680;
    private static final String CREATION_TITLE = BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.NewRepo.Title", (String[])new String[0]);
    private static final String CREATION_WEB_CLIENT_PATH = "/repositories/web/index.html";
    private static final String MANAGER_TITLE = BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.Manager.Title", (String[])new String[0]);
    private static final String MANAGER_WEB_CLIENT_PATH = "/repositories/web/index.html#repository-manager";
    private static final String LOGIN_TITLE = BaseMessages.getString(PKG, (String)"RepositoryDialog.Dialog.Login.Title", (String[])new String[0]);
    private static final String LOGIN_WEB_CLIENT_PATH = "/repositories/web/index.html#repository-connect";
    private static final String OSGI_SERVICE_PORT = "OSGI_SERVICE_PORT";
    private static final Image LOGO = GUIResource.getInstance().getImageLogoSmall();
    private RepositoryConnectController controller;
    private Shell shell;
    private boolean result = false;

    public RepositoryDialog(Shell shell, RepositoryConnectController controller) {
        super(shell, 630, 630);
        this.controller = controller;
        this.shell = shell;
    }

    private boolean open() {
        return this.open(null);
    }

    private boolean open(RepositoryMeta repositoryMeta) {
        return this.open(repositoryMeta, false, null);
    }

    private boolean open(RepositoryMeta repositoryMeta, boolean relogin, final String errorMessage) {
        new BrowserFunction(this.browser, "close"){

            public Object function(Object[] arguments) {
                RepositoryDialog.this.browser.dispose();
                RepositoryDialog.this.dialog.close();
                RepositoryDialog.this.dialog.dispose();
                return true;
            }
        };
        new BrowserFunction(this.browser, "setResult"){

            public Object function(Object[] arguments) {
                RepositoryDialog.this.setResult((Boolean)arguments[0]);
                return true;
            }
        };
        new BrowserFunction(this.browser, "getErrorMessage"){

            public Object function(Object[] objects) {
                return errorMessage == null ? "" : errorMessage;
            }
        };
        new BrowserFunction(this.browser, "help"){

            public Object function(Object[] objects) {
                HelpUtils.openHelpDialog((Shell)RepositoryDialog.this.shell, (String)BaseMessages.getString((Class)PKG, (String)"RepositoryDialog.Dialog.Tile", (String[])new String[0]), (String)HELP_URL, (String)BaseMessages.getString((Class)PKG, (String)"RepositoryDialog.Dialog.Header", (String[])new String[0]));
                return true;
            }
        };
        new BrowserFunction(this.browser, "getRepositories"){

            public Object function(Object[] objects) {
                return RepositoryDialog.this.controller.getRepositories();
            }
        };
        new BrowserFunction(this.browser, "getRepositoryTypes"){

            public Object function(Object[] objects) {
                return RepositoryDialog.this.controller.getPlugins();
            }
        };
        new BrowserFunction(this.browser, "deleteRepository"){

            public Object function(Object[] objects) {
                return RepositoryDialog.this.controller.deleteRepository((String)objects[0]);
            }
        };
        new BrowserFunction(this.browser, "selectLocation"){

            public Object function(Object[] objects) {
                DirectoryDialog directoryDialog = new DirectoryDialog(RepositoryDialog.this.shell);
                return directoryDialog.open();
            }
        };
        new BrowserFunction(this.browser, "connectToRepository"){

            public Object function(Object[] objects) {
                try {
                    RepositoryDialog.this.controller.connectToRepository();
                    RepositoryDialog.this.dialog.dispose();
                }
                catch (KettleException e) {
                    return false;
                }
                return true;
            }
        };
        new BrowserFunction(this.browser, "setDefaultRepository"){

            public Object function(Object[] objects) {
                return RepositoryDialog.this.controller.setDefaultRepository((String)objects[0]);
            }
        };
        new BrowserFunction(this.browser, "getDatabases"){

            public Object function(Object[] objects) {
                return RepositoryDialog.this.controller.getDatabases();
            }
        };
        new BrowserFunction(this.browser, "createNewConnection"){

            public Object function(Object[] objects) {
                DatabaseDialog databaseDialog = new DatabaseDialog(RepositoryDialog.this.shell, new DatabaseMeta());
                databaseDialog.open();
                DatabaseMeta databaseMeta = databaseDialog.getDatabaseMeta();
                if (databaseMeta != null) {
                    if (!RepositoryDialog.this.controller.isDatabaseWithNameExist(databaseMeta, true)) {
                        RepositoryDialog.this.controller.addDatabase(databaseMeta);
                        return true;
                    }
                    DatabaseDialog.showDatabaseExistsDialog((Shell)RepositoryDialog.this.shell, (DatabaseMeta)databaseMeta);
                }
                return false;
            }
        };
        new BrowserFunction(this.browser, "editDatabaseConnection"){

            public Object function(Object[] objects) {
                DatabaseMeta databaseMeta = RepositoryDialog.this.controller.getDatabase((String)objects[0]);
                String originalName = databaseMeta.getName();
                DatabaseDialog databaseDialog = new DatabaseDialog(RepositoryDialog.this.shell, databaseMeta);
                databaseDialog.open();
                if (!RepositoryDialog.this.controller.isDatabaseWithNameExist(databaseMeta, false)) {
                    RepositoryDialog.this.controller.save();
                    return databaseMeta.getName();
                }
                DatabaseDialog.showDatabaseExistsDialog((Shell)RepositoryDialog.this.shell, (DatabaseMeta)databaseMeta);
                databaseMeta.setName(originalName);
                databaseMeta.setDisplayName(originalName);
                return originalName;
            }
        };
        new BrowserFunction(this.browser, "deleteDatabaseConnection"){

            public Object function(Object[] objects) {
                RepositoryDialog.this.controller.removeDatabase((String)objects[0]);
                return true;
            }
        };
        new BrowserFunction(this.browser, "reset"){

            public Object function(Object[] objects) {
                RepositoryDialog.this.controller.setCurrentRepository(null);
                RepositoryDialog.this.controller.setRelogin(false);
                return true;
            }
        };
        new BrowserFunction(this.browser, "getCurrentUser"){

            public Object function(Object[] objects) {
                return RepositoryDialog.this.controller.getCurrentUser();
            }
        };
        new BrowserFunction(this.browser, "getCurrentRepository"){

            public Object function(Object[] objects) {
                return RepositoryDialog.this.controller.getCurrentRepository() != null ? RepositoryDialog.this.controller.getCurrentRepository().getName() : "";
            }
        };
        new BrowserFunction(this.browser, "getDefaultUrl"){

            public Object function(Object[] objects) {
                return RepositoryDialog.this.controller.getDefaultUrl();
            }
        };
        new BrowserFunction(this.browser, "loadRepository"){

            public Object function(Object[] objects) {
                return RepositoryDialog.this.controller.getRepository((String)objects[0]);
            }
        };
        new BrowserFunction(this.browser, "getConnectedRepositoryName"){

            public Object function(Object[] objects) {
                return RepositoryDialog.this.controller.getConnectedRepository() != null ? RepositoryDialog.this.controller.getConnectedRepository().getName() : "";
            }
        };
        this.controller.setCurrentRepository(repositoryMeta);
        this.controller.setRelogin(relogin);
        while (!this.dialog.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        return this.result;
    }

    public void openManager() {
        super.createDialog(MANAGER_TITLE, RepositoryDialog.getRepoURL(MANAGER_WEB_CLIENT_PATH), 67680, LOGO);
        this.open();
    }

    public void openCreation() {
        super.createDialog(CREATION_TITLE, RepositoryDialog.getRepoURL(CREATION_WEB_CLIENT_PATH), 67680, LOGO);
        this.open();
    }

    public boolean openRelogin(RepositoryMeta repositoryMeta, String errorMessage) {
        super.createDialog(LOGIN_TITLE, RepositoryDialog.getRepoURL(LOGIN_WEB_CLIENT_PATH), 67680, LOGO);
        return this.open(repositoryMeta, true, errorMessage);
    }

    public boolean openLogin(RepositoryMeta repositoryMeta) {
        super.createDialog(LOGIN_TITLE, RepositoryDialog.getRepoURL(LOGIN_WEB_CLIENT_PATH), 67680, LOGO);
        return this.open(repositoryMeta);
    }

    private void setResult(boolean result) {
        this.result = result;
    }

    private static Integer getOsgiServicePort() {
        ServerPort osgiServicePort = ServerPortRegistry.getPort((String)OSGI_SERVICE_PORT);
        if (osgiServicePort != null) {
            return osgiServicePort.getAssignedPort();
        }
        return null;
    }

    private static String getRepoURL(String path) {
        return "http://localhost:" + RepositoryDialog.getOsgiServicePort() + path;
    }
}

