/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repo;

import org.pentaho.di.core.LastUsedFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.ui.repo.RepositoryConnectController;
import org.pentaho.di.ui.repo.RepositoryDialog;
import org.pentaho.di.ui.spoon.Spoon;

@ExtensionPoint(id="RepositoryOpenRecentExtensionPoint", extensionPointId="OpenRecent", description="Do or display login for default repository")
public class RepositoryOpenRecentFileExtensionPoint
implements ExtensionPointInterface {
    private RepositoryConnectController repositoryConnectController;

    public RepositoryOpenRecentFileExtensionPoint(RepositoryConnectController repositoryConnectController) {
        this.repositoryConnectController = repositoryConnectController;
    }

    public void callExtensionPoint(LogChannelInterface log, Object object) throws KettleException {
        RepositoryMeta repositoryMeta;
        if (!(object instanceof LastUsedFile)) {
            return;
        }
        LastUsedFile recentFile = (LastUsedFile)object;
        if (recentFile.isSourceRepository() && !this.repositoryConnectController.isConnected(recentFile.getRepositoryName()) && this.getSpoon().promptForSave() && (repositoryMeta = this.repositoryConnectController.getRepositoryMetaByName(recentFile.getRepositoryName())) != null) {
            if (repositoryMeta.getId().equals("KettleFileRepository")) {
                this.getSpoon().closeRepository();
                this.repositoryConnectController.connectToRepository(repositoryMeta);
            } else {
                new RepositoryDialog(this.getSpoon().getShell(), this.repositoryConnectController).openLogin(repositoryMeta);
            }
            if (this.repositoryConnectController.isConnected(repositoryMeta.getName())) {
                this.getSpoon().loadLastUsedFile(recentFile, repositoryMeta.getName());
                this.getSpoon().addMenuLast();
            }
        }
    }

    private Spoon getSpoon() {
        return Spoon.getInstance();
    }
}

