/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.api.remote;

import java.io.Serializable;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.pentaho.di.engine.api.model.Transformation;
import org.pentaho.di.engine.api.remote.Message;
import org.pentaho.di.engine.api.reporting.LogLevel;

public final class ExecutionRequest
implements Message {
    private static final long serialVersionUID = -7835121168360407191L;
    private final String requestId = UUID.randomUUID().toString();
    private final Map<String, Object> parameters;
    private final Map<String, Object> environment;
    private final Transformation transformation;
    private final Map<String, Set<Class<? extends Serializable>>> reportingTopics;
    private final Principal actingPrincipal;
    private LogLevel loggingLogLevel;

    public ExecutionRequest(Map<String, Object> parameters, Map<String, Object> environment, Transformation transformation, Map<String, Set<Class<? extends Serializable>>> reportingTopics, LogLevel loggingLogLevel, Principal actingPrincipal) {
        this.parameters = parameters;
        this.environment = environment;
        this.transformation = transformation;
        this.reportingTopics = reportingTopics;
        this.loggingLogLevel = loggingLogLevel;
        this.actingPrincipal = actingPrincipal;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Map<String, Object> getEnvironment() {
        return this.environment;
    }

    public Transformation getTransformation() {
        return this.transformation;
    }

    public Map<String, Set<Class<? extends Serializable>>> getReportingTopics() {
        return this.reportingTopics;
    }

    public Principal getActingPrincipal() {
        return this.actingPrincipal;
    }

    public LogLevel getLoggingLogLevel() {
        return this.loggingLogLevel;
    }
}

