/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.logical;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexWindow;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogicalWindow
extends Window {
    public LogicalWindow(RelOptCluster cluster, RelTraitSet traits, RelNode child, List<RexLiteral> constants, RelDataType rowType, List<Window.Group> groups) {
        super(cluster, traits, child, constants, rowType, groups);
    }

    @Override
    public LogicalWindow copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new LogicalWindow(this.getCluster(), traitSet, LogicalWindow.sole(inputs), this.constants, this.rowType, (List<Window.Group>)this.groups);
    }

    public static RelNode create(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexProgram program) {
        RelDataType outRowType = program.getOutputRowType();
        LinkedListMultimap windowMap = LinkedListMultimap.create();
        final int inputFieldCount = child.getRowType().getFieldCount();
        final HashMap constantPool = new HashMap();
        final ArrayList<RexLiteral> constants = new ArrayList<RexLiteral>();
        RexShuttle replaceConstants = new RexShuttle(){

            public RexNode visitLiteral(RexLiteral literal) {
                RexInputRef ref = (RexInputRef)constantPool.get(literal);
                if (ref != null) {
                    return ref;
                }
                constants.add(literal);
                ref = new RexInputRef(constantPool.size() + inputFieldCount, literal.getType());
                constantPool.put(literal, ref);
                return ref;
            }
        };
        for (RexNode agg : program.getExprList()) {
            if (!(agg instanceof RexOver)) continue;
            RexOver over = (RexOver)agg;
            over = (RexOver)over.accept(replaceConstants);
            LogicalWindow.addWindows((Multimap<WindowKey, RexOver>)windowMap, over, inputFieldCount);
        }
        final HashMap<RexOver, Window.RexWinAggCall> aggMap = new HashMap<RexOver, Window.RexWinAggCall>();
        ArrayList<Window.Group> groups = new ArrayList<Window.Group>();
        for (Map.Entry entry : windowMap.asMap().entrySet()) {
            WindowKey windowKey = (WindowKey)entry.getKey();
            ArrayList<Window.RexWinAggCall> aggCalls = new ArrayList<Window.RexWinAggCall>();
            for (RexOver over : (Collection)entry.getValue()) {
                Window.RexWinAggCall aggCall = new Window.RexWinAggCall(over.getAggOperator(), over.getType(), LogicalWindow.toInputRefs((List<? extends RexNode>)over.operands), aggMap.size());
                aggCalls.add(aggCall);
                aggMap.put(over, aggCall);
            }
            RexShuttle toInputRefs = new RexShuttle(){

                public RexNode visitLocalRef(RexLocalRef localRef) {
                    return new RexInputRef(localRef.getIndex(), localRef.getType());
                }
            };
            groups.add(new Window.Group(windowKey.groupSet, windowKey.isRows, windowKey.lowerBound.accept(toInputRefs), windowKey.upperBound.accept(toInputRefs), windowKey.orderKeys, aggCalls));
        }
        final ArrayList<Object> flattenedAggCallList = new ArrayList<Object>();
        ArrayList<RelDataTypeField> fieldList = new ArrayList<RelDataTypeField>(child.getRowType().getFieldList());
        int offset = fieldList.size();
        HashMap<Integer, String> fieldNames = new HashMap<Integer, String>();
        for (Ord ref : Ord.zip(program.getProjectList())) {
            int index = ((RexLocalRef)ref.e).getIndex();
            if (index < offset) continue;
            fieldNames.put(index - offset, outRowType.getFieldNames().get(ref.i));
        }
        for (Ord window : Ord.zip(groups)) {
            for (Ord over : Ord.zip(((Window.Group)window.e).aggCalls)) {
                String name = (String)fieldNames.get(over.i);
                if (name == null || name.startsWith("$")) {
                    name = "w" + window.i + "$o" + over.i;
                }
                fieldList.add((RelDataTypeField)((Object)Pair.of(name, ((Window.RexWinAggCall)over.e).getType())));
                flattenedAggCallList.add(over.e);
            }
        }
        final RelDataType intermediateRowType = cluster.getTypeFactory().createStructType(fieldList);
        RexShuttle shuttle = new RexShuttle(){

            public RexNode visitOver(RexOver over) {
                Window.RexWinAggCall aggCall = (Window.RexWinAggCall)aggMap.get(over);
                assert (aggCall != null);
                assert (RelOptUtil.eq("over", over.getType(), "aggCall", aggCall.getType(), true));
                int aggCallIndex = flattenedAggCallList.indexOf(aggCall);
                assert (aggCallIndex >= 0);
                int index = inputFieldCount + aggCallIndex;
                assert (RelOptUtil.eq("over", over.getType(), "intermed", intermediateRowType.getFieldList().get(index).getType(), true));
                return new RexInputRef(index, over.getType());
            }

            public RexNode visitLocalRef(RexLocalRef localRef) {
                int index = localRef.getIndex();
                if (index < inputFieldCount) {
                    return localRef;
                }
                return new RexLocalRef(flattenedAggCallList.size() + index, localRef.getType());
            }
        };
        LogicalWindow window = new LogicalWindow(cluster, traitSet, child, constants, intermediateRowType, groups);
        return RelOptUtil.createProject((RelNode)window, LogicalWindow.toInputRefs(program.getProjectList()), outRowType.getFieldNames());
    }

    private static List<RexNode> toInputRefs(final List<? extends RexNode> operands) {
        return new AbstractList<RexNode>(){

            @Override
            public int size() {
                return operands.size();
            }

            @Override
            public RexNode get(int index) {
                RexNode operand = (RexNode)operands.get(index);
                if (operand instanceof RexInputRef) {
                    return operand;
                }
                assert (operand instanceof RexLocalRef);
                RexLocalRef ref = (RexLocalRef)operand;
                return new RexInputRef(ref.getIndex(), ref.getType());
            }
        };
    }

    private static void addWindows(Multimap<WindowKey, RexOver> windowMap, RexOver over, int inputFieldCount) {
        RexWindow aggWindow = over.getWindow();
        RelCollation orderKeys = LogicalWindow.getCollation(Lists.newArrayList((Iterable)Iterables.filter(aggWindow.orderKeys, (Predicate)new Predicate<RexFieldCollation>(){

            public boolean apply(RexFieldCollation rexFieldCollation) {
                return rexFieldCollation.left instanceof RexLocalRef;
            }
        })));
        ImmutableBitSet groupSet = ImmutableBitSet.of(LogicalWindow.getProjectOrdinals(aggWindow.partitionKeys));
        int groupLength = groupSet.length();
        if (inputFieldCount < groupLength) {
            groupSet = groupSet.except(ImmutableBitSet.range(inputFieldCount, groupLength));
        }
        WindowKey windowKey = new WindowKey(groupSet, orderKeys, aggWindow.isRows(), aggWindow.getLowerBound(), aggWindow.getUpperBound());
        windowMap.put((Object)windowKey, (Object)over);
    }

    private static class WindowKey {
        private final ImmutableBitSet groupSet;
        private final RelCollation orderKeys;
        private final boolean isRows;
        private final RexWindowBound lowerBound;
        private final RexWindowBound upperBound;

        public WindowKey(ImmutableBitSet groupSet, RelCollation orderKeys, boolean isRows, RexWindowBound lowerBound, RexWindowBound upperBound) {
            this.groupSet = groupSet;
            this.orderKeys = orderKeys;
            this.isRows = isRows;
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.groupSet, this.orderKeys, this.isRows, this.lowerBound, this.upperBound});
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof WindowKey && this.groupSet.equals(((WindowKey)obj).groupSet) && this.orderKeys.equals(((WindowKey)obj).orderKeys) && Objects.equal((Object)this.lowerBound, (Object)((WindowKey)obj).lowerBound) && Objects.equal((Object)this.upperBound, (Object)((WindowKey)obj).upperBound) && this.isRows == ((WindowKey)obj).isRows;
        }
    }
}

