/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.webresources.AbstractArchiveResourceSet;
import org.apache.catalina.webresources.JarWarResource;
import org.apache.tomcat.util.buf.UriUtil;

public class JarWarResourceSet
extends AbstractArchiveResourceSet {
    private final String archivePath;

    public JarWarResourceSet(WebResourceRoot root, String webAppMount, String base, String archivePath, String internalPath) throws IllegalArgumentException {
        this.setRoot(root);
        this.setWebAppMount(webAppMount);
        this.setBase(base);
        this.archivePath = archivePath;
        this.setInternalPath(internalPath);
        if (this.getRoot().getState().isAvailable()) {
            try {
                this.start();
            }
            catch (LifecycleException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    protected WebResource createArchiveResource(JarEntry jarEntry, String webAppPath, Manifest manifest) {
        return new JarWarResource(this, webAppPath, this.getBaseUrlString(), jarEntry, this.archivePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HashMap<String, JarEntry> getArchiveEntries(boolean single) {
        Object object = this.archiveLock;
        synchronized (object) {
            if (this.archiveEntries == null) {
                JarFile warFile = null;
                InputStream jarFileIs = null;
                this.archiveEntries = new HashMap();
                try {
                    warFile = this.openJarFile();
                    JarEntry jarFileInWar = warFile.getJarEntry(this.archivePath);
                    jarFileIs = warFile.getInputStream(jarFileInWar);
                    try (JarInputStream jarIs = new JarInputStream(jarFileIs);){
                        JarEntry entry = jarIs.getNextJarEntry();
                        boolean hasMetaInf = false;
                        while (entry != null) {
                            if (!hasMetaInf && entry.getName().startsWith("META-INF/")) {
                                hasMetaInf = true;
                            }
                            this.archiveEntries.put(entry.getName(), entry);
                            entry = jarIs.getNextJarEntry();
                        }
                        this.setManifest(jarIs.getManifest());
                        if (hasMetaInf) {
                            JarEntry metaInfDir = new JarEntry("META-INF/");
                            this.archiveEntries.put(metaInfDir.getName(), metaInfDir);
                        }
                        if (jarIs.getManifest() != null) {
                            JarEntry manifest = new JarEntry("META-INF/MANIFEST.MF");
                            this.archiveEntries.put(manifest.getName(), manifest);
                        }
                    }
                }
                catch (IOException ioe) {
                    this.archiveEntries = null;
                    throw new IllegalStateException(ioe);
                }
                finally {
                    if (warFile != null) {
                        this.closeJarFile();
                    }
                    if (jarFileIs != null) {
                        try {
                            jarFileIs.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            return this.archiveEntries;
        }
    }

    @Override
    protected JarEntry getArchiveEntry(String pathInArchive) {
        throw new IllegalStateException("Coding error");
    }

    @Override
    protected void initInternal() throws LifecycleException {
        try (JarFile warFile = new JarFile(this.getBase());){
            JarEntry jarFileInWar = warFile.getJarEntry(this.archivePath);
            InputStream jarFileIs = warFile.getInputStream(jarFileInWar);
            try (JarInputStream jarIs = new JarInputStream(jarFileIs);){
                this.setManifest(jarIs.getManifest());
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
        try {
            this.setBaseUrl(UriUtil.buildJarSafeUrl(new File(this.getBase())));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

