/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.baserver.utils;

import java.util.ArrayList;
import org.pentaho.di.baserver.utils.CallEndpointData;
import org.pentaho.di.baserver.utils.CallEndpointMeta;
import org.pentaho.di.baserver.utils.inspector.Endpoint;
import org.pentaho.di.baserver.utils.inspector.Inspector;
import org.pentaho.di.baserver.utils.web.Http;
import org.pentaho.di.baserver.utils.web.HttpConnectionHelper;
import org.pentaho.di.baserver.utils.web.HttpParameter;
import org.pentaho.di.baserver.utils.web.Response;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;

public class CallEndpointStep
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = CallEndpointMeta.class;
    private CallEndpointMeta meta;
    private CallEndpointData data;
    private Inspector inspector;
    private HttpConnectionHelper connectionHelper;

    public CallEndpointStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (CallEndpointMeta)smi;
        this.data = (CallEndpointData)sdi;
        this.inspector = Inspector.getInstance();
        this.connectionHelper = HttpConnectionHelper.getInstance();
        this.inspector.refreshSettings(this.meta.getServerURL(), this.meta.getUserName(), this.meta.getPassword());
        return super.init(smi, sdi);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        String httpMethod;
        String endpointPath;
        String moduleName;
        this.meta = (CallEndpointMeta)smi;
        this.data = (CallEndpointData)sdi;
        Object[] rowData = this.getRow();
        if (rowData == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
            this.first = false;
        }
        if (this.meta.isEndpointFromField()) {
            moduleName = this.getRowValue(rowData, this.environmentSubstitute(this.meta.getModuleName()), "");
            endpointPath = this.getRowValue(rowData, this.environmentSubstitute(this.meta.getEndpointPath()), "");
            httpMethod = this.getRowValue(rowData, this.environmentSubstitute(this.meta.getHttpMethod()), "");
        } else {
            moduleName = this.environmentSubstitute(this.meta.getModuleName());
            endpointPath = this.environmentSubstitute(this.meta.getEndpointPath());
            httpMethod = this.environmentSubstitute(this.meta.getHttpMethod());
        }
        if (moduleName == null || endpointPath == null) {
            this.log.logError("Module name or endpoint path is not specified");
            throw new KettleException("Module name or endpoint path is not specified");
        }
        ArrayList<HttpParameter> httpParameters = new ArrayList<HttpParameter>();
        for (int i = 0; i < this.meta.getFieldName().length; ++i) {
            HttpParameter httpParameter = new HttpParameter();
            httpParameter.setName(this.meta.getParameter()[i]);
            httpParameter.setValue(this.getRowValue(rowData, i));
            httpParameters.add(httpParameter);
        }
        Http method = Http.getHttpMethod(httpMethod);
        Endpoint endpoint = this.inspector.getEndpoint(moduleName, endpointPath, method);
        if (endpoint != null) {
            for (HttpParameter httpParameter : httpParameters) {
                HttpParameter.ParamType paramType = endpoint.getParameterType(httpParameter.getName());
                if (paramType == null) continue;
                httpParameter.setParamType(paramType);
            }
        }
        Response response = null;
        if (this.meta.isBypassingAuthentication()) {
            try {
                IPentahoSession session = PentahoSessionHolder.getSession();
                if (session != null) {
                    response = this.connectionHelper.invokeEndpoint(moduleName, endpointPath, httpMethod, httpParameters);
                }
            }
            catch (NoClassDefFoundError ex) {
                this.logBasic("No valid session. Falling back to normal authentication mode.");
            }
        }
        if (response == null) {
            String serverUrl = this.environmentSubstitute(this.meta.getServerURL());
            String username = this.environmentSubstitute(this.meta.getUserName());
            String password = this.environmentSubstitute(this.meta.getPassword());
            response = this.connectionHelper.invokeEndpoint(serverUrl, username, password, moduleName, endpointPath, httpMethod, httpParameters);
        }
        int index = this.getInputRowMeta().size();
        rowData = RowDataUtil.addValueData((Object[])rowData, (int)index++, (Object)response.getResult());
        rowData = RowDataUtil.addValueData((Object[])rowData, (int)index++, (Object)response.getStatusCode());
        rowData = RowDataUtil.addValueData((Object[])rowData, (int)index, (Object)response.getResponseTime());
        this.putRow(this.data.outputRowMeta, rowData);
        return true;
    }

    protected String getRowValue(Object[] rowData, String fieldName, String defaultValue) throws KettleException {
        int index = this.getInputRowMeta().indexOfValue(fieldName);
        if (index >= 0) {
            ValueMetaInterface valueMeta = this.getInputRowMeta().getValueMeta(index);
            return valueMeta.getCompatibleString(rowData[index]);
        }
        return defaultValue;
    }

    String getRowValue(Object[] rowData, int i) throws KettleException {
        String fieldName = this.meta.getFieldName()[i];
        if (!Const.isEmpty((String)fieldName)) {
            int index = this.getInputRowMeta().indexOfValue(fieldName);
            if (index >= 0) {
                ValueMetaInterface valueMeta = this.getInputRowMeta().getValueMeta(index);
                Object valueData = rowData[index];
                return valueMeta.getCompatibleString(valueData);
            }
            this.logBasic(BaseMessages.getString(PKG, (String)"CallEndpoint.Log.UnableToFindFieldUsingDefault", (String[])new String[]{fieldName, this.getRowDefaultValue(i)}));
        }
        return this.getRowDefaultValue(i);
    }

    private String getRowDefaultValue(int i) {
        return this.environmentSubstitute(this.meta.getDefaultValue()[i]);
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (CallEndpointMeta)smi;
        this.data = (CallEndpointData)sdi;
        super.dispose(smi, sdi);
    }
}

