/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api.analyzer.kettle.step;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.StepField;

public class StepNodes {
    private LinkedHashMap<String, LinkedHashMap<String, IMetaverseNode>> store = new LinkedHashMap();

    public void addNode(String stepName, String fieldName, IMetaverseNode node) {
        if (!this.store.containsKey(stepName)) {
            this.store.put(stepName, new LinkedHashMap());
        }
        Map stepFields = this.store.get(stepName);
        stepFields.put(fieldName, node);
    }

    public List<IMetaverseNode> findNodes(String fieldName) {
        ArrayList<IMetaverseNode> nodes = new ArrayList<IMetaverseNode>();
        for (Map map : this.store.values()) {
            IMetaverseNode match = (IMetaverseNode)map.get(fieldName);
            if (match == null) continue;
            nodes.add(match);
        }
        return nodes;
    }

    public IMetaverseNode findNode(StepField stepField) {
        return this.findNode(stepField.getStepName(), stepField.getFieldName());
    }

    public IMetaverseNode findNode(String stepName, String fieldName) {
        IMetaverseNode node = null;
        Map stepNodes = this.store.get(stepName);
        if (stepNodes != null) {
            node = (IMetaverseNode)stepNodes.get(fieldName);
        }
        return node;
    }

    public Set<String> getStepNames() {
        return this.store.keySet();
    }

    public Set<String> getFieldNames(String stepName) {
        Map stepNodes = this.store.get(stepName);
        Set fieldNames = null;
        if (stepNodes != null) {
            fieldNames = stepNodes.keySet();
        }
        return fieldNames;
    }

    public Set<StepField> getFieldNames() {
        LinkedHashSet<StepField> fieldNames = new LinkedHashSet<StepField>();
        for (String stepName : this.getStepNames()) {
            Set<String> names = this.getFieldNames(stepName);
            for (String name : names) {
                fieldNames.add(new StepField(stepName, name));
            }
        }
        return fieldNames;
    }
}

