/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceWeights;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.VisitedResourceRequestTracker;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FSAppAttempt
extends SchedulerApplicationAttempt
implements Schedulable {
    private static final Log LOG = LogFactory.getLog(FSAppAttempt.class);
    private static final DefaultResourceCalculator RESOURCE_CALCULATOR = new DefaultResourceCalculator();
    private final long startTime;
    private final Priority appPriority;
    private final ResourceWeights resourceWeights;
    private Resource demand = Resources.createResource((int)0);
    private final FairScheduler scheduler;
    private Resource fairShare = Resources.createResource((int)0, (int)0);
    private final Object preemptionVariablesLock = new Object();
    private final Resource preemptedResources = Resources.clone((Resource)Resources.none());
    private final Set<RMContainer> containersToPreempt = new HashSet<RMContainer>();
    private Resource fairshareStarvation = Resources.none();
    private long lastTimeAtFairShare;
    private long nextStarvationCheck;
    private Resource minshareStarvation = Resources.none();
    private final Map<String, Set<String>> reservations = new HashMap<String, Set<String>>();
    private final List<FSSchedulerNode> blacklistNodeIds = new ArrayList<FSSchedulerNode>();
    private final Map<Priority, NodeType> allowedLocalityLevel = new HashMap<Priority, NodeType>();

    public FSAppAttempt(FairScheduler scheduler, ApplicationAttemptId applicationAttemptId, String user, FSLeafQueue queue, ActiveUsersManager activeUsersManager, RMContext rmContext) {
        super(applicationAttemptId, user, queue, activeUsersManager, rmContext);
        this.scheduler = scheduler;
        this.lastTimeAtFairShare = this.startTime = scheduler.getClock().getTime();
        this.appPriority = Priority.newInstance((int)1);
        this.resourceWeights = new ResourceWeights();
    }

    ResourceWeights getResourceWeights() {
        return this.resourceWeights;
    }

    public QueueMetrics getMetrics() {
        return this.queue.getMetrics();
    }

    synchronized void containerCompleted(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        Container container = rmContainer.getContainer();
        ContainerId containerId = container.getId();
        if (this.liveContainers.remove(containerId) == null) {
            LOG.info((Object)("Additional complete request on completed container " + rmContainer.getContainerId()));
            return;
        }
        this.newlyAllocatedContainers.remove(rmContainer);
        rmContainer.handle((Event)new RMContainerFinishedEvent(containerId, containerStatus, event));
        LOG.info((Object)("Completed container: " + rmContainer.getContainerId() + " in state: " + (Object)((Object)rmContainer.getState()) + " event:" + (Object)((Object)event)));
        this.untrackContainerForPreemption(rmContainer);
        if (containerStatus.getDiagnostics().equals("Container preempted by scheduler")) {
            this.queue.getMetrics().preemptContainer();
        }
        RMAuditLogger.logSuccess(this.getUser(), "AM Released Container", "SchedulerApp", this.getApplicationId(), containerId);
        Resource containerResource = rmContainer.getContainer().getResource();
        this.queue.getMetrics().releaseResources(this.getUser(), 1, containerResource);
        Resources.subtractFrom((Resource)this.currentConsumption, (Resource)containerResource);
        this.lastMemoryAggregateAllocationUpdateTime = -1L;
    }

    private synchronized void unreserveInternal(Priority priority, FSSchedulerNode node) {
        Map reservedContainers = (Map)this.reservedContainers.get(priority);
        RMContainer reservedContainer = (RMContainer)reservedContainers.remove(node.getNodeID());
        if (reservedContainers.isEmpty()) {
            this.reservedContainers.remove(priority);
        }
        this.resetReReservations(priority);
        Resource resource = reservedContainer.getContainer().getResource();
        Resources.subtractFrom((Resource)this.currentReservation, (Resource)resource);
        LOG.info((Object)("Application " + this.getApplicationId() + " unreserved " + " on node " + node + ", currently has " + reservedContainers.size() + " at priority " + priority + "; currentReservation " + this.currentReservation));
    }

    private void subtractResourcesOnBlacklistedNodes(Resource availableResources) {
        if (this.appSchedulingInfo.getAndResetBlacklistChanged()) {
            this.blacklistNodeIds.clear();
            this.blacklistNodeIds.addAll(this.scheduler.getBlacklistedNodes(this));
        }
        for (FSSchedulerNode node : this.blacklistNodeIds) {
            Resources.subtractFromNonNegative((Resource)availableResources, (Resource)node.getAvailableResource());
        }
    }

    @Override
    public Resource getHeadroom() {
        FSLeafQueue fsQueue = this.getQueue();
        SchedulingPolicy policy = fsQueue.getPolicy();
        Resource queueFairShare = fsQueue.getFairShare();
        Resource queueUsage = fsQueue.getResourceUsage();
        Resource clusterResource = this.scheduler.getClusterResource();
        Resource clusterUsage = this.scheduler.getRootQueueMetrics().getAllocatedResources();
        Resource clusterAvailableResources = Resources.subtract((Resource)clusterResource, (Resource)clusterUsage);
        this.subtractResourcesOnBlacklistedNodes(clusterAvailableResources);
        Resource queueMaxAvailableResources = Resources.subtract((Resource)fsQueue.getMaxShare(), (Resource)queueUsage);
        Resource maxAvailableResource = Resources.componentwiseMin((Resource)clusterAvailableResources, (Resource)queueMaxAvailableResources);
        Resource headroom = policy.getHeadroom(queueFairShare, queueUsage, maxAvailableResource);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Headroom calculation for " + this.getName() + ":" + "Min(" + "(queueFairShare=" + queueFairShare + " - queueUsage=" + queueUsage + ")," + " maxAvailableResource=" + maxAvailableResource + "Headroom=" + headroom));
        }
        return headroom;
    }

    public synchronized float getLocalityWaitFactor(Priority priority, int clusterNodes) {
        int requiredResources = Math.max(this.getResourceRequests(priority).size() - 1, 0);
        return Math.min((float)requiredResources / (float)clusterNodes, 1.0f);
    }

    public synchronized NodeType getAllowedLocalityLevel(Priority priority, int numNodes, double nodeLocalityThreshold, double rackLocalityThreshold) {
        double threshold;
        if (nodeLocalityThreshold > 1.0) {
            nodeLocalityThreshold = 1.0;
        }
        if (rackLocalityThreshold > 1.0) {
            rackLocalityThreshold = 1.0;
        }
        if (nodeLocalityThreshold < 0.0 || rackLocalityThreshold < 0.0) {
            return NodeType.OFF_SWITCH;
        }
        if (!this.allowedLocalityLevel.containsKey(priority)) {
            this.allowedLocalityLevel.put(priority, NodeType.NODE_LOCAL);
            return NodeType.NODE_LOCAL;
        }
        NodeType allowed = this.allowedLocalityLevel.get(priority);
        if (allowed.equals((Object)NodeType.OFF_SWITCH)) {
            return NodeType.OFF_SWITCH;
        }
        double d = threshold = allowed.equals((Object)NodeType.NODE_LOCAL) ? nodeLocalityThreshold : rackLocalityThreshold;
        if ((double)this.getSchedulingOpportunities(priority) > (double)numNodes * threshold) {
            if (allowed.equals((Object)NodeType.NODE_LOCAL)) {
                this.allowedLocalityLevel.put(priority, NodeType.RACK_LOCAL);
                this.resetSchedulingOpportunities(priority);
            } else if (allowed.equals((Object)NodeType.RACK_LOCAL)) {
                this.allowedLocalityLevel.put(priority, NodeType.OFF_SWITCH);
                this.resetSchedulingOpportunities(priority);
            }
        }
        return this.allowedLocalityLevel.get(priority);
    }

    public synchronized NodeType getAllowedLocalityLevelByTime(Priority priority, long nodeLocalityDelayMs, long rackLocalityDelayMs, long currentTimeMs) {
        long thresholdTime;
        if (nodeLocalityDelayMs < 0L || rackLocalityDelayMs < 0L) {
            return NodeType.OFF_SWITCH;
        }
        if (!this.allowedLocalityLevel.containsKey(priority)) {
            this.lastScheduledContainer.put(priority, currentTimeMs);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Init the lastScheduledContainer time, priority: " + priority + ", time: " + currentTimeMs));
            }
            this.allowedLocalityLevel.put(priority, NodeType.NODE_LOCAL);
            return NodeType.NODE_LOCAL;
        }
        NodeType allowed = this.allowedLocalityLevel.get(priority);
        if (allowed.equals((Object)NodeType.OFF_SWITCH)) {
            return NodeType.OFF_SWITCH;
        }
        long waitTime = currentTimeMs;
        waitTime = this.lastScheduledContainer.containsKey(priority) ? (waitTime -= ((Long)this.lastScheduledContainer.get(priority)).longValue()) : (waitTime -= this.getStartTime());
        long l = thresholdTime = allowed.equals((Object)NodeType.NODE_LOCAL) ? nodeLocalityDelayMs : rackLocalityDelayMs;
        if (waitTime > thresholdTime) {
            if (allowed.equals((Object)NodeType.NODE_LOCAL)) {
                this.allowedLocalityLevel.put(priority, NodeType.RACK_LOCAL);
                this.resetSchedulingOpportunities(priority, currentTimeMs);
            } else if (allowed.equals((Object)NodeType.RACK_LOCAL)) {
                this.allowedLocalityLevel.put(priority, NodeType.OFF_SWITCH);
                this.resetSchedulingOpportunities(priority, currentTimeMs);
            }
        }
        return this.allowedLocalityLevel.get(priority);
    }

    public synchronized RMContainer allocate(NodeType type, FSSchedulerNode node, Priority priority, ResourceRequest request, Container reservedContainer) {
        NodeType allowed = this.allowedLocalityLevel.get(priority);
        if (allowed != null) {
            if (allowed.equals((Object)NodeType.OFF_SWITCH) && (type.equals((Object)NodeType.NODE_LOCAL) || type.equals((Object)NodeType.RACK_LOCAL))) {
                this.resetAllowedLocalityLevel(priority, type);
            } else if (allowed.equals((Object)NodeType.RACK_LOCAL) && type.equals((Object)NodeType.NODE_LOCAL)) {
                this.resetAllowedLocalityLevel(priority, type);
            }
        }
        if (this.getTotalRequiredResources(priority) <= 0) {
            return null;
        }
        Container container = reservedContainer;
        if (container == null) {
            container = this.createContainer(node, request.getCapability(), request.getPriority());
        }
        RMContainerImpl rmContainer = new RMContainerImpl(container, this.getApplicationAttemptId(), node.getNodeID(), this.appSchedulingInfo.getUser(), this.rmContext);
        this.newlyAllocatedContainers.add(rmContainer);
        this.liveContainers.put(container.getId(), rmContainer);
        List<ResourceRequest> resourceRequestList = this.appSchedulingInfo.allocate(type, node, priority, request, container);
        Resources.addTo((Resource)this.currentConsumption, (Resource)container.getResource());
        rmContainer.setResourceRequests(resourceRequestList);
        rmContainer.handle((Event)new RMContainerEvent(container.getId(), RMContainerEventType.START));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("allocate: applicationAttemptId=" + container.getId().getApplicationAttemptId() + " container=" + container.getId() + " host=" + container.getNodeId().getHost() + " type=" + (Object)((Object)type)));
        }
        RMAuditLogger.logSuccess(this.getUser(), "AM Allocated Container", "SchedulerApp", this.getApplicationId(), container.getId());
        return rmContainer;
    }

    synchronized void resetAllowedLocalityLevel(Priority priority, NodeType level) {
        NodeType old = this.allowedLocalityLevel.get(priority);
        LOG.info((Object)("Raising locality level from " + (Object)((Object)old) + " to " + (Object)((Object)level) + " at " + " priority " + priority));
        this.allowedLocalityLevel.put(priority, level);
    }

    @Override
    public FSLeafQueue getQueue() {
        return (FSLeafQueue)this.queue;
    }

    Resource getStarvation() {
        return Resources.add((Resource)this.fairshareStarvation, (Resource)this.minshareStarvation);
    }

    Resource getFairshareStarvation() {
        return this.fairshareStarvation;
    }

    void setMinshareStarvation(Resource starvation) {
        this.minshareStarvation = starvation;
    }

    void resetMinshareStarvation() {
        this.minshareStarvation = Resources.none();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void trackContainerForPreemption(RMContainer container) {
        Object object = this.preemptionVariablesLock;
        synchronized (object) {
            if (this.containersToPreempt.add(container)) {
                Resources.addTo((Resource)this.preemptedResources, (Resource)container.getAllocatedResource());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void untrackContainerForPreemption(RMContainer container) {
        Object object = this.preemptionVariablesLock;
        synchronized (object) {
            if (this.containersToPreempt.remove(container)) {
                Resources.subtractFrom((Resource)this.preemptedResources, (Resource)container.getAllocatedResource());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<ContainerId> getPreemptionContainerIds() {
        Object object = this.preemptionVariablesLock;
        synchronized (object) {
            HashSet<ContainerId> preemptionContainerIds = new HashSet<ContainerId>();
            for (RMContainer container : this.containersToPreempt) {
                preemptionContainerIds.add(container.getContainerId());
            }
            return preemptionContainerIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canContainerBePreempted(RMContainer container) {
        if (!this.getLiveContainersMap().containsKey(container.getContainerId()) && !this.newlyAllocatedContainers.contains(container)) {
            LOG.error((Object)("Looking to preempt container " + container + ". Container does not belong to app " + this.getApplicationId()));
            return false;
        }
        Object object = this.preemptionVariablesLock;
        synchronized (object) {
            if (this.containersToPreempt.contains(container)) {
                return false;
            }
        }
        FSQueue q = this.getQueue();
        while (!q.getQueueName().equals("root")) {
            if (!q.isPreemptable()) {
                return false;
            }
            q = q.getParent();
        }
        Resource usageAfterPreemption = Resources.subtract((Resource)this.getResourceUsage(), (Resource)container.getAllocatedResource());
        return !this.isUsageBelowShare(usageAfterPreemption, this.getFairShare());
    }

    private Container createContainer(FSSchedulerNode node, Resource capability, Priority priority) {
        NodeId nodeId = node.getRMNode().getNodeID();
        ContainerId containerId = BuilderUtils.newContainerId((ApplicationAttemptId)this.getApplicationAttemptId(), (long)this.getNewContainerId());
        return BuilderUtils.newContainer((ContainerId)containerId, (NodeId)nodeId, (String)node.getRMNode().getHttpAddress(), (Resource)capability, (Priority)priority, null);
    }

    private boolean reserve(ResourceRequest request, FSSchedulerNode node, Container reservedContainer, NodeType type) {
        boolean reservableForThisApp;
        Priority priority = request.getPriority();
        RMContainer nodeReservedContainer = node.getReservedContainer();
        boolean bl = reservableForThisApp = nodeReservedContainer == null || nodeReservedContainer.getApplicationAttemptId().equals((Object)this.getApplicationAttemptId());
        if (reservableForThisApp && !this.reservationExceedsThreshold(node, type)) {
            LOG.info((Object)("Making reservation: node=" + node.getNodeName() + " app_id=" + this.getApplicationId()));
            if (reservedContainer == null) {
                reservedContainer = this.createContainer(node, request.getCapability(), request.getPriority());
                this.getMetrics().reserveResource(this.getUser(), reservedContainer.getResource());
                RMContainer rmContainer = super.reserve(node, priority, null, reservedContainer);
                node.reserveResource(this, priority, rmContainer);
                this.setReservation(node);
            } else {
                RMContainer rmContainer = node.getReservedContainer();
                super.reserve(node, priority, rmContainer, reservedContainer);
                node.reserveResource(this, priority, rmContainer);
                this.setReservation(node);
            }
            return true;
        }
        return false;
    }

    private boolean reservationExceedsThreshold(FSSchedulerNode node, NodeType type) {
        int totalAvailNodes;
        int numAllowedReservations;
        int existingReservations;
        if (type != NodeType.NODE_LOCAL && (existingReservations = this.getNumReservations(node.getRackName(), type == NodeType.OFF_SWITCH)) >= (numAllowedReservations = (int)Math.ceil((float)(totalAvailNodes = type == NodeType.OFF_SWITCH ? this.scheduler.getNumClusterNodes() : this.scheduler.getNumNodesInRack(node.getRackName())) * this.scheduler.getReservableNodesRatio()))) {
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Reservation Exceeds Allowed number of nodes: app_id=" + this.getApplicationId() + " existingReservations=" + existingReservations + " totalAvailableNodes=" + totalAvailNodes + " reservableNodesRatio=" + df.format(this.scheduler.getReservableNodesRatio()) + " numAllowedReservations=" + numAllowedReservations));
            }
            return true;
        }
        return false;
    }

    public void unreserve(Priority priority, FSSchedulerNode node) {
        RMContainer rmContainer = node.getReservedContainer();
        this.unreserveInternal(priority, node);
        node.unreserveResource(this);
        this.clearReservation(node);
        this.getMetrics().unreserveResource(this.getUser(), rmContainer.getContainer().getResource());
    }

    private synchronized void setReservation(SchedulerNode node) {
        String rackName = node.getRackName() == null ? "NULL" : node.getRackName();
        Set<String> rackReservations = this.reservations.get(rackName);
        if (rackReservations == null) {
            rackReservations = new HashSet<String>();
            this.reservations.put(rackName, rackReservations);
        }
        rackReservations.add(node.getNodeName());
    }

    private synchronized void clearReservation(SchedulerNode node) {
        String rackName = node.getRackName() == null ? "NULL" : node.getRackName();
        Set<String> rackReservations = this.reservations.get(rackName);
        if (rackReservations != null) {
            rackReservations.remove(node.getNodeName());
        }
    }

    int getNumReservations(String rackName, boolean isAny) {
        int counter = 0;
        if (isAny) {
            for (Set<String> nodes : this.reservations.values()) {
                if (nodes == null) continue;
                counter += nodes.size();
            }
        } else {
            Set<String> nodes = this.reservations.get(rackName == null ? "NULL" : rackName);
            if (nodes != null) {
                counter += nodes.size();
            }
        }
        return counter;
    }

    private Resource assignContainer(FSSchedulerNode node, ResourceRequest request, NodeType type, boolean reserved) {
        Resource capability = request.getCapability();
        Resource available = node.getAvailableResource();
        Container reservedContainer = null;
        if (reserved) {
            reservedContainer = node.getReservedContainer().getContainer();
        }
        if (Resources.fitsIn((Resource)capability, (Resource)available)) {
            RMContainer allocatedContainer = this.allocate(type, node, request.getPriority(), request, reservedContainer);
            if (allocatedContainer == null) {
                if (reserved) {
                    this.unreserve(request.getPriority(), node);
                }
                return Resources.none();
            }
            if (reserved) {
                this.unreserve(request.getPriority(), node);
            }
            node.allocateContainer(allocatedContainer);
            if (!this.isAmRunning() && !this.getUnmanagedAM()) {
                this.setAMResource(capability);
                this.getQueue().addAMResourceUsage(capability);
                this.setAmRunning(true);
            }
            return capability;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Resource request: " + capability + " exceeds the available" + " resources of the node."));
        }
        if (this.isReservable(capability) && this.reserve(request, node, reservedContainer, type)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + "'s resource request is reserved."));
            }
            return FairScheduler.CONTAINER_RESERVED;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Couldn't create reservation for app:  " + this.getName() + ", at priority " + request.getPriority()));
        }
        return Resources.none();
    }

    private boolean isReservable(Resource capacity) {
        return this.isStarved() && this.scheduler.isAtLeastReservationThreshold(this.getQueue().getPolicy().getResourceCalculator(), capacity);
    }

    private boolean hasNodeOrRackLocalRequests(Priority priority) {
        return this.getResourceRequests(priority).size() > 1;
    }

    private boolean isOverAMShareLimit() {
        List<ResourceRequest> ask;
        return !this.isAmRunning() && !this.getUnmanagedAM() && ((ask = this.appSchedulingInfo.getAllResourceRequests()).isEmpty() || !this.getQueue().canRunAppAM(ask.get(0).getCapability()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource assignContainer(FSSchedulerNode node, boolean reserved) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Node offered to app: " + this.getName() + " reserved: " + reserved));
        }
        Collection<Priority> prioritiesToTry = reserved ? Arrays.asList(node.getReservedContainer().getReservedPriority()) : this.getPriorities();
        FSAppAttempt fSAppAttempt = this;
        synchronized (fSAppAttempt) {
            for (Priority priority : prioritiesToTry) {
                if (!reserved && !this.hasContainerForNode(priority, node)) continue;
                this.addSchedulingOpportunity(priority);
                ResourceRequest rackLocalRequest = this.getResourceRequest(priority, node.getRackName());
                ResourceRequest localRequest = this.getResourceRequest(priority, node.getNodeName());
                if (localRequest != null && !localRequest.getRelaxLocality()) {
                    LOG.warn((Object)("Relax locality off is not supported on local request: " + localRequest));
                }
                NodeType allowedLocality = this.scheduler.isContinuousSchedulingEnabled() ? this.getAllowedLocalityLevelByTime(priority, this.scheduler.getNodeLocalityDelayMs(), this.scheduler.getRackLocalityDelayMs(), this.scheduler.getClock().getTime()) : this.getAllowedLocalityLevel(priority, this.scheduler.getNumClusterNodes(), this.scheduler.getNodeLocalityThreshold(), this.scheduler.getRackLocalityThreshold());
                if (rackLocalRequest != null && rackLocalRequest.getNumContainers() != 0 && localRequest != null && localRequest.getNumContainers() != 0) {
                    return this.assignContainer(node, localRequest, NodeType.NODE_LOCAL, reserved);
                }
                if (rackLocalRequest != null && !rackLocalRequest.getRelaxLocality()) continue;
                if (rackLocalRequest != null && rackLocalRequest.getNumContainers() != 0 && (allowedLocality.equals((Object)NodeType.RACK_LOCAL) || allowedLocality.equals((Object)NodeType.OFF_SWITCH))) {
                    return this.assignContainer(node, rackLocalRequest, NodeType.RACK_LOCAL, reserved);
                }
                ResourceRequest offSwitchRequest = this.getResourceRequest(priority, "*");
                if (offSwitchRequest != null && !offSwitchRequest.getRelaxLocality() || offSwitchRequest == null || offSwitchRequest.getNumContainers() == 0 || this.hasNodeOrRackLocalRequests(priority) && !allowedLocality.equals((Object)NodeType.OFF_SWITCH)) continue;
                return this.assignContainer(node, offSwitchRequest, NodeType.OFF_SWITCH, reserved);
            }
        }
        return Resources.none();
    }

    private boolean hasContainerForNode(Priority prio, FSSchedulerNode node) {
        ResourceRequest anyRequest = this.getResourceRequest(prio, "*");
        ResourceRequest rackRequest = this.getResourceRequest(prio, node.getRackName());
        ResourceRequest nodeRequest = this.getResourceRequest(prio, node.getNodeName());
        return anyRequest != null && anyRequest.getNumContainers() > 0 && (anyRequest.getRelaxLocality() || rackRequest != null && rackRequest.getNumContainers() > 0) && (rackRequest == null || rackRequest.getRelaxLocality() || nodeRequest != null && nodeRequest.getNumContainers() > 0) && Resources.lessThanOrEqual((ResourceCalculator)RESOURCE_CALCULATOR, null, (Resource)anyRequest.getCapability(), (Resource)node.getRMNode().getTotalCapability()) && this.getQueue().fitsInMaxShare(anyRequest.getCapability());
    }

    private boolean isValidReservation(FSSchedulerNode node) {
        Priority reservedPriority = node.getReservedContainer().getReservedPriority();
        return this.hasContainerForNode(reservedPriority, node) && !this.isOverAMShareLimit();
    }

    boolean assignReservedContainer(FSSchedulerNode node) {
        RMContainer rmContainer = node.getReservedContainer();
        Priority reservedPriority = rmContainer.getReservedPriority();
        if (!this.isValidReservation(node)) {
            LOG.info((Object)("Releasing reservation that cannot be satisfied for application " + this.getApplicationAttemptId() + " on node " + node));
            this.unreserve(reservedPriority, node);
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Trying to fulfill reservation for application " + this.getApplicationAttemptId() + " on node: " + node));
        }
        if (Resources.fitsIn((Resource)node.getReservedContainer().getReservedResource(), (Resource)node.getAvailableResource())) {
            this.assignContainer(node, true);
        }
        return true;
    }

    Resource fairShareStarvation() {
        long now = this.scheduler.getClock().getTime();
        Resource threshold = Resources.multiply((Resource)this.getFairShare(), (double)this.getQueue().getFairSharePreemptionThreshold());
        Resource fairDemand = Resources.componentwiseMin((Resource)threshold, (Resource)this.demand);
        boolean starved = this.isUsageBelowShare(this.getResourceUsage(), fairDemand);
        if (!starved) {
            this.lastTimeAtFairShare = now;
        }
        this.fairshareStarvation = !starved || now - this.lastTimeAtFairShare < this.getQueue().getFairSharePreemptionTimeout() ? Resources.none() : Resources.subtractFromNonNegative((Resource)fairDemand, (Resource)this.getResourceUsage());
        return this.fairshareStarvation;
    }

    private boolean isUsageBelowShare(Resource usage, Resource share) {
        return this.getQueue().getPolicy().getResourceCalculator().compare(this.scheduler.getClusterResource(), usage, share, true) < 0;
    }

    ResourceRequest getNextResourceRequest() {
        return this.appSchedulingInfo.getNextResourceRequest();
    }

    boolean isStarvedForFairShare() {
        return this.isUsageBelowShare(this.getResourceUsage(), this.getFairShare());
    }

    boolean isStarved() {
        return this.isStarvedForFairShare() || !Resources.isNone((Resource)this.minshareStarvation);
    }

    List<ResourceRequest> getStarvedResourceRequests() {
        ArrayList<ResourceRequest> ret = new ArrayList<ResourceRequest>();
        VisitedResourceRequestTracker visitedRRs = new VisitedResourceRequestTracker(this.scheduler.getNodeTracker());
        Resource pending = this.getStarvation();
        for (ResourceRequest rr : this.appSchedulingInfo.getAllResourceRequests()) {
            int numContainersThatFit;
            if (Resources.isNone((Resource)pending)) break;
            if (!visitedRRs.visit(rr) || (numContainersThatFit = (int)Math.floor(Resources.ratio((ResourceCalculator)this.scheduler.getResourceCalculator(), (Resource)pending, (Resource)rr.getCapability()))) == 0) continue;
            if (numContainersThatFit < rr.getNumContainers()) {
                rr = ResourceRequest.newInstance((Priority)rr.getPriority(), (String)rr.getResourceName(), (Resource)rr.getCapability(), (int)numContainersThatFit);
            }
            ret.add(rr);
            Resources.subtractFromNonNegative((Resource)pending, (Resource)Resources.multiply((Resource)rr.getCapability(), (double)rr.getNumContainers()));
        }
        return ret;
    }

    void preemptionTriggered(long delayBeforeNextStarvationCheck) {
        this.nextStarvationCheck = this.scheduler.getClock().getTime() + delayBeforeNextStarvationCheck;
    }

    boolean shouldCheckForStarvation() {
        return this.scheduler.getClock().getTime() >= this.nextStarvationCheck;
    }

    @Override
    public String getName() {
        return this.getApplicationId().toString();
    }

    @Override
    public Resource getDemand() {
        return this.demand;
    }

    Resource getPendingDemand() {
        return Resources.subtract((Resource)this.demand, (Resource)this.getResourceUsage());
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public Resource getMinShare() {
        return Resources.none();
    }

    @Override
    public Resource getMaxShare() {
        return Resources.unbounded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource getResourceUsage() {
        Object object = this.preemptionVariablesLock;
        synchronized (object) {
            return this.containersToPreempt.isEmpty() ? this.getCurrentConsumption() : Resources.subtract((Resource)this.getCurrentConsumption(), (Resource)this.preemptedResources);
        }
    }

    @Override
    public ResourceWeights getWeights() {
        return this.scheduler.getAppWeight(this);
    }

    @Override
    public Priority getPriority() {
        return this.appPriority;
    }

    @Override
    public Resource getFairShare() {
        return this.fairShare;
    }

    @Override
    public void setFairShare(Resource fairShare) {
        this.fairShare = fairShare;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDemand() {
        this.demand = Resources.createResource((int)0);
        Resources.addTo((Resource)this.demand, (Resource)this.getCurrentConsumption());
        FSAppAttempt fSAppAttempt = this;
        synchronized (fSAppAttempt) {
            for (Priority p : this.getPriorities()) {
                ResourceRequest r = this.getResourceRequest(p, "*");
                if (r == null) continue;
                Resources.multiplyAndAddTo((Resource)this.demand, (Resource)r.getCapability(), (double)r.getNumContainers());
            }
        }
    }

    @Override
    public Resource assignContainer(FSSchedulerNode node) {
        if (this.isOverAMShareLimit()) {
            List<ResourceRequest> ask = this.appSchedulingInfo.getAllResourceRequests();
            Resource amResourceRequest = Resources.none();
            if (!ask.isEmpty()) {
                amResourceRequest = ask.get(0).getCapability();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("AM resource request: " + amResourceRequest + " exceeds maximum AM resource allowed, " + this.getQueue().dumpState()));
            }
            return Resources.none();
        }
        return this.assignContainer(node, false);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    public String toString() {
        return this.getApplicationAttemptId() + " Alloc: " + this.getCurrentConsumption();
    }
}

