/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.be.ibridge.kettle.dummy;

import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.be.ibridge.kettle.dummy.DummyPlugin;
import org.pentaho.di.be.ibridge.kettle.dummy.DummyPluginData;
import org.pentaho.di.be.ibridge.kettle.dummy.DummyPluginDialog;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaAndData;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.row.value.ValueMetaNumber;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.w3c.dom.Node;

@Step(id="DummyStep", image="DPL.svg", i18nPackageName="be.ibridge.kettle.dummy", name="DummyPlugin.Step.Name", description="DummyPlugin.Step.Description", categoryDescription="Deprecated")
public class DummyPluginMeta
extends BaseStepMeta
implements StepMetaInterface {
    private ValueMetaAndData value;

    public ValueMetaAndData getValue() {
        return this.value;
    }

    public void setValue(ValueMetaAndData value) {
        this.value = value;
    }

    public String getXML() throws KettleException {
        String retval = "";
        retval = retval + "    <values>" + Const.CR;
        if (this.value != null) {
            retval = retval + this.value.getXML();
        }
        retval = retval + "      </values>" + Const.CR;
        return retval;
    }

    public void getFields(RowMetaInterface r, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) {
        if (this.value != null) {
            ValueMetaInterface v = this.value.getValueMeta();
            v.setOrigin(origin);
            r.addValueMeta(v);
        }
    }

    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        try {
            this.value = new ValueMetaAndData();
            Node valnode = XMLHandler.getSubNode((Node)stepnode, (String)"values", (String)"value");
            if (valnode != null) {
                System.out.println("reading value in " + valnode);
                this.value.loadXML(valnode);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to read step info from XML node", (Throwable)e);
        }
    }

    public void setDefault() {
        this.value = new ValueMetaAndData((ValueMetaInterface)new ValueMetaNumber("valuename"), (Object)new Double(123.456));
        this.value.getValueMeta().setLength(12);
        this.value.getValueMeta().setPrecision(4);
    }

    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            String name = rep.getStepAttributeString(id_step, 0, "value_name");
            String typedesc = rep.getStepAttributeString(id_step, 0, "value_type");
            String text = rep.getStepAttributeString(id_step, 0, "value_text");
            boolean isnull = rep.getStepAttributeBoolean(id_step, 0, "value_null");
            int length = (int)rep.getStepAttributeInteger(id_step, 0, "value_length");
            int precision = (int)rep.getStepAttributeInteger(id_step, 0, "value_precision");
            int type = ValueMetaFactory.getIdForValueMeta((String)typedesc);
            this.value = new ValueMetaAndData((ValueMetaInterface)new ValueMeta(name, type), null);
            this.value.getValueMeta().setLength(length);
            this.value.getValueMeta().setPrecision(precision);
            if (isnull) {
                this.value.setValueData(null);
            } else {
                ValueMetaString stringMeta = new ValueMetaString(name);
                if (type != 2) {
                    text = Const.trim((String)text);
                }
                this.value.setValueData(this.value.getValueMeta().convertData((ValueMetaInterface)stringMeta, (Object)text));
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("error reading step with id_step=" + id_step + " from the repository", (Throwable)dbe);
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step with id_step=" + id_step + " from the repository", (Throwable)e);
        }
    }

    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "value_name", this.value.getValueMeta().getName());
            rep.saveStepAttribute(id_transformation, id_step, 0, "value_type", this.value.getValueMeta().getTypeDesc());
            rep.saveStepAttribute(id_transformation, id_step, 0, "value_text", this.value.getValueMeta().getString(this.value.getValueData()));
            rep.saveStepAttribute(id_transformation, id_step, 0, "value_null", this.value.getValueMeta().isNull(this.value.getValueData()));
            rep.saveStepAttribute(id_transformation, id_step, 0, "value_length", (long)this.value.getValueMeta().getLength());
            rep.saveStepAttribute(id_transformation, id_step, 0, "value_precision", (long)this.value.getValueMeta().getPrecision());
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save step information to the repository, id_step=" + id_step, (Throwable)dbe);
        }
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transmeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, "Not receiving any fields from previous steps!", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, "Step is connected to previous one, receiving " + prev.size() + " fields", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public StepDialogInterface getDialog(Shell shell, StepMetaInterface meta, TransMeta transMeta, String name) {
        return new DummyPluginDialog(shell, meta, transMeta, name);
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans disp) {
        return new DummyPlugin(stepMeta, stepDataInterface, cnr, transMeta, disp);
    }

    public StepDataInterface getStepData() {
        return new DummyPluginData();
    }
}

